/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.gui.tree.ButtonTab;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.net.edit.MessageMoveChapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class ButtonChapter
extends ButtonTab {
    public int index;
    public QuestChapter chapter;
    public List<String> description;

    public ButtonChapter(Panel panel, int idx, QuestChapter c) {
        super(panel, StringUtils.addFormatting((String)c.getDisplayName().func_150254_d()), c.getIcon());
        this.index = idx;
        this.chapter = c;
        this.description = new ArrayList<String>();
        for (String v : this.chapter.description) {
            this.description.add(TextFormatting.GRAY + StringUtils.addFormatting((String)v));
        }
    }

    public void onClicked(MouseButton button) {
        GuiHelper.playClickSound();
        this.treeGui.selectChapter(this.chapter);
        if (this.treeGui.file.canEdit() && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"gui.move", (Object[])new Object[0]), GuiIcons.LEFT, () -> new MessageMoveChapter(this.chapter.id, true).sendToServer()).setEnabled(() -> this.chapter.getIndex() > 0).setCloseMenu(false));
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"gui.move", (Object[])new Object[0]), GuiIcons.RIGHT, () -> new MessageMoveChapter(this.chapter.id, false).sendToServer()).setEnabled(() -> this.chapter.getIndex() < this.treeGui.file.chapters.size() - 1).setCloseMenu(false));
            contextMenu.add(ContextMenuItem.SEPARATOR);
            GuiQuestTree.addObjectMenuItems(contextMenu, (IOpenableGui)this.getGui(), this.chapter);
            this.getGui().openContextMenu(contextMenu);
        }
    }

    public void addMouseOverText(List<String> list) {
        int p;
        String title = this.getTitle();
        if (this.treeGui.file.self != null && (p = this.chapter.getRelativeProgress(this.treeGui.file.self)) > 0 && p < 100) {
            title = title + " " + TextFormatting.DARK_GRAY + p + "%";
        }
        list.add(title);
        list.addAll(this.description);
        if (this.treeGui.file.self == null) {
            return;
        }
        int r = 0;
        for (Quest quest : this.chapter.quests) {
            if (!quest.isComplete(this.treeGui.file.self)) continue;
            for (QuestReward reward : quest.rewards) {
                if (this.treeGui.file.isRewardClaimed(reward)) continue;
                ++r;
            }
        }
        if (r > 0) {
            list.add("");
            list.add(I18n.func_135052_a((String)"ftbquests.gui.unclaimed_rewards", (Object[])new Object[0]) + ": " + TextFormatting.GOLD + r);
        }
    }

    @Override
    public void draw(Theme theme, int x, int y, int w, int h) {
        if (this.treeGui.selectedChapter != this.chapter) {
            this.treeGui.borderColor.draw(x, y + h - 1, w + 1, 1);
            this.treeGui.backgroundColor.draw(x, y + 1, w, h - 2);
        } else {
            this.treeGui.borderColor.draw(x + w, y + h - 1, 1, 1);
        }
        this.treeGui.borderColor.draw(x + w, y + 1, 1, h - 2);
        int is = this.width < 18 ? 8 : 16;
        this.icon.draw(x + (w - is) / 2, y + (h - is) / 2, is, is);
        if (this.isMouseOver()) {
            this.treeGui.backgroundColor.draw(x, y + 1, w, h - (this.treeGui.selectedChapter == this.chapter ? 1 : 2));
        }
        if (this.chapter.quests.isEmpty()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
            GuiIcons.CLOSE.draw(x + w - 10, y + 2, 8, 8);
            GlStateManager.func_179121_F();
            return;
        }
        if (this.treeGui.file.self == null) {
            return;
        }
        boolean hasRewards = false;
        for (Quest quest : this.chapter.quests) {
            if (!quest.isComplete(this.treeGui.file.self)) continue;
            for (QuestReward reward : quest.rewards) {
                if (this.treeGui.file.isRewardClaimed(reward)) continue;
                hasRewards = true;
                break;
            }
            if (!hasRewards) continue;
            break;
        }
        if (hasRewards) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
            FTBQuestsTheme.ALERT.draw(x + w - 7, y + 2, 6, 6);
            GlStateManager.func_179121_F();
        } else if (this.chapter.isComplete(this.treeGui.file.self)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
            FTBQuestsTheme.COMPLETED.draw(x + w - 8, y + 1, 8, 8);
            GlStateManager.func_179121_F();
        }
    }
}

