/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.editor;

import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconWrapper;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.editor.ChaptersTab;
import com.feed_the_beast.ftbquests.gui.editor.LootCrateTab;
import com.feed_the_beast.ftbquests.gui.editor.RewardTableTab;
import com.feed_the_beast.ftbquests.gui.editor.SettingsTab;
import com.feed_the_beast.ftbquests.gui.editor.Tab;
import com.feed_the_beast.ftbquests.gui.editor.VariableTab;
import com.feed_the_beast.ftbquests.item.FTBQuestsItems;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObjectDirect;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public final class EditorFrame
extends JFrame {
    private static EditorFrame editor = null;
    public final ClientQuestFile file;

    public static void open(boolean reload) {
        IconWrapper.clearCache();
        if (editor == null || reload) {
            new Thread(() -> {
                if (editor != null) {
                    editor.dispose();
                }
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    editor = new EditorFrame(ClientQuestFile.INSTANCE);
                    editor.setLocationRelativeTo(null);
                    editor.setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, "FTB Quests Editor").start();
            return;
        }
        editor.setVisible(true);
    }

    public static String toString(ITextComponent component) {
        return StringUtils.unformatted((String)component.func_150254_d());
    }

    public static String toString(ItemStack stack) {
        return StringUtils.unformatted((String)stack.func_82833_r());
    }

    private EditorFrame(ClientQuestFile f) {
        super("FTB Quests Editor [Warning: Nearly nothing works properly yet!]");
        this.file = f;
        this.setDefaultCloseOperation(1);
        this.setMinimumSize(new Dimension(500, 300));
        this.setResizable(true);
        this.setIconImage(Icon.getIcon((String)"ftbquests:textures/logotransparent.png").getWrappedIcon().getImage());
        JMenuBar menuBar = new JMenuBar();
        JMenu menuSettings = new JMenu(I18n.func_135052_a((String)"ftbquests.file", (Object[])new Object[0]));
        menuSettings.add(this.menuItem(I18n.func_135052_a((String)"ftbquests.gui.reset_progress", (Object[])new Object[0]), GuiIcons.REFRESH.getWrappedIcon(), () -> System.out.println("Hi")));
        menuSettings.add(this.menuItem(I18n.func_135052_a((String)"ftbquests.gui.complete_instantly", (Object[])new Object[0]), GuiIcons.ACCEPT.getWrappedIcon(), () -> System.out.println("Hi")));
        menuSettings.add(this.menuItem(I18n.func_135052_a((String)"ftbquests.gui.save_as_file", (Object[])new Object[0]), GuiIcons.DOWN.getWrappedIcon(), () -> System.out.println("Hi")));
        menuBar.add(menuSettings);
        this.setJMenuBar(menuBar);
        JTabbedPane tabs = new JTabbedPane();
        this.addTab(tabs, I18n.func_135052_a((String)"ftbquests.gui.edit_file", (Object[])new Object[0]), GuiIcons.SETTINGS.getWrappedIcon(), new SettingsTab(this));
        this.addTab(tabs, I18n.func_135052_a((String)"ftbquests.chapters", (Object[])new Object[0]), GuiIcons.COLOR_RGB.getWrappedIcon(), new ChaptersTab(this));
        this.addTab(tabs, I18n.func_135052_a((String)"ftbquests.reward_tables", (Object[])new Object[0]), GuiIcons.MONEY_BAG.getWrappedIcon(), new RewardTableTab(this));
        this.addTab(tabs, I18n.func_135052_a((String)"jei.ftbquests.lootcrates", (Object[])new Object[0]), ItemIcon.getItemIcon((Item)FTBQuestsItems.LOOTCRATE).getWrappedIcon(), new LootCrateTab(this));
        this.addTab(tabs, I18n.func_135052_a((String)"ftbquests.variables", (Object[])new Object[0]), GuiIcons.CONTROLLER.getWrappedIcon(), new VariableTab(this));
        this.setContentPane(tabs);
        this.pack();
        this.setSize(new Dimension(1000, 600));
    }

    private void addTab(JTabbedPane tabs, String title, javax.swing.Icon icon, Tab tab) {
        tabs.addTab(title, icon, tab.scrollPage() ? new JScrollPane(tab) : tab);
    }

    private JMenuItem menuItem(String title, @Nullable javax.swing.Icon icon, Runnable action) {
        JMenuItem item = new JMenuItem(title);
        if (icon != null) {
            item.setIcon(icon);
        }
        item.addActionListener(e -> action.run());
        return item;
    }

    public static void addChangeListener(final JTextComponent text, final ChangeListener changeListener) {
        Objects.requireNonNull(text);
        Objects.requireNonNull(changeListener);
        DocumentListener dl = new DocumentListener(){
            private int lastChange = 0;
            private int lastNotifiedChange = 0;

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ++this.lastChange;
                SwingUtilities.invokeLater(() -> {
                    if (this.lastNotifiedChange != this.lastChange) {
                        this.lastNotifiedChange = this.lastChange;
                        changeListener.stateChanged(new ChangeEvent(text));
                    }
                });
            }
        };
        text.addPropertyChangeListener("document", e -> {
            Document d1 = (Document)e.getOldValue();
            Document d2 = (Document)e.getNewValue();
            if (d1 != null) {
                d1.removeDocumentListener(dl);
            }
            if (d2 != null) {
                d2.addDocumentListener(dl);
            }
            dl.changedUpdate(null);
        });
        Document d = text.getDocument();
        if (d != null) {
            d.addDocumentListener(dl);
        }
    }

    public static Component add(Panel panel, String key, Component component) {
        JLabel label = new JLabel(I18n.func_135052_a((String)key, (Object[])new Object[0]), 0);
        if (I18n.func_188566_a((String)(key + ".tooltip"))) {
            label.setToolTipText(I18n.func_135052_a((String)(key + ".tooltip"), (Object[])new Object[0]));
        }
        label.setLabelFor(component);
        panel.add(label);
        panel.add(component);
        return component;
    }

    public static void schedule(Runnable runnable) {
        Minecraft.func_71410_x().func_152344_a(runnable);
    }

    public static void scheduleObjectEdit(QuestObjectBase object) {
        EditorFrame.schedule(() -> new MessageEditObjectDirect(object).sendToServer());
    }
}

