/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests;

import com.feed_the_beast.ftblib.events.FTBLibPreInitRegistryEvent;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.block.BlockLootCrateOpener;
import com.feed_the_beast.ftbquests.block.BlockLootCrateStorage;
import com.feed_the_beast.ftbquests.block.BlockProgressDetector;
import com.feed_the_beast.ftbquests.block.BlockProgressScreen;
import com.feed_the_beast.ftbquests.block.BlockProgressScreenPart;
import com.feed_the_beast.ftbquests.block.BlockQuestChest;
import com.feed_the_beast.ftbquests.block.BlockTaskScreen;
import com.feed_the_beast.ftbquests.block.BlockTaskScreenPart;
import com.feed_the_beast.ftbquests.block.FTBQuestsBlocks;
import com.feed_the_beast.ftbquests.block.ItemBlockProgressScreen;
import com.feed_the_beast.ftbquests.block.ItemBlockScreen;
import com.feed_the_beast.ftbquests.item.ItemLootCrate;
import com.feed_the_beast.ftbquests.item.ItemQuestBook;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.reward.ChoiceReward;
import com.feed_the_beast.ftbquests.quest.reward.CommandReward;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.ItemReward;
import com.feed_the_beast.ftbquests.quest.reward.LootReward;
import com.feed_the_beast.ftbquests.quest.reward.QuestRewardType;
import com.feed_the_beast.ftbquests.quest.reward.RandomReward;
import com.feed_the_beast.ftbquests.quest.reward.XPLevelsReward;
import com.feed_the_beast.ftbquests.quest.reward.XPReward;
import com.feed_the_beast.ftbquests.quest.task.CheckmarkTask;
import com.feed_the_beast.ftbquests.quest.task.DimensionTask;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.FluidTask;
import com.feed_the_beast.ftbquests.quest.task.ForgeEnergyTask;
import com.feed_the_beast.ftbquests.quest.task.ItemTask;
import com.feed_the_beast.ftbquests.quest.task.KillTask;
import com.feed_the_beast.ftbquests.quest.task.LocationTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import com.feed_the_beast.ftbquests.quest.task.StatTask;
import com.feed_the_beast.ftbquests.quest.task.XPTask;
import com.feed_the_beast.ftbquests.tile.TileLootCrateOpener;
import com.feed_the_beast.ftbquests.tile.TileLootCrateStorage;
import com.feed_the_beast.ftbquests.tile.TileProgressDetector;
import com.feed_the_beast.ftbquests.tile.TileProgressScreenCore;
import com.feed_the_beast.ftbquests.tile.TileProgressScreenPart;
import com.feed_the_beast.ftbquests.tile.TileQuestChest;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenCore;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenPart;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import com.feed_the_beast.ftbquests.util.FTBQuestsInventoryListener;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="ftbquests")
public class FTBQuestsEventHandler {
    private static Block withName(Block block, String name) {
        block.func_149647_a(FTBQuests.TAB);
        block.setRegistryName(name);
        block.func_149663_c("ftbquests." + name);
        return block;
    }

    private static Item withName(Item item, String name) {
        item.func_77637_a(FTBQuests.TAB);
        item.setRegistryName(name);
        item.func_77655_b("ftbquests." + name);
        return item;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{FTBQuestsEventHandler.withName((Block)new BlockTaskScreen(), "screen"), FTBQuestsEventHandler.withName((Block)new BlockTaskScreenPart(), "screen_part"), FTBQuestsEventHandler.withName(new BlockProgressDetector(), "progress_detector"), FTBQuestsEventHandler.withName((Block)new BlockProgressScreen(), "progress_screen"), FTBQuestsEventHandler.withName((Block)new BlockProgressScreenPart(), "progress_screen_part"), FTBQuestsEventHandler.withName((Block)new BlockQuestChest(), "chest"), FTBQuestsEventHandler.withName((Block)new BlockLootCrateStorage(), "loot_crate_storage"), FTBQuestsEventHandler.withName((Block)new BlockLootCrateOpener(), "loot_crate_opener")});
        GameRegistry.registerTileEntity(TileTaskScreenCore.class, (ResourceLocation)new ResourceLocation("ftbquests", "screen_core"));
        GameRegistry.registerTileEntity(TileTaskScreenPart.class, (ResourceLocation)new ResourceLocation("ftbquests", "screen_part"));
        GameRegistry.registerTileEntity(TileProgressDetector.class, (ResourceLocation)new ResourceLocation("ftbquests", "progress_detector"));
        GameRegistry.registerTileEntity(TileProgressScreenCore.class, (ResourceLocation)new ResourceLocation("ftbquests", "progress_screen_core"));
        GameRegistry.registerTileEntity(TileProgressScreenPart.class, (ResourceLocation)new ResourceLocation("ftbquests", "progress_screen_part"));
        GameRegistry.registerTileEntity(TileQuestChest.class, (ResourceLocation)new ResourceLocation("ftbquests", "chest"));
        GameRegistry.registerTileEntity(TileLootCrateStorage.class, (ResourceLocation)new ResourceLocation("ftbquests", "loot_crate_storage"));
        GameRegistry.registerTileEntity(TileLootCrateOpener.class, (ResourceLocation)new ResourceLocation("ftbquests", "loot_crate_opener"));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ItemBlockScreen(FTBQuestsBlocks.SCREEN).setRegistryName("screen"), (Item)new ItemBlock(FTBQuestsBlocks.PROGRESS_DETECTOR).setRegistryName("progress_detector"), (Item)new ItemBlockProgressScreen(FTBQuestsBlocks.PROGRESS_SCREEN).setRegistryName("progress_screen"), (Item)new ItemBlock(FTBQuestsBlocks.CHEST).setRegistryName("chest"), (Item)new ItemBlock(FTBQuestsBlocks.LOOT_CRATE_STORAGE).setRegistryName("loot_crate_storage"), (Item)new ItemBlock(FTBQuestsBlocks.LOOT_CRATE_OPENER).setRegistryName("loot_crate_opener"), FTBQuestsEventHandler.withName(new ItemQuestBook(), "book"), FTBQuestsEventHandler.withName(new ItemLootCrate(), "lootcrate").func_77655_b("ftbquests.lootcrate")});
    }

    @SubscribeEvent
    public static void registerFTBLib(FTBLibPreInitRegistryEvent event) {
        event.getRegistry().registerConfigValueProvider("ftbquests_object", () -> new ConfigQuestObject(null, null, new QuestObjectType[0]));
    }

    @SubscribeEvent
    public static void registerTasks(RegistryEvent.Register<QuestTaskType> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new QuestTaskType[]{FTBQuestsTasks.ITEM = ((QuestTaskType)new QuestTaskType(ItemTask::new).setRegistryName("item")).setIcon(Icon.getIcon((String)"minecraft:items/diamond")), FTBQuestsTasks.FLUID = ((QuestTaskType)new QuestTaskType(FluidTask::new).setRegistryName("fluid")).setIcon(Icon.getIcon((String)FluidRegistry.WATER.getStill(new FluidStack(FluidRegistry.WATER, 1000)).toString()).combineWith(Icon.getIcon((String)FluidTask.TANK_TEXTURE.toString()))), FTBQuestsTasks.FORGE_ENERGY = ((QuestTaskType)new QuestTaskType(ForgeEnergyTask::new).setRegistryName("forge_energy")).setIcon(Icon.getIcon((String)ForgeEnergyTask.EMPTY_TEXTURE.toString()).combineWith(Icon.getIcon((String)ForgeEnergyTask.FULL_TEXTURE.toString()))), FTBQuestsTasks.XP = ((QuestTaskType)new QuestTaskType(XPTask::new).setRegistryName("xp")).setIcon(Icon.getIcon((String)"minecraft:items/experience_bottle")), FTBQuestsTasks.DIMENSION = ((QuestTaskType)new QuestTaskType(DimensionTask::new).setRegistryName("dimension")).setIcon(Icon.getIcon((String)"minecraft:blocks/portal")), FTBQuestsTasks.STAT = ((QuestTaskType)new QuestTaskType(StatTask::new).setRegistryName("stat")).setIcon(Icon.getIcon((String)"minecraft:items/iron_sword")), FTBQuestsTasks.KILL = ((QuestTaskType)new QuestTaskType(KillTask::new).setRegistryName("kill")).setIcon(Icon.getIcon((String)"minecraft:items/diamond_sword")), FTBQuestsTasks.LOCATION = ((QuestTaskType)new QuestTaskType(LocationTask::new).setRegistryName("location")).setIcon(Icon.getIcon((String)"minecraft:items/compass_00")), FTBQuestsTasks.CHECKMARK = ((QuestTaskType)new QuestTaskType(CheckmarkTask::new).setRegistryName("checkmark")).setIcon(GuiIcons.ACCEPT_GRAY)});
        FTBQuests.PROXY.setTaskGuiProviders();
    }

    @SubscribeEvent
    public static void registerRewards(RegistryEvent.Register<QuestRewardType> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new QuestRewardType[]{FTBQuestsRewards.ITEM = ((QuestRewardType)new QuestRewardType(ItemReward::new).setRegistryName("item")).setIcon(Icon.getIcon((String)"minecraft:items/diamond")), FTBQuestsRewards.CHOICE = ((QuestRewardType)new QuestRewardType(ChoiceReward::new).setRegistryName("choice")).setIcon(GuiIcons.COLOR_RGB).setExcludeFromListRewards(true), FTBQuestsRewards.RANDOM = ((QuestRewardType)new QuestRewardType(RandomReward::new).setRegistryName("random")).setIcon(GuiIcons.DICE).setExcludeFromListRewards(true), FTBQuestsRewards.LOOT = ((QuestRewardType)new QuestRewardType(LootReward::new).setRegistryName("loot")).setIcon(GuiIcons.MONEY_BAG).setExcludeFromListRewards(true), FTBQuestsRewards.XP = ((QuestRewardType)new QuestRewardType(XPReward::new).setRegistryName("xp")).setIcon(Icon.getIcon((String)"minecraft:items/experience_bottle")), FTBQuestsRewards.XP_LEVELS = ((QuestRewardType)new QuestRewardType(XPLevelsReward::new).setRegistryName("xp_levels")).setIcon(Icon.getIcon((String)"minecraft:items/experience_bottle")), FTBQuestsRewards.COMMAND = ((QuestRewardType)new QuestRewardType(CommandReward::new).setRegistryName("command")).setIcon(Icon.getIcon((String)"minecraft:blocks/command_block_back"))});
        FTBQuests.PROXY.setRewardGuiProviders();
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        if (e.field_70170_p.field_72995_K || e instanceof EntityPlayer) {
            return;
        }
        if (!ServerQuestFile.INSTANCE.dropLootCrates) {
            return;
        }
        LootCrate crate = ServerQuestFile.INSTANCE.getRandomLootCrate((Entity)e, e.field_70170_p.field_73012_v);
        if (crate != null) {
            EntityItem ei = new EntityItem(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, crate.createStack());
            ei.func_174867_a(10);
            event.getDrops().add(ei);
        }
    }

    @SubscribeEvent
    public static void onPlayerKillEvent(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayerMP) {
            List<KillTask> killTasks = ServerQuestFile.INSTANCE.getKillTasks();
            if (killTasks.isEmpty()) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)event.getSource().func_76346_g();
            ITeamData data = ServerQuestFile.INSTANCE.getData(FTBLibAPI.getTeamID((UUID)player.func_110124_au()));
            if (data == null) {
                return;
            }
            for (KillTask task : killTasks) {
                QuestTaskData taskData = data.getQuestTaskData(task);
                if (taskData.getProgress() >= task.getMaxProgress() || !task.quest.canStartTasks(data)) continue;
                ((KillTask.Data)taskData).kill(event.getEntityLiving());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.field_70170_p.field_72995_K) {
            List<LocationTask> locationTasks = ServerQuestFile.INSTANCE.getLocationTasks();
            if (locationTasks.isEmpty()) {
                return;
            }
            ITeamData data = ServerQuestFile.INSTANCE.getData(FTBLibAPI.getTeamID((UUID)event.player.func_110124_au()));
            if (data == null) {
                return;
            }
            for (LocationTask task : locationTasks) {
                QuestTaskData taskData = data.getQuestTaskData(task);
                if (taskData.getProgress() != 0L || !task.quest.canStartTasks(data)) continue;
                taskData.submitTask((EntityPlayerMP)event.player, Collections.emptyList(), false);
            }
        }
    }

    @SubscribeEvent
    public static void onItemCraftedEvent(PlayerEvent.ItemCraftedEvent event) {
        if (event.player instanceof EntityPlayerMP && !event.crafting.func_190926_b()) {
            FTBQuestsInventoryListener.detect((EntityPlayerMP)event.player, Collections.singleton(event.crafting));
        }
    }

    @SubscribeEvent
    public static void onItemSmeltEvent(PlayerEvent.ItemSmeltedEvent event) {
        if (event.player instanceof EntityPlayerMP && !event.smelting.func_190926_b()) {
            FTBQuestsInventoryListener.detect((EntityPlayerMP)event.player, Collections.singleton(event.smelting));
        }
    }
}

