/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.FluidMaterial;
import gregtech.api.unification.material.type.GemMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTUtility;
import net.minecraft.item.ItemStack;

public class OreRecipeHandler {
    public static void register() {
        OrePrefix.ore.addProcessingHandler(DustMaterial.class, OreRecipeHandler::processOre);
        OrePrefix.oreBasalt.addProcessingHandler(DustMaterial.class, OreRecipeHandler::processOre);
        OrePrefix.oreBlackgranite.addProcessingHandler(DustMaterial.class, OreRecipeHandler::processOre);
        OrePrefix.oreEndstone.addProcessingHandler(DustMaterial.class, OreRecipeHandler::processOre);
        OrePrefix.oreGravel.addProcessingHandler(DustMaterial.class, OreRecipeHandler::processOre);
        OrePrefix.oreNetherrack.addProcessingHandler(DustMaterial.class, OreRecipeHandler::processOre);
        OrePrefix.oreMarble.addProcessingHandler(DustMaterial.class, OreRecipeHandler::processOre);
        OrePrefix.oreRedgranite.addProcessingHandler(DustMaterial.class, OreRecipeHandler::processOre);
        OrePrefix.oreSand.addProcessingHandler(DustMaterial.class, OreRecipeHandler::processOre);
        OrePrefix.crushed.addProcessingHandler(DustMaterial.class, OreRecipeHandler::processCrushedOre);
        OrePrefix.crushedPurified.addProcessingHandler(DustMaterial.class, OreRecipeHandler::processCrushedPurified);
        OrePrefix.crushedCentrifuged.addProcessingHandler(DustMaterial.class, OreRecipeHandler::processCrushedCentrifuged);
        OrePrefix.crystalline.addProcessingHandler(SolidMaterial.class, OreRecipeHandler::processCrystallizedPurified);
        OrePrefix.dustImpure.addProcessingHandler(DustMaterial.class, OreRecipeHandler::processDirtyDust);
        OrePrefix.dustPure.addProcessingHandler(DustMaterial.class, OreRecipeHandler::processPureDust);
        OrePrefix.dust.addProcessingHandler(DustMaterial.class, OreRecipeHandler::processCleanDust);
    }

    private static void processMetalSmelting(OrePrefix crushedPrefix, DustMaterial material) {
        ItemStack ingotStack;
        DustMaterial smeltingMaterial = material.directSmelting == null ? material : material.directSmelting;
        int amountOfNuggets = (int)Math.floor(9.0 * OreRecipeHandler.getPercentOfComponentInMaterial(material, smeltingMaterial));
        if (smeltingMaterial instanceof IngotMaterial && !(ingotStack = amountOfNuggets == 9 ? OreDictUnifier.get(OrePrefix.ingot, smeltingMaterial) : OreDictUnifier.get(OrePrefix.nugget, smeltingMaterial, amountOfNuggets)).func_190926_b() && OreRecipeHandler.doesMaterialUseNormalFurnace(smeltingMaterial)) {
            ModHandler.addSmeltingRecipe(new UnificationEntry(crushedPrefix, material), ingotStack);
        }
    }

    private static double getPercentOfComponentInMaterial(Material material, Material materialToFind) {
        if (material == materialToFind) {
            return 1.0;
        }
        double amountOfComponents = material.materialComponents.stream().mapToLong(it -> it.amount).sum();
        return material.materialComponents.stream().mapToDouble(it -> OreRecipeHandler.getPercentOfComponentInMaterial(it.material, materialToFind) * ((double)it.amount / amountOfComponents)).sum();
    }

    public static void processOre(OrePrefix orePrefix, DustMaterial material) {
        DustMaterial byproductMaterial = GTUtility.selectItemInList(0, material, material.oreByProducts, DustMaterial.class);
        ItemStack byproductStack = OreDictUnifier.get(OrePrefix.dust, byproductMaterial);
        ItemStack crushedStack = OreDictUnifier.get(OrePrefix.crushed, material);
        DustMaterial smeltingMaterial = material.directSmelting == null ? material : material.directSmelting;
        double amountOfCrushedOre = (double)material.oreMultiplier / OreRecipeHandler.getPercentOfComponentInMaterial(material, smeltingMaterial);
        ItemStack ingotStack = smeltingMaterial instanceof IngotMaterial ? OreDictUnifier.get(OrePrefix.ingot, smeltingMaterial) : (smeltingMaterial instanceof GemMaterial ? OreDictUnifier.get(OrePrefix.gem, smeltingMaterial) : OreDictUnifier.get(OrePrefix.dust, smeltingMaterial));
        ingotStack.func_190920_e(ingotStack.func_190916_E() * material.smeltingMultiplier);
        crushedStack.func_190920_e(crushedStack.func_190916_E() * material.oreMultiplier);
        if (!crushedStack.func_190926_b()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().input(orePrefix, material)).outputs(GTUtility.copyAmount((int)Math.ceil(amountOfCrushedOre), crushedStack))).duration(40)).EUt(6)).buildAndRegister();
            Object builder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(orePrefix, material)).outputs(GTUtility.copyAmount((int)Math.round(amountOfCrushedOre * 2.0), crushedStack))).chancedOutput(byproductStack, 1400)).duration(200)).EUt(12);
            for (MaterialStack secondaryMaterial : orePrefix.secondaryMaterials) {
                if (!(secondaryMaterial.material instanceof DustMaterial)) continue;
                ItemStack dustStack = OreDictUnifier.getDust(secondaryMaterial);
                ((RecipeBuilder)builder).chancedOutput(dustStack, 6700);
            }
            ((RecipeBuilder)builder).buildAndRegister();
        }
        if (!ingotStack.func_190926_b() && OreRecipeHandler.doesMaterialUseNormalFurnace(smeltingMaterial)) {
            ModHandler.addSmeltingRecipe(new UnificationEntry(orePrefix, material), ingotStack);
        }
    }

    public static void processCrushedOre(OrePrefix crushedPrefix, DustMaterial material) {
        ItemStack impureDustStack = OreDictUnifier.get(OrePrefix.dustImpure, material);
        DustMaterial byproductMaterial = GTUtility.selectItemInList(0, material, material.oreByProducts, DustMaterial.class);
        if (impureDustStack.func_190926_b()) {
            impureDustStack = GTUtility.copy(OreDictUnifier.get(OrePrefix.dirtyGravel, material), OreDictUnifier.get(OrePrefix.shard, material), OreDictUnifier.get(OrePrefix.clump, material), OreDictUnifier.get(OrePrefix.dust, material));
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().input(crushedPrefix, material)).outputs(impureDustStack)).duration(20)).EUt(8)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(crushedPrefix, material)).outputs(impureDustStack)).duration(100)).EUt(12)).chancedOutput(OreDictUnifier.get(OrePrefix.dust, byproductMaterial, material.byProductMultiplier), 1400)).buildAndRegister();
        ItemStack crushedPurifiedOre = GTUtility.copy(OreDictUnifier.get(OrePrefix.crushedPurified, material), OreDictUnifier.get(OrePrefix.dust, material));
        ItemStack crushedCentrifugedOre = GTUtility.copy(OreDictUnifier.get(OrePrefix.crushedCentrifuged, material), OreDictUnifier.get(OrePrefix.dust, material));
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ORE_WASHER_RECIPES.recipeBuilder().input(crushedPrefix, material)).fluidInputs(ModHandler.getWater(1000))).outputs(crushedPurifiedOre, OreDictUnifier.get(OrePrefix.dustTiny, byproductMaterial, material.byProductMultiplier * 3), OreDictUnifier.get(OrePrefix.dust, Materials.Stone))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ORE_WASHER_RECIPES.recipeBuilder().input(crushedPrefix, material)).fluidInputs(ModHandler.getDistilledWater(1000))).outputs(crushedPurifiedOre, OreDictUnifier.get(OrePrefix.dustTiny, byproductMaterial, material.byProductMultiplier * 3), OreDictUnifier.get(OrePrefix.dust, Materials.Stone))).duration(300)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.THERMAL_CENTRIFUGE_RECIPES.recipeBuilder().input(crushedPrefix, material)).duration((int)material.getAverageMass() * 20)).outputs(crushedCentrifugedOre, OreDictUnifier.get(OrePrefix.dustTiny, byproductMaterial, material.byProductMultiplier * 3), OreDictUnifier.get(OrePrefix.dust, Materials.Stone))).buildAndRegister();
        if (material.washedIn != null) {
            DustMaterial washingByproduct = GTUtility.selectItemInList(3, material, material.oreByProducts, DustMaterial.class);
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_BATH_RECIPES.recipeBuilder().input(crushedPrefix, material)).fluidInputs(material.washedIn.getFluid(1000))).outputs(crushedPurifiedOre)).chancedOutput(OreDictUnifier.get(OrePrefix.dust, washingByproduct, material.byProductMultiplier), 7000)).chancedOutput(OreDictUnifier.get(OrePrefix.dust, Materials.Stone), 4000)).duration(800)).EUt(8)).buildAndRegister();
        }
        ModHandler.addShapelessRecipe(String.format("crushed_ore_to_dust_%s", material), impureDustStack, Character.valueOf('h'), new UnificationEntry(crushedPrefix, material));
    }

    public static void processCrushedCentrifuged(OrePrefix centrifugedPrefix, DustMaterial material) {
        ItemStack dustStack = OreDictUnifier.get(OrePrefix.dust, material);
        ItemStack byproductStack = OreDictUnifier.get(OrePrefix.dust, GTUtility.selectItemInList(2, material, material.oreByProducts, DustMaterial.class), 1);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().input(centrifugedPrefix, material)).outputs(dustStack)).duration(20)).EUt(8)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(centrifugedPrefix, material)).outputs(dustStack)).chancedOutput(byproductStack, 1400)).duration(40)).EUt(12)).buildAndRegister();
        ModHandler.addShapelessRecipe(String.format("centrifuged_ore_to_dust_%s", material), dustStack, Character.valueOf('h'), new UnificationEntry(centrifugedPrefix, material));
    }

    public static void processCrushedPurified(OrePrefix purifiedPrefix, DustMaterial material) {
        ItemStack crushedCentrifugedStack = OreDictUnifier.get(OrePrefix.crushedCentrifuged, material);
        ItemStack dustStack = OreDictUnifier.get(OrePrefix.dustPure, material);
        Material byproductMaterial = GTUtility.selectItemInList(1, material, material.oreByProducts, DustMaterial.class);
        ItemStack byproductStack = OreDictUnifier.get(OrePrefix.dust, byproductMaterial);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().input(purifiedPrefix, material)).outputs(dustStack)).duration(20)).EUt(8)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(purifiedPrefix, material)).outputs(dustStack)).chancedOutput(byproductStack, 1400)).duration(40)).EUt(12)).buildAndRegister();
        ModHandler.addShapelessRecipe(String.format("purified_ore_to_dust_%s", material), dustStack, Character.valueOf('h'), new UnificationEntry(purifiedPrefix, material));
        if (!crushedCentrifugedStack.func_190926_b()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.THERMAL_CENTRIFUGE_RECIPES.recipeBuilder().input(purifiedPrefix, material)).outputs(crushedCentrifugedStack, OreDictUnifier.get(OrePrefix.dustTiny, byproductMaterial, 3))).duration((int)(material.getAverageMass() * 20L))).EUt(60)).buildAndRegister();
        }
        if (material instanceof GemMaterial) {
            ItemStack exquisiteStack = OreDictUnifier.get(OrePrefix.gemExquisite, material);
            ItemStack flawlessStack = OreDictUnifier.get(OrePrefix.gemFlawless, material);
            ItemStack gemStack = OreDictUnifier.get(OrePrefix.gem, material);
            ItemStack flawedStack = OreDictUnifier.get(OrePrefix.gemFlawed, material);
            ItemStack chippedStack = OreDictUnifier.get(OrePrefix.gemChipped, material);
            if (material.hasFlag(GemMaterial.MatFlags.HIGH_SIFTER_OUTPUT)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SIFTER_RECIPES.recipeBuilder().input(purifiedPrefix, material)).chancedOutput(exquisiteStack, 300)).chancedOutput(flawlessStack, 1200)).chancedOutput(gemStack, 4500)).chancedOutput(flawedStack, 1400)).chancedOutput(chippedStack, 2800)).chancedOutput(dustStack, 3500)).duration(800)).EUt(16)).buildAndRegister();
            } else {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SIFTER_RECIPES.recipeBuilder().input(purifiedPrefix, material)).chancedOutput(exquisiteStack, 100)).chancedOutput(flawlessStack, 400)).chancedOutput(gemStack, 1500)).chancedOutput(flawedStack, 2000)).chancedOutput(chippedStack, 4000)).chancedOutput(dustStack, 5000)).duration(800)).EUt(16)).buildAndRegister();
            }
        }
    }

    public static void processDirtyDust(OrePrefix dustPrefix, DustMaterial material) {
        ItemStack dustStack = OreDictUnifier.get(OrePrefix.dust, material);
        if (dustPrefix == OrePrefix.dustPure && material.separatedOnto != null) {
            ItemStack separatedStack = OreDictUnifier.get(OrePrefix.dustSmall, material.separatedOnto);
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder().input(dustPrefix, material)).outputs(dustStack)).chancedOutput(separatedStack, 4000)).duration((int)material.separatedOnto.getAverageMass())).EUt(24)).buildAndRegister();
        }
        FluidMaterial byproduct = GTUtility.selectItemInList(2, material, material.oreByProducts, FluidMaterial.class);
        Object builder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().input(dustPrefix, material)).outputs(dustStack)).duration((int)(material.getAverageMass() * 4L))).EUt(24);
        if (byproduct instanceof DustMaterial) {
            ((RecipeBuilder)builder).outputs(OreDictUnifier.get(OrePrefix.dustTiny, byproduct, 3));
        } else {
            ((RecipeBuilder)builder).fluidOutputs(byproduct.getFluid(16));
        }
        ((RecipeBuilder)builder).buildAndRegister();
        OreRecipeHandler.processMetalSmelting(dustPrefix, material);
    }

    public static void processPureDust(OrePrefix purePrefix, DustMaterial material) {
        DustMaterial byproductMaterial = GTUtility.selectItemInList(1, material, material.oreByProducts, DustMaterial.class);
        ItemStack dustStack = OreDictUnifier.get(OrePrefix.dust, material);
        if (dustStack.func_190926_b()) {
            dustStack = GTUtility.copy(OreDictUnifier.get(OrePrefix.reduced, material), OreDictUnifier.get(OrePrefix.cleanGravel, material));
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder().input(purePrefix, material)).outputs(dustStack, OreDictUnifier.get(OrePrefix.dustTiny, byproductMaterial, 3))).duration((int)(material.getAverageMass() * 4L))).EUt(5)).buildAndRegister();
        OreRecipeHandler.processMetalSmelting(purePrefix, material);
    }

    public static void processCrystallizedPurified(OrePrefix crystallizedPrefix, SolidMaterial material) {
        DustMaterial resultMaterial = material.macerateInto == null ? material : material.macerateInto;
        ItemStack dustStack = OreDictUnifier.get(OrePrefix.dust, resultMaterial);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().input(crystallizedPrefix, material)).outputs(dustStack)).duration(10)).EUt(10)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().input(crystallizedPrefix, material)).outputs(dustStack)).duration(20)).EUt(16)).buildAndRegister();
        OreRecipeHandler.processMetalSmelting(crystallizedPrefix, material);
    }

    public static void processCleanDust(OrePrefix dustPrefix, DustMaterial material) {
        OreRecipeHandler.processMetalSmelting(dustPrefix, material);
    }

    private static boolean doesMaterialUseNormalFurnace(Material material) {
        return !(material instanceof IngotMaterial) || ((IngotMaterial)material).blastFurnaceTemperature <= 0;
    }
}

