/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.recipe;

import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.BlankUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.recipes.RecipeMap;
import gregtech.integration.jei.recipe.GTRecipeWrapper;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class RecipeMapCategory
implements IRecipeCategory<GTRecipeWrapper> {
    private final RecipeMap<?> recipeMap;
    private final ModularUI modularUI;
    private ItemStackHandler importItems;
    private ItemStackHandler exportItems;
    private FluidTankList importFluids;
    private FluidTankList exportFluids;
    private final IDrawable backgroundDrawable;

    public RecipeMapCategory(RecipeMap<?> recipeMap, IGuiHelper guiHelper) {
        this.recipeMap = recipeMap;
        FluidTank[] importFluidTanks = new FluidTank[recipeMap.getMaxFluidInputs()];
        for (int i = 0; i < importFluidTanks.length; ++i) {
            importFluidTanks[i] = new FluidTank(16000);
        }
        FluidTank[] exportFluidTanks = new FluidTank[recipeMap.getMaxFluidOutputs()];
        for (int i = 0; i < exportFluidTanks.length; ++i) {
            exportFluidTanks[i] = new FluidTank(16000);
        }
        this.importItems = new ItemStackHandler(recipeMap.getMaxInputs());
        this.exportItems = new ItemStackHandler(recipeMap.getMaxOutputs());
        this.importFluids = new FluidTankList(false, (IFluidTank[])importFluidTanks);
        this.exportFluids = new FluidTankList(false, (IFluidTank[])exportFluidTanks);
        this.modularUI = recipeMap.createJeiUITemplate((IItemHandlerModifiable)this.importItems, (IItemHandlerModifiable)this.exportItems, this.importFluids, this.exportFluids).build(new BlankUIHolder(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        this.modularUI.initWidgets();
        this.backgroundDrawable = guiHelper.createBlankDrawable(this.modularUI.getWidth(), this.modularUI.getHeight() * 2 / 3);
    }

    public String getUid() {
        return "gregtech:" + this.recipeMap.unlocalizedName;
    }

    public String getTitle() {
        return this.recipeMap.getLocalizedName();
    }

    public String getModName() {
        return "gregtech";
    }

    public IDrawable getBackground() {
        return this.backgroundDrawable;
    }

    public void setRecipe(IRecipeLayout recipeLayout, GTRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStackGroup = recipeLayout.getFluidStacks();
        for (Widget uiWidget : this.modularUI.guiWidgets.values()) {
            int fluidAmount;
            List inputsList;
            if (uiWidget instanceof SlotWidget) {
                SlotWidget slotWidget = (SlotWidget)uiWidget;
                if (slotWidget.itemHandler == this.importItems) {
                    itemStackGroup.init(slotWidget.slotIndex, true, slotWidget.xPosition - 1, slotWidget.yPosition - 1);
                    continue;
                }
                if (slotWidget.itemHandler != this.exportItems) continue;
                itemStackGroup.init(this.importItems.getSlots() + slotWidget.slotIndex, false, slotWidget.xPosition - 1, slotWidget.yPosition - 1);
                continue;
            }
            if (!(uiWidget instanceof TankWidget)) continue;
            TankWidget tankWidget = (TankWidget)uiWidget;
            if (this.importFluids.getFluidTanks().contains(tankWidget.fluidTank)) {
                int importIndex = this.importFluids.getFluidTanks().indexOf(tankWidget.fluidTank);
                inputsList = ingredients.getInputs(FluidStack.class);
                fluidAmount = 0;
                if (inputsList.size() > importIndex && !((List)inputsList.get(importIndex)).isEmpty()) {
                    fluidAmount = ((FluidStack)((List)inputsList.get((int)importIndex)).get((int)0)).amount;
                }
                fluidStackGroup.init(importIndex, true, tankWidget.x + tankWidget.fluidRenderOffset, tankWidget.y + tankWidget.fluidRenderOffset, tankWidget.width - tankWidget.fluidRenderOffset, tankWidget.height - tankWidget.fluidRenderOffset, fluidAmount, false, null);
                continue;
            }
            if (!this.exportFluids.getFluidTanks().contains(tankWidget.fluidTank)) continue;
            int exportIndex = this.exportFluids.getFluidTanks().indexOf(tankWidget.fluidTank);
            inputsList = ingredients.getOutputs(FluidStack.class);
            fluidAmount = 0;
            if (inputsList.size() > exportIndex && !((List)inputsList.get(exportIndex)).isEmpty()) {
                fluidAmount = ((FluidStack)((List)inputsList.get((int)exportIndex)).get((int)0)).amount;
            }
            fluidStackGroup.init(this.importFluids.getFluidTanks().size() + exportIndex, false, tankWidget.x + tankWidget.fluidRenderOffset, tankWidget.y + tankWidget.fluidRenderOffset, tankWidget.width - tankWidget.fluidRenderOffset, tankWidget.height - tankWidget.fluidRenderOffset, fluidAmount, false, null);
        }
        itemStackGroup.addTooltipCallback(recipeWrapper::addTooltip);
        fluidStackGroup.addTooltipCallback(recipeWrapper::addTooltip);
        itemStackGroup.set(ingredients);
        fluidStackGroup.set(ingredients);
    }

    public void drawExtras(Minecraft minecraft) {
        for (Widget widget : this.modularUI.guiWidgets.values()) {
            widget.drawInBackground(0, 0);
            widget.drawInForeground(0, 0);
        }
    }
}

