/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import gregtech.common.tools.ToolDrillLV;
import gregtech.common.tools.ToolUtility;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ToolJackHammer
extends ToolDrillLV {
    @Override
    public boolean canApplyEnchantment(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y.func_77557_a(Items.field_151035_b);
    }

    @Override
    public int getToolDamagePerBlockBreak(ItemStack stack) {
        return 4;
    }

    @Override
    public int getToolDamagePerDropConversion(ItemStack stack) {
        return 4;
    }

    @Override
    public int getToolDamagePerContainerCraft(ItemStack stack) {
        return 32;
    }

    @Override
    public int getToolDamagePerEntityAttack(ItemStack stack) {
        return 8;
    }

    @Override
    public int getBaseQuality(ItemStack stack) {
        return 1;
    }

    @Override
    public float getBaseDamage(ItemStack stack) {
        return 3.0f;
    }

    @Override
    public float getDigSpeedMultiplier(ItemStack stack) {
        return 1.0f;
    }

    @Override
    public float getMaxDurabilityMultiplier(ItemStack stack) {
        return 2.0f;
    }

    @Override
    public boolean isMinableBlock(IBlockState block, ItemStack stack) {
        String tool = block.func_177230_c().getHarvestTool(block);
        return tool != null && (tool.equals("hammer") || tool.equals("pickaxe")) || block.func_185904_a() == Material.field_151576_e || block.func_185904_a() == Material.field_151592_s || block.func_185904_a() == Material.field_151588_w || block.func_185904_a() == Material.field_151598_x;
    }

    @Override
    public int convertBlockDrops(World world, BlockPos centerPos, IBlockState blockState, EntityPlayer harvester, List<ItemStack> drops, boolean recursive, ItemStack toolStack) {
        int conversionsApplied = 0;
        EnumFacing sideHit = ToolUtility.getSideHit(world, centerPos, harvester);
        ItemStack selfStack = harvester.func_184586_b(EnumHand.MAIN_HAND);
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                BlockPos block;
                if (x == 0 && y == 0 || !this.isMinableBlock(world.func_180495_p(block = ToolJackHammer.rotate(centerPos, x, y, sideHit)), selfStack) || !world.canMineBlockBody(harvester, block) || !((EntityPlayerMP)harvester).field_71134_c.func_180237_b(block)) continue;
                ++conversionsApplied;
            }
        }
        return conversionsApplied;
    }

    private static BlockPos rotate(BlockPos origin, int x, int y, EnumFacing sideHit) {
        switch (sideHit.func_176740_k()) {
            case X: {
                return origin.func_177982_a(0, y, x);
            }
            case Z: {
                return origin.func_177982_a(x, y, 0);
            }
            case Y: {
                return origin.func_177982_a(x, 0, y);
            }
        }
        throw new IllegalArgumentException("Unknown axis");
    }
}

