/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.pipeline.IVertexSource;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.render.MetaTileEntityRenderer;
import gregtech.api.unification.material.MaterialIconSet;
import gregtech.api.unification.material.MaterialIconType;
import gregtech.api.unification.material.type.Material;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import gregtech.common.pipelike.fluidpipe.FluidPipeProperties;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import gregtech.common.pipelike.fluidpipe.ItemBlockFluidPipe;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FluidPipeRenderer
implements ICCBlockRenderer,
IItemRenderer {
    public static ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation(new ResourceLocation("gregtech", "fluid_pipe"), "normal");
    public static FluidPipeRenderer INSTANCE = new FluidPipeRenderer();
    public static EnumBlockRenderType BLOCK_RENDER_TYPE;
    private static ThreadLocal<BlockRenderer.BlockFace> blockFaces;
    private Set<MaterialIconSet> generatedSets = new HashSet<MaterialIconSet>();
    private Map<MaterialIconSet, TextureAtlasSprite> pipeSideTextures = new HashMap<MaterialIconSet, TextureAtlasSprite>();
    private Map<MaterialIconSet, TextureAtlasSprite> pipeEndTextures = new HashMap<MaterialIconSet, TextureAtlasSprite>();

    public static void preInit() {
        BLOCK_RENDER_TYPE = BlockRenderingRegistry.createRenderType((String)"gt_fluid_pipe");
        BlockRenderingRegistry.registerRenderer((EnumBlockRenderType)BLOCK_RENDER_TYPE, (ICCBlockRenderer)INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        TextureUtils.addIconRegister(INSTANCE::registerIcons);
        for (Material material : MetaBlocks.FLUID_PIPE.getEnabledMaterials()) {
            MaterialIconSet iconSet = material.materialIconSet;
            FluidPipeRenderer.INSTANCE.generatedSets.add(iconSet);
        }
    }

    public void registerIcons(TextureMap map) {
        GTLog.logger.info("Registering fluid pipe textures.");
        for (MaterialIconSet iconSet : this.generatedSets) {
            ResourceLocation location = MaterialIconType.pipeSide.getBlockPath(iconSet);
            ResourceLocation endLocation = MaterialIconType.pipeHuge.getBlockPath(iconSet);
            this.pipeSideTextures.put(iconSet, map.func_174942_a(location));
            this.pipeEndTextures.put(iconSet, map.func_174942_a(endLocation));
        }
    }

    @SubscribeEvent
    public void onModelsBake(ModelBakeEvent event) {
        GTLog.logger.info("Injected fluid pipe render model");
        event.getModelRegistry().func_82595_a((Object)MODEL_LOCATION, (Object)this);
    }

    public void renderItem(ItemStack stack, ItemCameraTransforms.TransformType transformType) {
        GlStateManager.func_179147_l();
        CCRenderState renderState = CCRenderState.instance();
        GlStateManager.func_179147_l();
        renderState.reset();
        renderState.startDrawing(7, DefaultVertexFormats.field_176599_b);
        BlockFluidPipe blockFluidPipe = (BlockFluidPipe)((ItemBlockFluidPipe)stack.func_77973_b()).func_179223_d();
        FluidPipeType pipeType = (FluidPipeType)blockFluidPipe.getItemPipeType(stack);
        Material material = blockFluidPipe.getItemMaterial(stack);
        if (pipeType != null && material != null) {
            this.renderPipeBlock(material, pipeType, 0x777777, renderState, new IVertexOperation[0], 1 << EnumFacing.SOUTH.func_176745_a() | 1 << EnumFacing.NORTH.func_176745_a() | 1 << 6 + EnumFacing.SOUTH.func_176745_a() | 1 << 6 + EnumFacing.NORTH.func_176745_a());
        }
        renderState.draw();
        GlStateManager.func_179084_k();
    }

    public boolean renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, BufferBuilder buffer) {
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        IVertexOperation[] pipeline = new IVertexOperation[]{new Translation((Vec3i)pos)};
        renderState.setBrightness(world, pos);
        BlockFluidPipe blockFluidPipe = (BlockFluidPipe)state.func_177230_c();
        IPipeTile tileEntityCable = blockFluidPipe.getPipeTileEntity(world, pos);
        if (tileEntityCable == null) {
            return false;
        }
        int paintingColor = tileEntityCable.getInsulationColor();
        int connectedSidesMask = blockFluidPipe.getActualConnections(tileEntityCable, world);
        FluidPipeType fluidPipeType = (FluidPipeType)tileEntityCable.getPipeType();
        Material material = tileEntityCable.getPipeMaterial();
        if (fluidPipeType != null && material != null) {
            this.renderPipeBlock(material, fluidPipeType, paintingColor, renderState, pipeline, connectedSidesMask);
            tileEntityCable.getCoverableImplementation().renderCovers(renderState, new Matrix4().translate((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), new IVertexOperation[0]);
        }
        return true;
    }

    public void renderPipeBlock(Material material, FluidPipeType pipeType, int insulationColor, CCRenderState state, IVertexOperation[] pipeline, int connectMask) {
        MaterialIconSet iconSet = material.materialIconSet;
        int pipeColor = insulationColor == 0x777777 ? ColourRGBA.multiply((int)GTUtility.convertRGBtoOpaqueRGBA_CL(material.materialRGB), (int)GTUtility.convertRGBtoOpaqueRGBA_CL(insulationColor)) : GTUtility.convertRGBtoOpaqueRGBA_CL(material.materialRGB);
        float thickness = pipeType.getThickness();
        ColourMultiplier multiplier = new ColourMultiplier(pipeColor);
        IVertexOperation[] pipeConnectSide = (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{new IconTransformation(this.pipeEndTextures.get((Object)iconSet)), multiplier});
        IVertexOperation[] pipeSide = (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{new IconTransformation(this.pipeSideTextures.get((Object)iconSet)), multiplier});
        Cuboid6 cuboid6 = BlockFluidPipe.getSideBox(null, thickness);
        for (EnumFacing renderedSide : EnumFacing.field_82609_l) {
            if ((connectMask & 1 << renderedSide.func_176745_a()) != 0) continue;
            int oppositeIndex = renderedSide.func_176734_d().func_176745_a();
            if ((connectMask & 1 << oppositeIndex) > 0 && (connectMask & ~(1 << oppositeIndex)) == 0) {
                FluidPipeRenderer.renderPipeSide(state, pipeConnectSide, renderedSide, cuboid6);
                continue;
            }
            FluidPipeRenderer.renderPipeSide(state, pipeSide, renderedSide, cuboid6);
        }
        FluidPipeRenderer.renderPipeCube(connectMask, state, pipeSide, pipeConnectSide, EnumFacing.DOWN, thickness);
        FluidPipeRenderer.renderPipeCube(connectMask, state, pipeSide, pipeConnectSide, EnumFacing.UP, thickness);
        FluidPipeRenderer.renderPipeCube(connectMask, state, pipeSide, pipeConnectSide, EnumFacing.WEST, thickness);
        FluidPipeRenderer.renderPipeCube(connectMask, state, pipeSide, pipeConnectSide, EnumFacing.EAST, thickness);
        FluidPipeRenderer.renderPipeCube(connectMask, state, pipeSide, pipeConnectSide, EnumFacing.NORTH, thickness);
        FluidPipeRenderer.renderPipeCube(connectMask, state, pipeSide, pipeConnectSide, EnumFacing.SOUTH, thickness);
    }

    private static void renderPipeCube(int connections, CCRenderState renderState, IVertexOperation[] pipeline, IVertexOperation[] pipeConnectSide, EnumFacing side, float thickness) {
        if ((connections & 1 << side.func_176745_a()) > 0) {
            boolean renderFrontSide = (connections & 1 << 6 + side.func_176745_a()) > 0;
            Cuboid6 cuboid6 = BlockFluidPipe.getSideBox(side, thickness);
            for (EnumFacing renderedSide : EnumFacing.field_82609_l) {
                if (renderedSide == side) {
                    if (!renderFrontSide) continue;
                    FluidPipeRenderer.renderPipeSide(renderState, pipeConnectSide, renderedSide, cuboid6);
                    continue;
                }
                if (renderedSide == side.func_176734_d()) continue;
                FluidPipeRenderer.renderPipeSide(renderState, pipeline, renderedSide, cuboid6);
            }
        }
    }

    private static void renderPipeSide(CCRenderState renderState, IVertexOperation[] pipeline, EnumFacing side, Cuboid6 cuboid6) {
        BlockRenderer.BlockFace blockFace = blockFaces.get();
        blockFace.loadCuboidFace(cuboid6, side.func_176745_a());
        renderState.setPipeline((IVertexSource)blockFace, 0, blockFace.verts.length, pipeline);
        renderState.render();
    }

    public void renderBrightness(IBlockState state, float brightness) {
    }

    public void handleRenderBlockDamage(IBlockAccess world, BlockPos pos, IBlockState state, TextureAtlasSprite sprite, BufferBuilder buffer) {
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        renderState.setPipeline(new IVertexOperation[]{new Vector3(new Vec3d((Vec3i)pos)).translation(), new IconTransformation(sprite)});
        BlockFluidPipe blockFluidPipe = (BlockFluidPipe)state.func_177230_c();
        IPipeTile tileEntityPipe = blockFluidPipe.getPipeTileEntity(world, pos);
        if (tileEntityPipe == null) {
            return;
        }
        FluidPipeType fluidPipeType = (FluidPipeType)tileEntityPipe.getPipeType();
        if (fluidPipeType == null) {
            return;
        }
        float thickness = fluidPipeType.getThickness();
        int connectedSidesMask = blockFluidPipe.getActualConnections(tileEntityPipe, world);
        Cuboid6 baseBox = BlockFluidPipe.getSideBox(null, thickness);
        BlockRenderer.renderCuboid((CCRenderState)renderState, (Cuboid6)baseBox, (int)0);
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            if ((connectedSidesMask & 1 << renderSide.func_176745_a()) <= 0) continue;
            Cuboid6 sideBox = BlockFluidPipe.getSideBox(renderSide, thickness);
            BlockRenderer.renderCuboid((CCRenderState)renderState, (Cuboid6)sideBox, (int)0);
        }
    }

    public void registerTextures(TextureMap map) {
    }

    public IModelState getTransforms() {
        return TRSRTransformation.identity();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        if (MetaTileEntityRenderer.BLOCK_TRANSFORMS.containsKey(cameraTransformType)) {
            return Pair.of((Object)this, (Object)MetaTileEntityRenderer.BLOCK_TRANSFORMS.get(cameraTransformType).getMatrix());
        }
        return Pair.of((Object)this, null);
    }

    public TextureAtlasSprite func_177554_e() {
        return TextureUtils.getMissingSprite();
    }

    public boolean func_188618_c() {
        return true;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public TextureAtlasSprite getParticleTexture(IPipeTile<FluidPipeType, FluidPipeProperties> tileEntity) {
        if (tileEntity == null) {
            return TextureUtils.getMissingSprite();
        }
        Material material = tileEntity.getPipeMaterial();
        if (material == null) {
            return TextureUtils.getMissingSprite();
        }
        return this.pipeSideTextures.get((Object)material.materialIconSet);
    }

    static {
        blockFaces = ThreadLocal.withInitial(BlockRenderer.BlockFace::new);
    }
}

