/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.fluidpipe.tile;

import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.common.pipelike.fluidpipe.FluidPipeProperties;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import gregtech.common.pipelike.fluidpipe.net.FluidPipeNet;
import gregtech.common.pipelike.fluidpipe.net.WorldFluidPipeNet;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidPipeFluidHandler
implements IFluidHandler {
    private final IPipeTile<FluidPipeType, FluidPipeProperties> pipeTile;
    private WeakReference<FluidPipeNet> currentPipeNet = new WeakReference<Object>(null);

    public FluidPipeFluidHandler(IPipeTile<FluidPipeType, FluidPipeProperties> pipeTile) {
        this.pipeTile = pipeTile;
    }

    public IFluidTankProperties[] getTankProperties() {
        FluidTank fluidTank = this.getNetFluidTank();
        return fluidTank == null ? new IFluidTankProperties[]{} : fluidTank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        FluidTank fluidTank = this.getNetFluidTank();
        return fluidTank == null ? 0 : fluidTank.fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidTank fluidTank = this.getNetFluidTank();
        return fluidTank == null ? null : fluidTank.drain(resource, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidTank fluidTank = this.getNetFluidTank();
        return fluidTank == null ? null : fluidTank.drain(maxDrain, doDrain);
    }

    protected FluidTank getNetFluidTank() {
        FluidPipeNet fluidPipeNet = this.getFluidPipeNet();
        return fluidPipeNet == null ? null : fluidPipeNet.getFluidNetTank();
    }

    protected FluidPipeNet getFluidPipeNet() {
        FluidPipeNet currentPipeNet = (FluidPipeNet)this.currentPipeNet.get();
        if (currentPipeNet != null && currentPipeNet.isValid() && currentPipeNet.containsNode(this.pipeTile.getPipePos())) {
            return currentPipeNet;
        }
        WorldFluidPipeNet worldFluidPipeNet = (WorldFluidPipeNet)((Object)this.pipeTile.getPipeBlock().getWorldPipeNet(this.pipeTile.getPipeWorld()));
        currentPipeNet = (FluidPipeNet)worldFluidPipeNet.getNetFromPos(this.pipeTile.getPipePos());
        if (currentPipeNet != null) {
            this.currentPipeNet = new WeakReference<FluidPipeNet>(currentPipeNet);
        }
        return currentPipeNet;
    }
}

