/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.fluidpipe;

import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.pipelike.fluidpipe.FluidPipeProperties;

public enum FluidPipeType implements IPipeType<FluidPipeProperties>
{
    TINY_OPAQUE("tiny", 0.2f, 1, OrePrefix.pipeTiny, true),
    SMALL_OPAQUE("small", 0.4f, 2, OrePrefix.pipeSmall, true),
    MEDIUM_OPAQUE("medium", 0.6f, 4, OrePrefix.pipeMedium, true),
    LARGE_OPAQUE("large", 0.8f, 8, OrePrefix.pipeLarge, true);

    public final String name;
    public final float thickness;
    public final int capacityMultiplier;
    public final OrePrefix orePrefix;
    public final boolean opaque;

    private FluidPipeType(String name, float thickness, int capacityMultiplier, OrePrefix orePrefix, boolean opaque) {
        this.name = name;
        this.thickness = thickness;
        this.capacityMultiplier = capacityMultiplier;
        this.orePrefix = orePrefix;
        this.opaque = opaque;
    }

    public String func_176610_l() {
        return this.name;
    }

    @Override
    public float getThickness() {
        return this.thickness;
    }

    @Override
    public OrePrefix getOrePrefix() {
        return this.orePrefix;
    }

    @Override
    public FluidPipeProperties modifyProperties(FluidPipeProperties baseProperties) {
        return new FluidPipeProperties(baseProperties.maxFluidTemperature, baseProperties.throughput * this.capacityMultiplier, baseProperties.gasProof);
    }

    @Override
    public boolean isPaintable() {
        return true;
    }
}

