/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public class MetaTileEntityQuantumChest
extends MetaTileEntity
implements ITieredMetaTileEntity {
    private static final double[] rotations = new double[]{180.0, 0.0, -90.0, 90.0};
    private final int tier;
    private final long maxStoredItems;
    private ItemStack itemStack = ItemStack.field_190927_a;
    private long itemsStoredInside = 0L;

    public MetaTileEntityQuantumChest(ResourceLocation metaTileEntityId, int tier, long maxStoredItems) {
        super(metaTileEntityId);
        this.tier = tier;
        this.maxStoredItems = maxStoredItems;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityQuantumChest(this.metaTileEntityId, this.tier, this.maxStoredItems);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        Textures.VOLTAGE_CASINGS[this.tier].render(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()))));
        translation.translate(0.5, 0.001, 0.5);
        translation.rotate(Math.toRadians(rotations[this.getFrontFacing().func_176745_a() - 2]), new Vector3(0.0, 1.0, 0.0));
        translation.translate(-0.5, 0.0, -0.5);
        Textures.SCREEN.renderSided(EnumFacing.UP, renderState, translation, pipeline);
    }

    @Override
    public TextureAtlasSprite getParticleTexture() {
        return Textures.VOLTAGE_CASINGS[this.tier].getParticleSprite();
    }

    @Override
    public int getComparatorValue() {
        float f = (float)this.itemsStoredInside / ((float)this.maxStoredItems * 1.0f);
        return MathHelper.func_76141_d((float)(f * 14.0f)) + (this.itemsStoredInside > 0L ? 1 : 0);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            ItemStack inputStack;
            if (this.itemsStoredInside < this.maxStoredItems && !(inputStack = this.importItems.getStackInSlot(0)).func_190926_b() && (this.itemStack.func_190926_b() || MetaTileEntityQuantumChest.areItemStackIdentical(this.itemStack, inputStack))) {
                int amountOfItemsToInsert = (int)Math.min((long)inputStack.func_190916_E(), this.maxStoredItems - this.itemsStoredInside);
                if (this.itemsStoredInside == 0L || this.itemStack.func_190926_b()) {
                    this.itemStack = GTUtility.copyAmount(1, inputStack);
                }
                inputStack.func_190918_g(amountOfItemsToInsert);
                this.importItems.setStackInSlot(0, inputStack);
                this.itemsStoredInside += (long)amountOfItemsToInsert;
                this.updateComparatorValue(true);
                this.markDirty();
            }
            if (this.itemsStoredInside > 0L && !this.itemStack.func_190926_b()) {
                ItemStack outputStack = this.exportItems.getStackInSlot(0);
                int maxStackSize = this.itemStack.func_77976_d();
                if (outputStack.func_190926_b() || MetaTileEntityQuantumChest.areItemStackIdentical(this.itemStack, outputStack) && outputStack.func_190916_E() < maxStackSize) {
                    int amountOfItemsToRemove = (int)Math.min((long)(maxStackSize - outputStack.func_190916_E()), this.itemsStoredInside);
                    if (outputStack.func_190926_b()) {
                        outputStack = GTUtility.copyAmount(amountOfItemsToRemove, this.itemStack);
                    } else {
                        outputStack.func_190917_f(amountOfItemsToRemove);
                    }
                    this.exportItems.setStackInSlot(0, outputStack);
                    this.itemsStoredInside -= (long)amountOfItemsToRemove;
                    if (this.itemsStoredInside == 0L) {
                        this.itemStack = ItemStack.field_190927_a;
                    }
                    this.updateComparatorValue(true);
                    this.markDirty();
                }
            }
        }
    }

    private static boolean areItemStackIdentical(ItemStack first, ItemStack second) {
        return ItemStack.func_179545_c((ItemStack)first, (ItemStack)second) && ItemStack.func_77970_a((ItemStack)first, (ItemStack)second);
    }

    protected void addDisplayInformation(List<ITextComponent> textList) {
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.quantum_chest.items_stored", new Object[0]));
        textList.add((ITextComponent)new TextComponentString(String.format("%,d", this.itemsStoredInside)));
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.quantum_chest.capacity", (Object[])new Object[]{this.maxStoredItems}));
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new ItemStackHandler(1);
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new ItemStackHandler(1);
    }

    @Override
    public boolean hasFrontFacing() {
        return false;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        NBTTagCompound tagCompound = super.writeToNBT(data);
        if (!this.itemStack.func_190926_b() && this.itemsStoredInside > 0L) {
            tagCompound.func_74782_a("ItemStack", (NBTBase)this.itemStack.func_77955_b(new NBTTagCompound()));
            tagCompound.func_74772_a("ItemAmount", this.itemsStoredInside);
        }
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_150297_b("ItemStack", 10)) {
            this.itemStack = new ItemStack(data.func_74775_l("ItemStack"));
            if (!this.itemStack.func_190926_b()) {
                this.itemsStoredInside = data.func_74763_f("ItemAmount");
            }
        }
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.defaultBuilder();
        builder.image(7, 16, 81, 55, GuiTextures.DISPLAY);
        builder.widget(new AdvancedTextWidget(11, 20, this::addDisplayInformation, 0xFFFFFF));
        return builder.label(6, 6, this.getMetaFullName()).widget(new SlotWidget(this.importItems, 0, 90, 17, true, true).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.IN_SLOT_OVERLAY)).widget(new SlotWidget(this.exportItems, 0, 90, 54, true, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.OUT_SLOT_OVERLAY)).bindPlayerInventory(entityPlayer.field_71071_by).build(this.getHolder(), entityPlayer);
    }
}

