/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric.generator;

import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.FuelRecipeMapWorkableHandler;
import gregtech.api.recipes.machines.FuelRecipeMap;
import gregtech.api.recipes.recipes.FuelRecipe;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.FluidMaterial;
import gregtech.common.MetaFluids;
import gregtech.common.metatileentities.electric.multiblockpart.MetaTileEntityRotorHolder;
import gregtech.common.metatileentities.multi.electric.generator.MetaTileEntityLargeTurbine;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;

public class LargeTurbineWorkableHandler
extends FuelRecipeMapWorkableHandler {
    private static final int CYCLE_LENGTH = 230;
    private static final int BASE_ROTOR_DAMAGE = 11;
    private static final int BASE_EU_OUTPUT = 8192;
    private static final int EU_OUTPUT_BONUS = 8192;
    private MetaTileEntityLargeTurbine largeTurbine;
    private int rotorCycleLength = 230;

    public LargeTurbineWorkableHandler(MetaTileEntityLargeTurbine metaTileEntity, FuelRecipeMap recipeMap, Supplier<IEnergyContainer> energyContainer, Supplier<IMultipleTankHandler> fluidTank, long maxVoltage) {
        super(metaTileEntity, recipeMap, energyContainer, fluidTank, maxVoltage);
        this.largeTurbine = metaTileEntity;
    }

    @Override
    public void update() {
        super.update();
        long totalEnergyOutput = this.getRecipeOutputVoltage();
        if (totalEnergyOutput > 0L) {
            ((IEnergyContainer)this.energyContainer.get()).addEnergy(totalEnergyOutput);
        }
    }

    public FluidStack getFuelStack() {
        if (this.previousRecipe == null) {
            return null;
        }
        FluidStack fuelStack = this.previousRecipe.getRecipeFluid();
        return ((IMultipleTankHandler)this.fluidTank.get()).drain(new FluidStack(fuelStack.getFluid(), Integer.MAX_VALUE), false);
    }

    @Override
    public boolean checkRecipe(FuelRecipe recipe) {
        MetaTileEntityRotorHolder rotorHolder = this.largeTurbine.getAbilities(MetaTileEntityLargeTurbine.ABILITY_ROTOR_HOLDER).get(0);
        if (++this.rotorCycleLength >= 230) {
            int damageToBeApplied = (int)Math.round(11.0 * rotorHolder.getRelativeRotorSpeed()) + 1;
            if (rotorHolder.applyDamageToRotor(damageToBeApplied, false)) {
                this.rotorCycleLength = 0;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    protected int calculateFuelAmount(FuelRecipe currentRecipe) {
        MetaTileEntityRotorHolder rotorHolder = this.largeTurbine.getAbilities(MetaTileEntityLargeTurbine.ABILITY_ROTOR_HOLDER).get(0);
        double relativeRotorSpeed = rotorHolder.getRelativeRotorSpeed();
        return (int)Math.floor((double)super.calculateFuelAmount(currentRecipe) * (relativeRotorSpeed * relativeRotorSpeed));
    }

    @Override
    protected long startRecipe(FuelRecipe currentRecipe, int fuelAmountUsed, int recipeDuration) {
        this.addOutputFluids(currentRecipe, fuelAmountUsed);
        return 0L;
    }

    private void addOutputFluids(FuelRecipe currentRecipe, int fuelAmountUsed) {
        FluidMaterial material;
        if (this.largeTurbine.turbineType == MetaTileEntityLargeTurbine.TurbineType.STEAM) {
            int waterFluidAmount = fuelAmountUsed / 15;
            if (waterFluidAmount > 0) {
                FluidStack waterStack = Materials.Water.getFluid(waterFluidAmount);
                this.largeTurbine.exportFluidHandler.fill(waterStack, true);
            }
        } else if (this.largeTurbine.turbineType == MetaTileEntityLargeTurbine.TurbineType.PLASMA && (material = MetaFluids.getMaterialFromFluid(currentRecipe.getRecipeFluid().getFluid())) != null) {
            this.largeTurbine.exportFluidHandler.fill(material.getFluid(fuelAmountUsed), true);
        }
    }

    @Override
    public long getRecipeOutputVoltage() {
        MetaTileEntityRotorHolder rotorHolder = this.largeTurbine.getAbilities(MetaTileEntityLargeTurbine.ABILITY_ROTOR_HOLDER).get(0);
        double relativeRotorSpeed = rotorHolder.getRelativeRotorSpeed();
        if (rotorHolder.getCurrentRotorSpeed() > 0 && rotorHolder.hasRotorInInventory()) {
            double rotorEfficiency = rotorHolder.getRotorEfficiency();
            double totalEnergyOutput = (8192.0 + 8192.0 * rotorEfficiency) * (relativeRotorSpeed * relativeRotorSpeed);
            return MathHelper.func_76143_f((double)totalEnergyOutput);
        }
        return 0L;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = super.serializeNBT();
        tagCompound.func_74768_a("CycleLength", this.rotorCycleLength);
        return tagCompound;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.rotorCycleLength = compound.func_74762_e("CycleLength");
    }

    @Override
    protected boolean shouldVoidExcessiveEnergy() {
        return true;
    }
}

