/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.MultiblockRecipeMapWorkable;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.multiblock.BlockPattern;
import gregtech.api.multiblock.FactoryBlockPattern;
import gregtech.api.multiblock.PatternMatchContext;
import gregtech.api.recipes.CountableIngredient;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.render.ICubeRenderer;
import gregtech.api.render.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityElectricBlastFurnace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.IItemHandlerModifiable;

public class MetaTileEntityMultiFurnace
extends RecipeMapMultiblockController {
    private static final MultiblockAbility<?>[] ALLOWED_ABILITIES = new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS, MultiblockAbility.EXPORT_ITEMS, MultiblockAbility.INPUT_ENERGY};
    protected int heatingCoilLevel;
    protected int heatingCoilDiscount;

    public MetaTileEntityMultiFurnace(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.FURNACE_RECIPES);
        this.recipeMapWorkable = new MultiFurnaceWorkable(this);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityMultiFurnace(this.metaTileEntityId);
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        if (this.isStructureFormed()) {
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.multi_furnace.heating_coil_level", new Object[]{this.heatingCoilLevel}));
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.multi_furnace.heating_coil_discount", new Object[]{this.heatingCoilDiscount}));
        }
        super.addDisplayText(textList);
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        BlockWireCoil.CoilType coilType = context.getOrDefault("CoilType", BlockWireCoil.CoilType.CUPRONICKEL);
        this.heatingCoilLevel = coilType.getLevel();
        this.heatingCoilDiscount = coilType.getEnergyDiscount();
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.heatingCoilLevel = 0;
        this.heatingCoilDiscount = 0;
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "CCC", "XXX").aisle("XXX", "C#C", "XXX").aisle("XSX", "CCC", "XXX").setAmountAtLeast('L', 9).where('S', this.selfPredicate()).where('L', MetaTileEntityMultiFurnace.statePredicate(this.getCasingState())).where('X', MetaTileEntityMultiFurnace.statePredicate(this.getCasingState()).or(MetaTileEntityMultiFurnace.abilityPartPredicate(ALLOWED_ABILITIES))).where('C', MetaTileEntityElectricBlastFurnace.heatingCoilPredicate()).where('#', MetaTileEntityMultiFurnace.isAirPredicate()).build();
    }

    public IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF);
    }

    @Override
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.HEAT_PROOF_CASING;
    }

    protected class MultiFurnaceWorkable
    extends MultiblockRecipeMapWorkable {
        public MultiFurnaceWorkable(RecipeMapMultiblockController tileEntity) {
            super(tileEntity);
        }

        @Override
        protected Recipe findRecipe(long maxVoltage, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs) {
            int currentItemsEngaged = 0;
            int maxItemsLimit = 16 * MetaTileEntityMultiFurnace.this.heatingCoilLevel;
            ArrayList<CountableIngredient> recipeInputs = new ArrayList<CountableIngredient>();
            ArrayList<ItemStack> recipeOutputs = new ArrayList<ItemStack>();
            for (int index = 0; index < inputs.getSlots(); ++index) {
                CountableIngredient inputIngredient;
                ItemStack stackInSlot = inputs.getStackInSlot(index);
                if (stackInSlot.func_190926_b()) continue;
                Recipe matchingRecipe = this.recipeMap.findRecipe(maxVoltage, Collections.singletonList(stackInSlot), Collections.emptyList());
                CountableIngredient countableIngredient = inputIngredient = matchingRecipe == null ? null : matchingRecipe.getInputs().get(0);
                if (inputIngredient != null && maxItemsLimit - currentItemsEngaged >= inputIngredient.getCount()) {
                    ItemStack outputStack = ((ItemStack)matchingRecipe.getOutputs().get(0)).func_77946_l();
                    int overclockAmount = Math.min(stackInSlot.func_190916_E() / inputIngredient.getCount(), (maxItemsLimit - currentItemsEngaged) / inputIngredient.getCount());
                    recipeInputs.add(new CountableIngredient(inputIngredient.getIngredient(), inputIngredient.getCount() * overclockAmount));
                    if (!outputStack.func_190926_b()) {
                        outputStack.func_190920_e(outputStack.func_190916_E() * overclockAmount);
                        recipeOutputs.add(outputStack);
                    }
                    currentItemsEngaged += inputIngredient.getCount() * overclockAmount;
                }
                if (currentItemsEngaged >= maxItemsLimit) break;
            }
            return recipeInputs.isEmpty() ? null : ((RecipeBuilder)((RecipeBuilder)((RecipeBuilder)((RecipeBuilder)((RecipeBuilder)((RecipeBuilder)this.recipeMap.recipeBuilder()).inputsIngredients(recipeInputs)).outputs(recipeOutputs)).EUt(Math.max(1, 4 * MetaTileEntityMultiFurnace.this.heatingCoilLevel / MetaTileEntityMultiFurnace.this.heatingCoilDiscount))).duration(512)).cannotBeBuffered()).build().getResult();
        }
    }
}

