/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric.multiblockpart;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.damagesources.DamageSources;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.render.Textures;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.common.items.behaviors.TurbineRotorBehavior;
import gregtech.common.metatileentities.electric.multiblockpart.MetaTileEntityMultiblockPart;
import gregtech.common.metatileentities.multi.electric.generator.MetaTileEntityLargeTurbine;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class MetaTileEntityRotorHolder
extends MetaTileEntityMultiblockPart
implements IMultiblockAbilityPart<MetaTileEntityRotorHolder> {
    private static final int NORMAL_MAXIMUM_SPEED = 6000;
    private static final float DAMAGE_PER_INTERACT = 40.0f;
    private InventoryRotorHolder rotorInventory;
    private final int maxRotorSpeed;
    private int currentRotorSpeed;
    private boolean isRotorLooping;
    private int rotorColor = -1;
    private boolean frontFaceFree;

    public MetaTileEntityRotorHolder(ResourceLocation metaTileEntityId, int tier, int maxSpeed) {
        super(metaTileEntityId, tier);
        this.maxRotorSpeed = maxSpeed;
        this.currentRotorSpeed = 0;
        this.rotorInventory = new InventoryRotorHolder();
    }

    public MetaTileEntityRotorHolder(ResourceLocation metaTileEntityId, int tier, float speedMultiplier) {
        this(metaTileEntityId, tier, (int)(6000.0f * speedMultiplier));
    }

    public ItemStackHandler getRotorInventory() {
        return this.rotorInventory;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityRotorHolder(this.metaTileEntityId, this.getTier(), this.maxRotorSpeed);
    }

    @Override
    public void update() {
        MetaTileEntityLargeTurbine controller;
        boolean isControllerActive;
        super.update();
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (this.getTimer() % 10L == 0L) {
            this.frontFaceFree = this.checkTurbineFaceFree();
        }
        boolean bl = isControllerActive = (controller = (MetaTileEntityLargeTurbine)this.getController()) != null && controller.isActive();
        if (this.currentRotorSpeed < this.maxRotorSpeed && isControllerActive) {
            this.incrementSpeed(1);
        } else if (this.currentRotorSpeed > 0 && !isControllerActive) {
            this.incrementSpeed(-3);
        }
    }

    public boolean isFrontFaceFree() {
        return this.frontFaceFree;
    }

    private boolean checkTurbineFaceFree() {
        EnumFacing facing = this.getFrontFacing();
        boolean permuteXZ = facing.func_176740_k() == EnumFacing.Axis.Z;
        BlockPos centerPos = this.getPos().func_177972_a(facing);
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                BlockPos blockPos = centerPos.func_177982_a(permuteXZ ? x : 0, y, permuteXZ ? 0 : x);
                IBlockState blockState = this.getWorld().func_180495_p(blockPos);
                if (blockState.func_177230_c() == Blocks.field_150350_a) continue;
                return false;
            }
        }
        return true;
    }

    private boolean onRotorHolderInteract(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (!this.getWorld().field_72995_K && this.isRotorLooping) {
            double relativeSpeed = this.getRelativeRotorSpeed();
            float damageApplied = (float)(40.0 * relativeSpeed);
            player.func_70097_a(DamageSources.getTurbineDamage(), damageApplied);
            return true;
        }
        return this.isRotorLooping;
    }

    public double getRelativeRotorSpeed() {
        return this.currentRotorSpeed == 0 ? 0.01 : (double)this.currentRotorSpeed / 6000.0;
    }

    public boolean isRotorLooping() {
        return this.isRotorLooping;
    }

    public boolean isHasRotor() {
        return this.rotorColor != -1;
    }

    public int getRotorColor() {
        return this.rotorColor;
    }

    public double getRotorEfficiency() {
        return this.rotorInventory.getRotorEfficiency();
    }

    public boolean hasRotorInInventory() {
        return !this.rotorInventory.getStackInSlot(0).func_190926_b();
    }

    public boolean applyDamageToRotor(int damageAmount, boolean simulate) {
        return this.rotorInventory.applyDamageToRotor(damageAmount, simulate);
    }

    public double getRotorDurability() {
        return 1.0 - this.rotorInventory.getRotorDamagePercentage();
    }

    public int getMaxRotorSpeed() {
        return this.maxRotorSpeed;
    }

    public int getCurrentRotorSpeed() {
        return this.currentRotorSpeed;
    }

    protected void incrementSpeed(int incrementSpeed) {
        boolean lastIsLooping = this.currentRotorSpeed > 0;
        this.currentRotorSpeed = MathHelper.func_76125_a((int)(this.currentRotorSpeed + incrementSpeed), (int)0, (int)this.maxRotorSpeed);
        boolean bl = this.isRotorLooping = this.currentRotorSpeed > 0;
        if (this.isRotorLooping != lastIsLooping && !this.getWorld().field_72995_K) {
            this.writeCustomData(200, writer -> writer.writeBoolean(this.isRotorLooping));
            this.markDirty();
        }
    }

    private void setRotorColor(int hasRotor1) {
        int lastHasRotor = this.rotorColor;
        this.rotorColor = hasRotor1;
        if (this.rotorColor != lastHasRotor && this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.writeCustomData(201, writer -> writer.writeInt(this.rotorColor));
            this.markDirty();
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 200) {
            this.isRotorLooping = buf.readBoolean();
            this.getHolder().scheduleChunkForRenderUpdate();
        } else if (dataId == 201) {
            this.rotorColor = buf.readInt();
            this.getHolder().scheduleChunkForRenderUpdate();
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isRotorLooping);
        buf.writeInt(this.rotorColor);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isRotorLooping = buf.readBoolean();
        this.rotorColor = buf.readInt();
    }

    @Override
    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        super.clearMachineInventory(itemBuffer);
        MetaTileEntityRotorHolder.clearInventory(itemBuffer, (IItemHandlerModifiable)this.rotorInventory);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("RotorInventory", (NBTBase)this.rotorInventory.serializeNBT());
        data.func_74768_a("CurrentSpeed", this.currentRotorSpeed);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.rotorInventory.deserializeNBT(data.func_74775_l("RotorInventory"));
        this.currentRotorSpeed = data.func_74762_e("CurrentSpeed");
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        Textures.ROTOR_HOLDER_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        Textures.LARGE_TURBINE_ROTOR_RENDERER.renderSided(renderState, translation, pipeline, this.getFrontFacing(), this.getController() != null, this.isHasRotor(), this.isRotorLooping(), this.rotorColor);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return ModularUI.defaultBuilder().label(6, 6, this.getMetaFullName()).slot((IItemHandlerModifiable)this.rotorInventory, 0, 79, 36, GuiTextures.SLOT, GuiTextures.TURBINE_OVERLAY).bindPlayerInventory(entityPlayer.field_71071_by).build(this.getHolder(), entityPlayer);
    }

    @Override
    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        return this.onRotorHolderInteract(playerIn) || super.onRightClick(playerIn, hand, facing, hitResult);
    }

    @Override
    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        return this.onRotorHolderInteract(playerIn) || super.onWrenchClick(playerIn, hand, facing, hitResult);
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        return this.onRotorHolderInteract(playerIn);
    }

    @Override
    public void onLeftClick(EntityPlayer player, EnumFacing facing, CuboidRayTraceResult hitResult) {
        this.onRotorHolderInteract(player);
    }

    @Override
    public MultiblockAbility<MetaTileEntityRotorHolder> getAbility() {
        return MetaTileEntityLargeTurbine.ABILITY_ROTOR_HOLDER;
    }

    @Override
    public void registerAbilities(List<MetaTileEntityRotorHolder> abilityList) {
        abilityList.add(this);
    }

    private class InventoryRotorHolder
    extends ItemStackHandler {
        public InventoryRotorHolder() {
            super(1);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onLoad() {
            MetaTileEntityRotorHolder.this.rotorColor = this.getRotorColor();
        }

        protected void onContentsChanged(int slot) {
            MetaTileEntityRotorHolder.this.setRotorColor(this.getRotorColor());
        }

        private int getRotorColor() {
            ItemStack itemStack = this.getStackInSlot(0);
            if (itemStack.func_190926_b()) {
                return -1;
            }
            TurbineRotorBehavior behavior = TurbineRotorBehavior.getInstanceFor(itemStack);
            if (behavior == null) {
                return -1;
            }
            IngotMaterial material = behavior.getPartMaterial(itemStack);
            return material.materialRGB;
        }

        public double getRotorEfficiency() {
            ItemStack itemStack = this.getStackInSlot(0);
            if (itemStack.func_190926_b()) {
                return 0.0;
            }
            TurbineRotorBehavior turbineRotorBehavior = TurbineRotorBehavior.getInstanceFor(itemStack);
            if (turbineRotorBehavior != null) {
                return turbineRotorBehavior.getRotorEfficiency(itemStack);
            }
            return 0.0;
        }

        public double getRotorDamagePercentage() {
            ItemStack itemStack = this.getStackInSlot(0);
            if (itemStack.func_190926_b()) {
                return 0.0;
            }
            TurbineRotorBehavior turbineRotorBehavior = TurbineRotorBehavior.getInstanceFor(itemStack);
            if (turbineRotorBehavior != null) {
                return (double)turbineRotorBehavior.getPartDamage(itemStack) / ((double)turbineRotorBehavior.getPartMaxDurability(itemStack) * 1.0);
            }
            return 0.0;
        }

        public boolean applyDamageToRotor(int damageAmount, boolean simulate) {
            ItemStack itemStack = this.getStackInSlot(0);
            if (itemStack.func_190926_b()) {
                return false;
            }
            TurbineRotorBehavior turbineRotorBehavior = TurbineRotorBehavior.getInstanceFor(itemStack);
            if (turbineRotorBehavior != null) {
                if (!simulate) {
                    turbineRotorBehavior.applyRotorDamage(itemStack, damageAmount);
                }
                return true;
            }
            return false;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (TurbineRotorBehavior.getInstanceFor(stack) != null) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    }
}

