/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.FluidContainerSlotWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.render.SimpleOverlayRenderer;
import gregtech.api.render.Textures;
import gregtech.common.metatileentities.electric.multiblockpart.MetaTileEntityMultiblockPart;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class MetaTileEntityFluidHatch
extends MetaTileEntityMultiblockPart
implements IMultiblockAbilityPart<IFluidTank> {
    private static final int[] INVENTORY_SIZES = new int[]{8000, 16000, 32000, 64000, 128000, 256000, 512000};
    private ItemStackHandler containerInventory = new ItemStackHandler(2);
    private boolean isExportHatch;

    public MetaTileEntityFluidHatch(ResourceLocation metaTileEntityId, int tier, boolean isExportHatch) {
        super(metaTileEntityId, tier);
        this.isExportHatch = isExportHatch;
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityFluidHatch(this.metaTileEntityId, this.getTier(), this.isExportHatch);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("ContainerInventory", (NBTBase)this.containerInventory.serializeNBT());
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.containerInventory.deserializeNBT(data.func_74775_l("ContainerInventory"));
    }

    @Override
    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        super.clearMachineInventory(itemBuffer);
        MetaTileEntityFluidHatch.clearInventory(itemBuffer, (IItemHandlerModifiable)this.containerInventory);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            if (this.isExportHatch) {
                this.fillContainerFromInternalTank((IItemHandlerModifiable)this.containerInventory, (IItemHandlerModifiable)this.containerInventory, 0, 1);
                this.pushFluidsIntoNearbyHandlers(this.getFrontFacing());
            } else {
                this.fillInternalTankFromFluidContainer((IItemHandlerModifiable)this.containerInventory, (IItemHandlerModifiable)this.containerInventory, 0, 1);
                this.pullFluidsFromNearbyHandlers(this.getFrontFacing());
            }
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            SimpleOverlayRenderer renderer = this.isExportHatch ? Textures.PIPE_OUT_OVERLAY : Textures.PIPE_IN_OVERLAY;
            renderer.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        }
    }

    private int getInventorySize() {
        return INVENTORY_SIZES[MathHelper.func_76125_a((int)this.getTier(), (int)0, (int)(INVENTORY_SIZES.length - 1))];
    }

    @Override
    protected FluidTankList createImportFluidHandler() {
        return this.isExportHatch ? new FluidTankList(false, new IFluidTank[0]) : new FluidTankList(false, new IFluidTank[]{new FluidTank(this.getInventorySize())});
    }

    @Override
    protected FluidTankList createExportFluidHandler() {
        return this.isExportHatch ? new FluidTankList(false, new IFluidTank[]{new FluidTank(this.getInventorySize())}) : new FluidTankList(false, new IFluidTank[0]);
    }

    @Override
    public MultiblockAbility<IFluidTank> getAbility() {
        return this.isExportHatch ? MultiblockAbility.EXPORT_FLUIDS : MultiblockAbility.IMPORT_FLUIDS;
    }

    @Override
    public void registerAbilities(List<IFluidTank> abilityList) {
        abilityList.addAll(this.isExportHatch ? this.exportFluids.getFluidTanks() : this.importFluids.getFluidTanks());
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return this.createTankUI((this.isExportHatch ? this.exportFluids : this.importFluids).getTankAt(0), (IItemHandlerModifiable)this.containerInventory, this.getMetaFullName(), entityPlayer).build(this.getHolder(), entityPlayer);
    }

    public ModularUI.Builder createTankUI(IFluidTank fluidTank, IItemHandlerModifiable containerInventory, String title, EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.defaultBuilder();
        builder.image(7, 16, 81, 55, GuiTextures.DISPLAY);
        TankWidget tankWidget = new TankWidget(fluidTank, 69, 52, 18, 18).setHideTooltip(true).setAlwaysShowFull(true);
        builder.widget(tankWidget);
        builder.label(11, 20, "gregtech.gui.fluid_amount", 0xFFFFFF);
        builder.dynamicLabel(11, 30, tankWidget::getFormattedFluidAmount, 0xFFFFFF);
        builder.dynamicLabel(11, 40, tankWidget::getFluidLocalizedName, 0xFFFFFF);
        return builder.label(6, 6, title).widget(new FluidContainerSlotWidget(containerInventory, 0, 90, 17, !this.isExportHatch).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.IN_SLOT_OVERLAY)).widget(new ImageWidget(91, 36, 14, 15, GuiTextures.TANK_ICON)).widget(new SlotWidget(containerInventory, 1, 90, 54, true, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.OUT_SLOT_OVERLAY)).bindPlayerInventory(entityPlayer.field_71071_by);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.getInventorySize()}));
    }
}

