/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.render.Textures;
import gregtech.api.unification.stack.SimpleItemStack;
import gregtech.api.util.PipelineUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class MetaTileEntityTransformer
extends TieredMetaTileEntity {
    private boolean isTransformUp;

    public MetaTileEntityTransformer(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityTransformer(this.metaTileEntityId, this.getTier());
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("Inverted", this.isTransformUp);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isTransformUp = data.func_74767_n("Inverted");
        this.reinitializeEnergyContainer();
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isTransformUp);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isTransformUp = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 100) {
            this.isTransformUp = buf.readBoolean();
        }
    }

    public boolean isInverted() {
        return this.isTransformUp;
    }

    public void setTransformUp(boolean inverted) {
        this.isTransformUp = inverted;
        if (!this.getWorld().field_72995_K) {
            this.reinitializeEnergyContainer();
            this.writeCustomData(100, b -> b.writeBoolean(this.isTransformUp));
            this.markDirty();
        }
    }

    @Override
    protected void reinitializeEnergyContainer() {
        long tierVoltage = GTValues.V[this.getTier()];
        this.energyContainer = this.isTransformUp ? new EnergyContainerHandler(this, tierVoltage * 8L, tierVoltage / 4L, 4L, tierVoltage, 1L) : new EnergyContainerHandler(this, tierVoltage * 8L, tierVoltage, 1L, tierVoltage / 4L, 4L);
        ((EnergyContainerHandler)this.energyContainer).setSideInputCondition(s -> s == this.getFrontFacing());
        ((EnergyContainerHandler)this.energyContainer).setSideOutputCondition(s -> s == this.getFrontFacing().func_176734_d());
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.isTransformUp) {
            Textures.ENERGY_OUT_MULTI.renderSided(this.getFrontFacing(), renderState, translation, PipelineUtil.color(pipeline, GTValues.VC[this.getTier() - 1]));
            Textures.ENERGY_IN.renderSided(this.getFrontFacing().func_176734_d(), renderState, translation, PipelineUtil.color(pipeline, GTValues.VC[this.getTier()]));
        } else {
            Textures.ENERGY_IN_MULTI.renderSided(this.getFrontFacing(), renderState, translation, PipelineUtil.color(pipeline, GTValues.VC[this.getTier()]));
            Textures.ENERGY_OUT.renderSided(this.getFrontFacing().func_176734_d(), renderState, translation, PipelineUtil.color(pipeline, GTValues.VC[this.getTier() - 1]));
        }
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        ItemStack itemStack = playerIn.func_184586_b(hand);
        if (!itemStack.func_190926_b() && GregTechAPI.softHammerList.contains(new SimpleItemStack(itemStack))) {
            if (this.getWorld().field_72995_K) {
                return true;
            }
            if (this.isTransformUp) {
                this.setTransformUp(false);
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.transformer.message_transform_down", new Object[]{this.energyContainer.getInputVoltage(), this.energyContainer.getInputAmperage(), this.energyContainer.getOutputVoltage(), this.energyContainer.getOutputAmperage()}));
                return true;
            }
            this.setTransformUp(true);
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.transformer.message_transform_up", new Object[]{this.energyContainer.getInputVoltage(), this.energyContainer.getInputAmperage(), this.energyContainer.getOutputVoltage(), this.energyContainer.getOutputAmperage()}));
            return true;
        }
        return false;
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        String lowerTierName = GTValues.VN[this.getTier() - 1];
        String higherTierName = GTValues.VN[this.getTier()];
        long lowerVoltage = this.energyContainer.getOutputVoltage();
        long higherVoltage = this.energyContainer.getInputVoltage();
        long lowerAmperage = this.energyContainer.getInputAmperage();
        long higherAmperage = this.energyContainer.getOutputAmperage();
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer.tooltip_tool_usage", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer.tooltip_transform_down", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{higherVoltage, higherTierName}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_out", (Object[])new Object[]{lowerVoltage, lowerTierName}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.amperage_in", (Object[])new Object[]{lowerAmperage}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.amperage_out", (Object[])new Object[]{higherAmperage}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.transformer.tooltip_transform_up", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{lowerVoltage, lowerTierName}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_out", (Object[])new Object[]{higherVoltage, higherTierName}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.amperage_in", (Object[])new Object[]{higherAmperage}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.amperage_out", (Object[])new Object[]{lowerAmperage}));
    }
}

