/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ServerWidgetGroup;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverConveyor;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CoverRoboticArm
extends CoverConveyor {
    protected TransferMode transferMode = TransferMode.TRANSFER_ANY;

    public CoverRoboticArm(ICoverable coverable, EnumFacing attachedSide, int tier, int itemsPerSecond) {
        super(coverable, attachedSide, tier, itemsPerSecond);
        this.itemFilterSlots = new ItemStackHandler(9){

            public int getSlotLimit(int slot) {
                return CoverRoboticArm.this.maxItemTransferRate;
            }
        };
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox) {
        Textures.ARM_OVERLAY.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    public void func_73660_a() {
        this.transferMode.executor.accept(this);
    }

    protected void doTransferExact() {
        if (this.coverHolder.getTimer() % 20L == 0L) {
            int[] itemsTransferred;
            TileEntity tileEntity = this.coverHolder.getWorld().func_175625_s(this.coverHolder.getPos().func_177972_a(this.attachedSide));
            IItemHandler itemHandler = tileEntity == null ? null : (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.attachedSide.func_176734_d());
            IItemHandler myItemHandler = (IItemHandler)this.coverHolder.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.attachedSide);
            if (itemHandler == null || myItemHandler == null) {
                return;
            }
            int[] itemsTransferLimits = new int[this.filterMode.maxMatchSlots];
            if (this.filterMode == CoverConveyor.FilterType.ITEM_FILTER) {
                for (int i = 0; i < itemsTransferLimits.length; ++i) {
                    ItemStack filterStack = this.itemFilterSlots.getStackInSlot(i);
                    itemsTransferLimits[i] = filterStack.func_190916_E();
                }
            } else {
                itemsTransferLimits[0] = this.filterMode == CoverConveyor.FilterType.ORE_DICTIONARY_FILTER ? this.transferRate : this.transferRate;
            }
            if (Arrays.equals(itemsTransferLimits, itemsTransferred = this.doTransferItemsInternal(itemHandler, myItemHandler, this.transferRate, itemsTransferLimits, true))) {
                this.doTransferItemsInternal(itemHandler, myItemHandler, this.transferRate, itemsTransferLimits, false);
            }
        }
    }

    private void doKeepExact() {
        if (this.coverHolder.getTimer() % 20L == 0L) {
            int[] itemsTransferred;
            int[] itemsToMove;
            TileEntity tileEntity = this.coverHolder.getWorld().func_175625_s(this.coverHolder.getPos().func_177972_a(this.attachedSide));
            IItemHandler itemHandler = tileEntity == null ? null : (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.attachedSide.func_176734_d());
            IItemHandler myItemHandler = (IItemHandler)this.coverHolder.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.attachedSide);
            if (itemHandler == null || myItemHandler == null) {
                return;
            }
            int[] currentItemAmount = this.doCountDestinationInventoryItems(itemHandler, myItemHandler);
            int[] keepItemAmount = new int[currentItemAmount.length];
            if (this.filterMode == CoverConveyor.FilterType.ITEM_FILTER) {
                for (int i = 0; i < keepItemAmount.length; ++i) {
                    ItemStack filterStack = this.itemFilterSlots.getStackInSlot(i);
                    keepItemAmount[i] = filterStack.func_190916_E();
                }
            } else {
                keepItemAmount[0] = this.filterMode == CoverConveyor.FilterType.ORE_DICTIONARY_FILTER ? this.transferRate : this.transferRate;
            }
            if (Arrays.equals(itemsToMove = CoverRoboticArm.calculateItemsToMove(currentItemAmount, keepItemAmount), itemsTransferred = this.doTransferItemsInternal(itemHandler, myItemHandler, this.transferRate, itemsToMove, true))) {
                this.doTransferItemsInternal(itemHandler, myItemHandler, this.transferRate, itemsToMove, false);
            }
        }
    }

    private static int[] calculateItemsToMove(int[] currentItemAmount, int[] keepItemAmount) {
        int[] resultAmount = new int[currentItemAmount.length];
        for (int i = 0; i < resultAmount.length; ++i) {
            int minAmount = keepItemAmount[i];
            int currentAmount = currentItemAmount[i];
            if (minAmount <= currentAmount) continue;
            resultAmount[i] = minAmount - currentAmount;
        }
        return resultAmount;
    }

    public void setTransferMode(TransferMode transferMode) {
        this.transferMode = transferMode;
        this.coverHolder.markDirty();
    }

    @Override
    protected void onFilterModeUpdated() {
        super.onFilterModeUpdated();
        if (this.filterMode == CoverConveyor.FilterType.NONE) {
            this.setTransferMode(TransferMode.TRANSFER_ANY);
        }
    }

    @Override
    protected String getUITitle() {
        return "cover.robotic_arm.title";
    }

    @Override
    protected ModularUI buildUI(ModularUI.Builder builder, EntityPlayer player) {
        ServerWidgetGroup filterGroup = new ServerWidgetGroup(() -> this.filterMode != CoverConveyor.FilterType.NONE);
        filterGroup.addWidget(new CycleButtonWidget(91, 45, 75, 20, GTUtility.mapToString(TransferMode.values(), it -> it.localeName), () -> this.transferMode.ordinal(), newMode -> this.setTransferMode(TransferMode.values()[newMode])).setTooltipHoverString("cover.robotic_arm.transfer_mode.description"));
        return super.buildUI(builder.widget(filterGroup), player);
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("TransferMode", this.transferMode.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.transferMode = TransferMode.values()[tagCompound.func_74762_e("TransferMode")];
    }

    public static enum TransferMode {
        TRANSFER_ANY("cover.robotic_arm.transfer_mode.transfer_any", CoverConveyor::doTransferAny),
        TRANSFER_EXACT("cover.robotic_arm.transfer_mode.transfer_exact", CoverRoboticArm::doTransferExact),
        KEEP_EXACT("cover.robotic_arm.transfer_mode.keep_exact", rec$ -> CoverRoboticArm.access$000((CoverRoboticArm)rec$));

        public final String localeName;
        protected final Consumer<CoverRoboticArm> executor;

        private TransferMode(String localeName, Consumer<CoverRoboticArm> executor) {
            this.localeName = localeName;
            this.executor = executor;
        }
    }
}

