/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.ItemHandlerDelegate;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.PhantomSlotWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.ItemFilterMode;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CoverItemFilter
extends CoverBehavior
implements CoverWithUI {
    protected ItemStackHandler itemFilterSlots;
    protected boolean ignoreDamage = true;
    protected boolean ignoreNBT = true;
    protected ItemFilterMode filterMode = ItemFilterMode.FILTER_INSERT;
    protected ItemHandlerFiltered itemHandler;

    public CoverItemFilter(ICoverable coverHolder, EnumFacing attachedSide) {
        super(coverHolder, attachedSide);
        this.itemFilterSlots = new ItemStackHandler(9){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    protected void setIgnoreDamage(boolean ignoreDamage) {
        this.ignoreDamage = ignoreDamage;
        this.coverHolder.markDirty();
    }

    protected void setIgnoreNBT(boolean ignoreNBT) {
        this.ignoreNBT = ignoreNBT;
        this.coverHolder.markDirty();
    }

    protected void setFilterMode(ItemFilterMode filterMode) {
        this.filterMode = filterMode;
        this.coverHolder.markDirty();
    }

    @Override
    public boolean canAttach() {
        return this.coverHolder.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.attachedSide) != null;
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (!playerIn.field_70170_p.field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup itemFilterGroup = new WidgetGroup();
        itemFilterGroup.addWidget(new LabelWidget(10, 5, "cover.item_filter.title", new Object[0]));
        itemFilterGroup.addWidget(new CycleButtonWidget(10, 20, 110, 20, GTUtility.mapToString(ItemFilterMode.values(), it -> it.localeName), () -> this.filterMode.ordinal(), newMode -> this.setFilterMode(ItemFilterMode.values()[newMode])));
        for (int i = 0; i < 9; ++i) {
            itemFilterGroup.addWidget(new PhantomSlotWidget((IItemHandlerModifiable)this.itemFilterSlots, i, 10 + 18 * (i % 3), 46 + 18 * (i / 3)).setBackgroundTexture(GuiTextures.SLOT));
        }
        itemFilterGroup.addWidget(new ToggleButtonWidget(74, 45, 20, 20, GuiTextures.BUTTON_FILTER_DAMAGE, () -> this.ignoreDamage, this::setIgnoreDamage));
        itemFilterGroup.addWidget(new ToggleButtonWidget(99, 45, 20, 20, GuiTextures.BUTTON_FILTER_NBT, () -> this.ignoreNBT, this::setIgnoreNBT));
        return ModularUI.builder(GuiTextures.BACKGROUND, 176, 128).widget(itemFilterGroup).bindPlayerHotbar(player.field_71071_by, GuiTextures.SLOT, 8, 105).build(this, player);
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox) {
        Textures.ITEM_FILTER_FILTER_OVERLAY.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74782_a("FilterInventory", (NBTBase)this.itemFilterSlots.serializeNBT());
        tagCompound.func_74757_a("IgnoreDamage", this.ignoreDamage);
        tagCompound.func_74757_a("IgnoreNBT", this.ignoreNBT);
        tagCompound.func_74768_a("FilterMode", this.filterMode.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.itemFilterSlots.deserializeNBT(tagCompound.func_74775_l("FilterInventory"));
        this.ignoreDamage = tagCompound.func_74767_n("IgnoreDamage");
        this.ignoreNBT = tagCompound.func_74767_n("IgnoreNBT");
        this.filterMode = ItemFilterMode.values()[tagCompound.func_74762_e("FilterMode")];
    }

    @Override
    public <T> T getCapability(Capability<T> capability, T defaultValue) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            IItemHandler delegate = (IItemHandler)defaultValue;
            if (this.itemHandler == null || this.itemHandler.delegate != delegate) {
                this.itemHandler = new ItemHandlerFilteredImpl(delegate);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
        }
        return defaultValue;
    }

    public static int itemFilterMatch(IItemHandler filterSlots, boolean ignoreDamage, boolean ignoreNBTData, ItemStack itemStack) {
        for (int i = 0; i < filterSlots.getSlots(); ++i) {
            ItemStack filterStack = filterSlots.getStackInSlot(i);
            if (filterStack.func_190926_b() || !CoverItemFilter.areItemsEqual(ignoreDamage, ignoreNBTData, filterStack, itemStack)) continue;
            return i;
        }
        return -1;
    }

    private static boolean areItemsEqual(boolean ignoreDamage, boolean ignoreNBTData, ItemStack filterStack, ItemStack itemStack) {
        if (ignoreDamage ? !filterStack.func_185136_b(itemStack) : !filterStack.func_77969_a(itemStack)) {
            return false;
        }
        return ignoreNBTData || ItemStack.func_77970_a((ItemStack)filterStack, (ItemStack)itemStack);
    }

    public static abstract class ItemHandlerFiltered
    extends ItemHandlerDelegate {
        public ItemHandlerFiltered(IItemHandler delegate) {
            super(delegate);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemFilterMode filterMode = this.getFilterMode();
            if (filterMode == ItemFilterMode.FILTER_EXTRACT) {
                return stack;
            }
            if (CoverItemFilter.itemFilterMatch(this.getFilterSlots(), this.isIgnoreDamage(), this.isIgnoreNBT(), stack) == -1) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Override
        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemFilterMode filterMode = this.getFilterMode();
            if (filterMode == ItemFilterMode.FILTER_INSERT) {
                return ItemStack.field_190927_a;
            }
            ItemStack result = super.extractItem(slot, amount, true);
            if (CoverItemFilter.itemFilterMatch(this.getFilterSlots(), this.isIgnoreDamage(), this.isIgnoreNBT(), result) == -1) {
                return ItemStack.field_190927_a;
            }
            if (!simulate) {
                super.extractItem(slot, amount, false);
            }
            return result;
        }

        public abstract ItemFilterMode getFilterMode();

        public abstract IItemHandler getFilterSlots();

        public abstract boolean isIgnoreDamage();

        public abstract boolean isIgnoreNBT();
    }

    private class ItemHandlerFilteredImpl
    extends ItemHandlerFiltered {
        public ItemHandlerFilteredImpl(IItemHandler delegate) {
            super(delegate);
        }

        @Override
        public ItemFilterMode getFilterMode() {
            return CoverItemFilter.this.filterMode;
        }

        @Override
        public IItemHandler getFilterSlots() {
            return CoverItemFilter.this.itemFilterSlots;
        }

        @Override
        public boolean isIgnoreDamage() {
            return CoverItemFilter.this.ignoreDamage;
        }

        @Override
        public boolean isIgnoreNBT() {
            return CoverItemFilter.this.ignoreNBT;
        }
    }
}

