/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.ICoverable;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.util.GTLog;
import gregtech.common.covers.CoverConveyor;
import gregtech.common.covers.CoverFluidFilter;
import gregtech.common.covers.CoverItemFilter;
import gregtech.common.covers.CoverOreDictionaryFilter;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.CoverRoboticArm;
import gregtech.common.covers.CoverShutter;
import gregtech.common.covers.CoverSolarPanel;
import gregtech.common.items.MetaItems;
import gregtech.common.items.behaviors.CoverPlaceBehavior;
import java.util.function.BiFunction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class CoverBehaviors {
    public static void init() {
        GTLog.logger.info("Registering cover behaviors...");
        CoverBehaviors.registerBehavior(0, new ResourceLocation("gregtech", "conveyor.lv"), MetaItems.CONVEYOR_MODULE_LV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 1, 8));
        CoverBehaviors.registerBehavior(1, new ResourceLocation("gregtech", "conveyor.mv"), MetaItems.CONVEYOR_MODULE_MV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 2, 32));
        CoverBehaviors.registerBehavior(2, new ResourceLocation("gregtech", "conveyor.hv"), MetaItems.CONVEYOR_MODULE_HV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 3, 64));
        CoverBehaviors.registerBehavior(3, new ResourceLocation("gregtech", "conveyor.ev"), MetaItems.CONVEYOR_MODULE_EV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 4, 192));
        CoverBehaviors.registerBehavior(4, new ResourceLocation("gregtech", "conveyor.iv"), MetaItems.CONVEYOR_MODULE_IV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 5, 512));
        CoverBehaviors.registerBehavior(5, new ResourceLocation("gregtech", "conveyor.luv"), MetaItems.CONVEYOR_MODULE_LUV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 6, 1024));
        CoverBehaviors.registerBehavior(6, new ResourceLocation("gregtech", "conveyor.zpm"), MetaItems.CONVEYOR_MODULE_ZPM, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 7, 1024));
        CoverBehaviors.registerBehavior(7, new ResourceLocation("gregtech", "conveyor.uv"), MetaItems.CONVEYOR_MODULE_UV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 8, 1024));
        CoverBehaviors.registerBehavior(10, new ResourceLocation("gregtech", "robotic_arm.lv"), MetaItems.ROBOT_ARM_LV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 1, 8));
        CoverBehaviors.registerBehavior(11, new ResourceLocation("gregtech", "robotic_arm.mv"), MetaItems.ROBOT_ARM_MV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 2, 32));
        CoverBehaviors.registerBehavior(12, new ResourceLocation("gregtech", "robotic_arm.hv"), MetaItems.ROBOT_ARM_HV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 3, 64));
        CoverBehaviors.registerBehavior(13, new ResourceLocation("gregtech", "robotic_arm.ev"), MetaItems.ROBOT_ARM_EV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 4, 192));
        CoverBehaviors.registerBehavior(14, new ResourceLocation("gregtech", "robotic_arm.iv"), MetaItems.ROBOT_ARM_IV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 5, 512));
        CoverBehaviors.registerBehavior(15, new ResourceLocation("gregtech", "robotic_arm.luv"), MetaItems.ROBOT_ARM_LUV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 6, 1024));
        CoverBehaviors.registerBehavior(16, new ResourceLocation("gregtech", "robotic_arm.zpm"), MetaItems.ROBOT_ARM_ZPM, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 7, 1024));
        CoverBehaviors.registerBehavior(17, new ResourceLocation("gregtech", "robotic_arm.uv"), MetaItems.ROBOT_ARM_UV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 8, 1024));
        CoverBehaviors.registerBehavior(20, new ResourceLocation("gregtech", "pump.lv"), MetaItems.ELECTRIC_PUMP_LV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 1, 640));
        CoverBehaviors.registerBehavior(21, new ResourceLocation("gregtech", "pump.mv"), MetaItems.ELECTRIC_PUMP_MV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 2, 2560));
        CoverBehaviors.registerBehavior(22, new ResourceLocation("gregtech", "pump.hv"), MetaItems.ELECTRIC_PUMP_HV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 3, 10240));
        CoverBehaviors.registerBehavior(23, new ResourceLocation("gregtech", "pump.ev"), MetaItems.ELECTRIC_PUMP_EV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 4, 40490));
        CoverBehaviors.registerBehavior(24, new ResourceLocation("gregtech", "pump.iv"), MetaItems.ELECTRIC_PUMP_IV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 5, 163840));
        CoverBehaviors.registerBehavior(25, new ResourceLocation("gregtech", "pump.luv"), MetaItems.ELECTRIC_PUMP_LUV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 6, 655360));
        CoverBehaviors.registerBehavior(26, new ResourceLocation("gregtech", "pump.zpm"), MetaItems.ELECTRIC_PUMP_ZPM, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 7, 655360));
        CoverBehaviors.registerBehavior(27, new ResourceLocation("gregtech", "pump.uv"), MetaItems.ELECTRIC_PUMP_UV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 8, 655360));
        CoverBehaviors.registerBehavior(30, new ResourceLocation("gregtech", "ore_dictionary_filter"), MetaItems.ORE_DICTIONARY_FILTER, CoverOreDictionaryFilter::new);
        CoverBehaviors.registerBehavior(31, new ResourceLocation("gregtech", "item_filter"), MetaItems.ITEM_FILTER, CoverItemFilter::new);
        CoverBehaviors.registerBehavior(32, new ResourceLocation("gregtech", "fluid_filter"), MetaItems.FLUID_FILTER, CoverFluidFilter::new);
        CoverBehaviors.registerBehavior(33, new ResourceLocation("gregtech", "shutter"), MetaItems.COVER_SHUTTER, CoverShutter::new);
        CoverBehaviors.registerBehavior(34, new ResourceLocation("gregtech", "solar_panel.basic"), MetaItems.COVER_SOLAR_PANEL, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, 1));
        CoverBehaviors.registerBehavior(35, new ResourceLocation("gregtech", "solar_panel.ulv"), MetaItems.COVER_SOLAR_PANEL_ULV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, 8));
        CoverBehaviors.registerBehavior(36, new ResourceLocation("gregtech", "solar_panel.lv"), MetaItems.COVER_SOLAR_PANEL_LV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, 32));
    }

    public static void registerBehavior(int coverNetworkId, ResourceLocation coverId, MetaItem.MetaValueItem placerItem, BiFunction<ICoverable, EnumFacing, CoverBehavior> behaviorCreator) {
        CoverDefinition coverDefinition = new CoverDefinition(coverId, behaviorCreator, placerItem.getStackForm());
        CoverDefinition.registerCover(coverNetworkId, coverDefinition);
        placerItem.addStats(new CoverPlaceBehavior(coverDefinition));
    }
}

