/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks.surfacerock;

import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.blocks.properties.PropertyMaterial;
import gregtech.common.blocks.surfacerock.BlockSurfaceRock;
import gregtech.common.render.StoneRenderer;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSurfaceRockFlooded
extends BlockLiquid {
    public final PropertyMaterial materialProperty;

    public BlockSurfaceRockFlooded(gregtech.api.unification.material.type.Material[] allowedValues) {
        super(Material.field_151586_h);
        this.materialProperty = PropertyMaterial.create("material", allowedValues);
        this.func_149711_c(1.0f);
        this.func_149752_b(0.3f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c("surface_rock");
        this.initBlockState();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.func_175697_a(pos, 4)) {
            return;
        }
        Set<EnumFacing> flowDirections = this.getPossibleFlowDirections(worldIn, pos);
        for (EnumFacing direction : flowDirections) {
            this.tryFlowInto(worldIn, pos.func_177972_a(direction), worldIn.func_180495_p(pos.func_177972_a(direction)), 8);
        }
    }

    private Set<EnumFacing> getPossibleFlowDirections(World worldIn, BlockPos pos) {
        int minSlopeDistance = 1000;
        EnumSet<EnumFacing> resultSet = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing direction : EnumFacing.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.func_177972_a(direction);
            IBlockState blockState = worldIn.func_180495_p(offsetPos);
            if (this.isBlockBlockedForFlow(blockState) || blockState.func_185904_a() == this.field_149764_J && (Integer)blockState.func_177229_b((IProperty)field_176367_b) <= 0) continue;
            int slopeDistance = this.isBlockBlockedForFlow(worldIn.func_180495_p(offsetPos.func_177977_b())) ? this.getSlopeDistance(worldIn, offsetPos, 1, direction.func_176734_d()) : 0;
            if (slopeDistance < minSlopeDistance) {
                resultSet.clear();
            }
            if (slopeDistance > minSlopeDistance) continue;
            resultSet.add(direction);
            minSlopeDistance = slopeDistance;
        }
        return resultSet;
    }

    private int getSlopeDistance(World worldIn, BlockPos pos, int distance, EnumFacing calculateFlowCost) {
        int slopeDistance = 1000;
        for (EnumFacing direction : EnumFacing.Plane.HORIZONTAL) {
            int thisSlopDistance;
            BlockPos offsetPos;
            IBlockState blockState;
            if (direction == calculateFlowCost || this.isBlockBlockedForFlow(blockState = worldIn.func_180495_p(offsetPos = pos.func_177972_a(direction))) || blockState.func_185904_a() == this.field_149764_J && (Integer)blockState.func_177229_b((IProperty)field_176367_b) <= 0) continue;
            if (!this.isBlockBlockedForFlow(worldIn.func_180495_p(offsetPos.func_177977_b()))) {
                return distance;
            }
            if (distance >= 4 || (thisSlopDistance = this.getSlopeDistance(worldIn, offsetPos, distance + 1, direction.func_176734_d())) >= slopeDistance) continue;
            slopeDistance = thisSlopDistance;
        }
        return slopeDistance;
    }

    private void tryFlowInto(World worldIn, BlockPos pos, IBlockState state, int level) {
        if (this.canFlowInto(state)) {
            if (state.func_185904_a() != Material.field_151579_a && state.func_177230_c() != Blocks.field_150431_aC) {
                state.func_177230_c().func_176226_b(worldIn, pos, state, 0);
            }
            worldIn.func_180501_a(pos, Blocks.field_150358_i.func_176223_P().func_177226_a((IProperty)field_176367_b, (Comparable)Integer.valueOf(level)), 3);
        }
    }

    private boolean canFlowInto(IBlockState state) {
        Material material = state.func_185904_a();
        return material != this.field_149764_J && material != Material.field_151587_i && !this.isBlockBlockedForFlow(state);
    }

    private boolean isBlockBlockedForFlow(IBlockState state) {
        Block block = state.func_177230_c();
        Material mat = state.func_185904_a();
        if (!(block instanceof BlockDoor) && block != Blocks.field_150472_an && block != Blocks.field_150468_ap && block != Blocks.field_150436_aH) {
            return mat == Material.field_151567_E || mat == Material.field_189963_J || mat.func_76230_c();
        }
        return true;
    }

    protected void initBlockState() {
        BlockStateContainer stateContainer;
        this.field_176227_L = stateContainer = this.func_180661_e();
        this.func_180632_j(stateContainer.func_177621_b().func_177226_a((IProperty)field_176367_b, (Comparable)Integer.valueOf(0)));
    }

    protected BlockStateContainer func_180661_e() {
        if (this.materialProperty == null) {
            return new BlockStateContainer((Block)this, new IProperty[]{field_176367_b});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.materialProperty, field_176367_b});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.materialProperty, (Comparable)this.materialProperty.getAllowedValues().get(meta));
    }

    public int func_176201_c(IBlockState state) {
        return this.materialProperty.getAllowedValues().indexOf((Object)state.func_177229_b((IProperty)this.materialProperty));
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return BlockSurfaceRock.getShapeFromBlockPos(pos).aabb().func_186670_a(pos);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return BlockSurfaceRock.getShapeFromBlockPos(pos).aabb();
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return true;
    }

    private ItemStack getDropStack(IBlockState state, int amount) {
        gregtech.api.unification.material.type.Material material = (gregtech.api.unification.material.type.Material)state.func_177229_b((IProperty)this.materialProperty);
        if (material instanceof IngotMaterial && ((IngotMaterial)material).blastFurnaceTemperature == 0) {
            return OreDictUnifier.get(OrePrefix.nugget, material, amount);
        }
        return OreDictUnifier.get(OrePrefix.dustTiny, material, amount);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getDropStack(state, 1);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int amount = 1 + rand.nextInt(fortune == 0 ? 1 : fortune);
        drops.add((Object)this.getDropStack(state, amount));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        worldIn.func_175684_a(pos, state.func_177230_c(), 5);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (fromPos.func_177984_a().equals((Object)pos) && worldIn.func_180495_p(fromPos).func_193401_d((IBlockAccess)worldIn, fromPos, EnumFacing.UP) != BlockFaceShape.SOLID) {
            worldIn.func_175655_b(pos, true);
            worldIn.func_175656_a(pos, Blocks.field_150355_j.func_176223_P().func_177226_a((IProperty)field_176367_b, state.func_177229_b((IProperty)field_176367_b)));
            return;
        }
        worldIn.func_175684_a(pos, state.func_177230_c(), 5);
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175656_a(pos, Blocks.field_150355_j.func_176223_P().func_177226_a((IProperty)field_176367_b, state.func_177229_b((IProperty)field_176367_b)));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return StoneRenderer.BLOCK_RENDER_TYPE;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return super.canRenderInLayer(state, layer) || layer == BlockRenderLayer.SOLID;
    }
}

