/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.GregTechAPI;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.common.blocks.FrameItemBlock;
import java.util.HashSet;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class BlockFrame
extends BlockColored {
    private static final AxisAlignedBB COLLISION_BOX = new AxisAlignedBB(0.05, 0.0, 0.05, 0.95, 1.0, 0.95);
    private static final int SCAFFOLD_PILLAR_RADIUS_SQ = 10;
    public final SolidMaterial frameMaterial;

    public BlockFrame(SolidMaterial material) {
        super(ModHandler.isMaterialWood(material) ? Material.field_151575_d : Material.field_151573_f);
        this.frameMaterial = material;
        this.func_149663_c("frame");
        this.func_149711_c(3.0f);
        this.func_149752_b(6.0f);
        this.setHarvestLevel(ModHandler.isMaterialWood(material) ? "axe" : "pickaxe", 1);
        this.func_149672_a(ModHandler.isMaterialWood(material) ? SoundType.field_185848_a : SoundType.field_185852_e);
        this.func_149647_a(GregTechAPI.TAB_GREGTECH_MATERIALS);
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stackInHand = playerIn.func_184586_b(hand);
        if (stackInHand.func_190926_b() || !(stackInHand.func_77973_b() instanceof FrameItemBlock)) {
            return false;
        }
        IBlockState blockState = ((FrameItemBlock)stackInHand.func_77973_b()).getBlockState(stackInHand);
        if (blockState != worldIn.func_180495_p(pos)) {
            return false;
        }
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(pos);
        for (int i = 0; i < 32; ++i) {
            IBlockState stateHere = worldIn.func_180495_p((BlockPos)blockPos);
            if (stateHere != state) {
                if (this.func_176196_c(worldIn, (BlockPos)blockPos)) {
                    worldIn.func_175656_a((BlockPos)blockPos, blockState);
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        stackInHand.func_190918_g(1);
                    }
                    return true;
                }
                return false;
            }
            blockPos.func_189536_c(EnumFacing.UP);
        }
        return false;
    }

    protected boolean canBlockStay(World worldIn, BlockPos pos) {
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(pos);
        currentPos.func_189536_c(EnumFacing.DOWN);
        IBlockState downState = worldIn.func_180495_p((BlockPos)currentPos);
        if (downState.func_177230_c() instanceof BlockFrame ? this.canFrameSupportVertical(worldIn, (BlockPos)currentPos) : downState.func_193401_d((IBlockAccess)worldIn, (BlockPos)currentPos, EnumFacing.UP) == BlockFaceShape.SOLID) {
            return true;
        }
        currentPos.func_189536_c(EnumFacing.UP);
        HashSet<BlockPos> observedSet = new HashSet<BlockPos>();
        Stack<EnumFacing> moveStack = new Stack<EnumFacing>();
        while (true) {
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                currentPos.func_189536_c(facing);
                IBlockState blockStateHere = worldIn.func_180495_p((BlockPos)currentPos);
                if (blockStateHere.func_177230_c() instanceof BlockFrame && currentPos.func_177951_i((Vec3i)pos) <= 10.0 && !observedSet.contains(currentPos)) {
                    observedSet.add(currentPos.func_185334_h());
                    currentPos.func_189536_c(EnumFacing.DOWN);
                    downState = worldIn.func_180495_p((BlockPos)currentPos);
                    if (downState.func_177230_c() instanceof BlockFrame ? this.canFrameSupportVertical(worldIn, (BlockPos)currentPos) : downState.func_193401_d((IBlockAccess)worldIn, (BlockPos)currentPos, EnumFacing.UP) == BlockFaceShape.SOLID) {
                        return true;
                    }
                    currentPos.func_189536_c(EnumFacing.UP);
                    moveStack.push(facing.func_176734_d());
                    continue;
                }
                currentPos.func_189536_c(facing.func_176734_d());
            }
            if (moveStack.isEmpty()) break;
            currentPos.func_189536_c((EnumFacing)moveStack.pop());
        }
        return false;
    }

    private boolean canFrameSupportVertical(World worldIn, BlockPos framePos) {
        IBlockState blockState;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(framePos);
        do {
            blockPos.func_189536_c(EnumFacing.DOWN);
        } while ((blockState = worldIn.func_180495_p((BlockPos)blockPos)).func_177230_c() instanceof BlockFrame);
        return blockState.func_193401_d((IBlockAccess)worldIn, (BlockPos)blockPos, EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canBlockStay(worldIn, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.field_70159_w = MathHelper.func_151237_a((double)entityIn.field_70159_w, (double)-0.15, (double)0.15);
        entityIn.field_70179_y = MathHelper.func_151237_a((double)entityIn.field_70179_y, (double)-0.15, (double)0.15);
        entityIn.field_70143_R = 0.0f;
        if (entityIn.field_70181_x < -0.15) {
            entityIn.field_70181_x = -0.15;
        }
        if (entityIn.func_70093_af() && entityIn.field_70181_x < 0.0) {
            entityIn.field_70181_x = 0.0;
        }
        if (entityIn.field_70123_F) {
            entityIn.field_70181_x = 0.2;
        }
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLISION_BOX;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP || face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }
}

