/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import codechicken.lib.texture.TextureUtils;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.realmsclient.gui.ChatFormatting;
import gregtech.api.render.MetaTileEntityRenderer;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTLog;
import gregtech.common.CommonProxy;
import gregtech.common.MetaEntities;
import gregtech.common.MetaFluids;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.BlockOre;
import gregtech.common.blocks.FrameItemBlock;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.surfacerock.BlockSurfaceRock;
import gregtech.common.blocks.surfacerock.BlockSurfaceRockFlooded;
import gregtech.common.items.MetaItems;
import gregtech.common.render.CableRenderer;
import gregtech.common.render.FluidPipeRenderer;
import gregtech.common.render.StoneRenderer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    private static final ResourceLocation GREGTECH_CAPE_TEXTURE = new ResourceLocation("gregtech", "textures/gregtechcape.png");
    public static final IBlockColor COMPRESSED_BLOCK_COLOR = (state, worldIn, pos, tintIndex) -> ((Material)state.func_177229_b((IProperty)((BlockCompressed)state.func_177230_c()).variantProperty)).materialRGB;
    public static final IItemColor COMPRESSED_ITEM_COLOR = (stack, tintIndex) -> {
        BlockCompressed block = (BlockCompressed)((ItemBlock)stack.func_77973_b()).func_179223_d();
        IBlockState state = block.func_176203_a(stack.func_77952_i());
        return ((Material)state.func_177229_b((IProperty)block.variantProperty)).materialRGB;
    };
    public static final IBlockColor FRAME_BLOCK_COLOR = (state, worldIn, pos, tintIndex) -> {
        SolidMaterial material = ((BlockFrame)state.func_177230_c()).frameMaterial;
        EnumDyeColor dyeColor = (EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a);
        return dyeColor == EnumDyeColor.WHITE ? material.materialRGB : dyeColor.field_193351_w;
    };
    public static final IItemColor FRAME_ITEM_COLOR = (stack, tintIndex) -> {
        IBlockState frameState = ((FrameItemBlock)stack.func_77973_b()).getBlockState(stack);
        BlockFrame block = (BlockFrame)frameState.func_177230_c();
        EnumDyeColor dyeColor = (EnumDyeColor)frameState.func_177229_b((IProperty)BlockColored.field_176581_a);
        return dyeColor == EnumDyeColor.WHITE ? block.frameMaterial.materialRGB : dyeColor.field_193351_w;
    };
    public static final IBlockColor ORE_BLOCK_COLOR = (state, worldIn, pos, tintIndex) -> tintIndex == 1 ? ((BlockOre)state.func_177230_c()).material.materialRGB : 0xFFFFFF;
    public static final IItemColor ORE_ITEM_COLOR = (stack, tintIndex) -> tintIndex == 1 ? ((BlockOre)((ItemBlock)stack.func_77973_b()).func_179223_d()).material.materialRGB : 0xFFFFFF;
    public static final IBlockColor FOAM_BLOCK_COLOR = (state, worldIn, pos, tintIndex) -> ((EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a)).field_193351_w;
    public static final IBlockColor SURFACE_ROCK_COLOR = (state, worldIn, pos, tintIndex) -> {
        if (tintIndex == 1) {
            if (state.func_177230_c() instanceof BlockSurfaceRock) {
                BlockSurfaceRock surfaceRock = (BlockSurfaceRock)state.func_177230_c();
                return ((Material)state.func_177229_b((IProperty)surfaceRock.materialProperty)).materialRGB;
            }
            if (state.func_177230_c() instanceof BlockSurfaceRockFlooded) {
                BlockSurfaceRockFlooded surfaceRock = (BlockSurfaceRockFlooded)state.func_177230_c();
                return ((Material)state.func_177229_b((IProperty)surfaceRock.materialProperty)).materialRGB;
            }
            return 0xFFFFFF;
        }
        return BiomeColorHelper.func_180288_c((IBlockAccess)worldIn, (BlockPos)pos);
    };
    private static final Set<UUID> capeHoldersUUIDs = new HashSet<UUID>();

    @Override
    public void onPreLoad() {
        super.onPreLoad();
        MetaTileEntityRenderer.preInit();
        CableRenderer.preInit();
        FluidPipeRenderer.preInit();
        StoneRenderer.preInit();
        MetaEntities.initRenderers();
        TextureUtils.addIconRegister(MetaFluids::registerSprites);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.registerColors();
    }

    @Override
    public void onPostLoad() {
        super.onPostLoad();
        MetaTileEntityRenderer.postInit();
        ClientProxy.startCapeLoadingThread();
    }

    public void registerColors() {
        MetaBlocks.registerColors();
        MetaItems.registerColors();
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        MetaBlocks.registerStateMappers();
        MetaBlocks.registerItemModels();
        MetaItems.registerModels();
    }

    @SubscribeEvent
    public static void addMaterialFormulaHandler(ItemTooltipEvent event) {
        String formula;
        UnificationEntry unificationEntry;
        ItemStack itemStack = event.getItemStack();
        if (!(itemStack.func_77973_b() instanceof ItemBlock || (unificationEntry = OreDictUnifier.getUnificationEntry(itemStack)) == null || unificationEntry.material == null || (formula = unificationEntry.material.chemicalFormula) == null || formula.isEmpty() || formula.equals("?"))) {
            event.getToolTip().add(1, ChatFormatting.GRAY.toString() + unificationEntry.material.chemicalFormula);
        }
    }

    private static void startCapeLoadingThread() {
        Thread capeListLoadThread = new Thread(ClientProxy::loadCapesList, "GregTech Cape List Downloader");
        capeListLoadThread.setDaemon(true);
        capeListLoadThread.start();
    }

    private static void loadCapesList() {
        capeHoldersUUIDs.add(UUID.fromString("4bdba267-1479-449a-8ae4-d1957dd39f29"));
        capeHoldersUUIDs.add(UUID.fromString("6cb05251-cd1b-481e-bf59-07637add1c64"));
        try {
            URL connectURL = new URL("https://www.dropbox.com/s/zc07k4y1h4ftmz3/GregTechPatreonList.txt?dl=1");
            HttpURLConnection connection = (HttpURLConnection)connectURL.openConnection(Minecraft.func_71410_x().func_110437_J());
            try {
                connection.setDoInput(true);
                connection.setDoOutput(false);
                connection.connect();
                InputStream inputStream = connection.getInputStream();
                capeHoldersUUIDs.addAll(ClientProxy.retrieveCapeUUIDs(inputStream));
            }
            finally {
                connection.disconnect();
            }
        }
        catch (MalformedURLException | SocketTimeoutException | UnknownHostException connectURL) {
        }
        catch (IOException exception) {
            GTLog.logger.warn("Failed to fetch cape list", (Throwable)exception);
        }
    }

    private static Set<UUID> retrieveCapeUUIDs(InputStream inputStream) throws IOException {
        String line;
        InputStreamReader streamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        BufferedReader reader = new BufferedReader(streamReader);
        HashSet<UUID> result = new HashSet<UUID>();
        while ((line = reader.readLine()) != null) {
            int firstCommentIndex = line.indexOf(35);
            if (firstCommentIndex > -1) {
                line = line.substring(0, firstCommentIndex);
            }
            try {
                UUID playerUUID = UUID.fromString(line.trim());
                result.add(playerUUID);
            }
            catch (IllegalArgumentException exception) {
                GTLog.logger.warn("Failed to parse cape player UUID {}", (Object)line.trim(), (Object)exception);
            }
        }
        return result;
    }

    @SubscribeEvent
    public static void onPlayerRender(RenderPlayerEvent.Pre event) {
        AbstractClientPlayer clientPlayer = (AbstractClientPlayer)event.getEntityPlayer();
        if (capeHoldersUUIDs.contains(clientPlayer.func_110124_au()) && clientPlayer.func_152122_n() && clientPlayer.func_110303_q() == null) {
            NetworkPlayerInfo playerInfo = (NetworkPlayerInfo)ObfuscationReflectionHelper.getPrivateValue(AbstractClientPlayer.class, (Object)clientPlayer, (int)0);
            Map playerTextures = (Map)ObfuscationReflectionHelper.getPrivateValue(NetworkPlayerInfo.class, (Object)playerInfo, (int)1);
            playerTextures.put(MinecraftProfileTexture.Type.CAPE, GREGTECH_CAPE_TEXTURE);
        }
    }
}

