/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.populator;

import com.google.gson.JsonObject;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.worldgen.config.OreConfigUtils;
import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.generator.GridEntryInfo;
import gregtech.api.worldgen.populator.VeinChunkPopulator;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.surfacerock.BlockSurfaceRockFlooded;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;

public class SurfaceRockPopulator
implements VeinChunkPopulator {
    private IngotMaterial material;

    public SurfaceRockPopulator() {
    }

    public SurfaceRockPopulator(IngotMaterial material) {
        this.material = material;
    }

    @Override
    public void loadFromConfig(JsonObject object) {
        DustMaterial material = OreConfigUtils.getMaterialByName(object.get("material").getAsString());
        if (!(material instanceof IngotMaterial)) {
            throw new IllegalArgumentException("Only metal materials are supported for surface rocks");
        }
        if (!material.hasFlag(DustMaterial.MatFlags.GENERATE_ORE)) {
            throw new IllegalArgumentException("Only materials with ore can have surface rocks");
        }
        this.material = (IngotMaterial)material;
    }

    @Override
    public void initializeForVein(OreDepositDefinition definition) {
    }

    @Override
    public void populateChunk(World world, int chunkX, int chunkZ, Random random, OreDepositDefinition definition, GridEntryInfo gridEntryInfo) {
        if (world.func_175624_G() != WorldType.field_77138_c) {
            int stonesCount = random.nextInt(2);
            for (int i = 0; i < stonesCount; ++i) {
                IBlockState stoneBlockState;
                Object blockSurfaceRock;
                boolean isFloodedBlock;
                int randomX = chunkX * 16 + random.nextInt(16);
                int randomZ = chunkZ * 16 + random.nextInt(16);
                BlockPos topBlockPos = new BlockPos(randomX, 0, randomZ);
                IBlockState blockState = world.func_180495_p(topBlockPos = world.func_175672_r(topBlockPos).func_177977_b());
                if (blockState.func_193401_d((IBlockAccess)world, topBlockPos, EnumFacing.UP) != BlockFaceShape.SOLID || !blockState.func_185914_p() || !blockState.func_185913_b()) continue;
                BlockPos surfaceRockPos = topBlockPos.func_177984_a();
                IBlockState blockStateReplaced = world.func_180495_p(surfaceRockPos);
                boolean bl = isFloodedBlock = blockStateReplaced.func_185904_a() == Material.field_151586_h;
                if (!isFloodedBlock) {
                    blockSurfaceRock = MetaBlocks.SURFACE_ROCKS.get(this.material);
                    stoneBlockState = blockSurfaceRock.func_176223_P().func_177226_a((IProperty)blockSurfaceRock.materialProperty, (Comparable)this.material);
                } else {
                    blockSurfaceRock = MetaBlocks.FLOODED_SURFACE_ROCKS.get(this.material);
                    stoneBlockState = blockSurfaceRock.func_176223_P().func_177226_a((IProperty)((BlockSurfaceRockFlooded)((Object)blockSurfaceRock)).materialProperty, (Comparable)this.material);
                }
                world.func_180501_a(surfaceRockPos, stoneBlockState, 16);
            }
        }
    }
}

