/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.config;

import com.google.gson.JsonObject;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IBiome;
import crafttweaker.api.world.IBlockAccess;
import crafttweaker.api.world.IBlockPos;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.ore.StoneType;
import gregtech.api.util.WorldBlockPredicate;
import gregtech.api.worldgen.config.OreConfigUtils;
import gregtech.api.worldgen.config.PredicateConfigUtils;
import gregtech.api.worldgen.config.WorldConfigUtils;
import gregtech.api.worldgen.config.WorldGenRegistry;
import gregtech.api.worldgen.filler.BlockFiller;
import gregtech.api.worldgen.populator.IVeinPopulator;
import gregtech.api.worldgen.populator.SurfaceRockPopulator;
import gregtech.api.worldgen.shape.ShapeGenerator;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Optional;
import org.apache.commons.lang3.ArrayUtils;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.ore.OreDepositDefinition")
@ZenRegister
public class OreDepositDefinition {
    public static final Function<Biome, Integer> NO_BIOME_INFLUENCE = biome -> 0;
    public static final Predicate<WorldProvider> PREDICATE_SURFACE_WORLD = WorldProvider::func_76569_d;
    public static final WorldBlockPredicate PREDICATE_STONE_TYPE = (state, world, pos) -> StoneType.computeStoneType(state, world, pos) != null;
    private final String depositName;
    private int weight;
    private int priority;
    private float density;
    private int[] heightLimit = new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE};
    private boolean countAsVein = true;
    private Function<Biome, Integer> biomeWeightModifier = NO_BIOME_INFLUENCE;
    private Predicate<WorldProvider> dimensionFilter = PREDICATE_SURFACE_WORLD;
    private WorldBlockPredicate generationPredicate = PREDICATE_STONE_TYPE;
    private IVeinPopulator veinPopulator;
    private BlockFiller blockFiller;
    private ShapeGenerator shapeGenerator;

    public OreDepositDefinition(String depositName) {
        this.depositName = depositName;
    }

    public void initializeFromConfig(JsonObject configRoot) {
        this.weight = configRoot.get("weight").getAsInt();
        this.density = configRoot.get("density").getAsFloat();
        if (configRoot.has("priority")) {
            this.priority = configRoot.get("priority").getAsInt();
        }
        if (configRoot.has("count_as_vein")) {
            this.countAsVein = configRoot.get("count_as_vein").getAsBoolean();
        }
        if (configRoot.has("min_height")) {
            this.heightLimit[0] = configRoot.get("min_height").getAsInt();
        }
        if (configRoot.has("max_height")) {
            this.heightLimit[1] = configRoot.get("max_height").getAsInt();
        }
        if (configRoot.has("biome_modifier")) {
            this.biomeWeightModifier = WorldConfigUtils.createBiomeWeightModifier(configRoot.get("biome_modifier"));
        }
        if (configRoot.has("dimension_filter")) {
            this.dimensionFilter = WorldConfigUtils.createWorldPredicate(configRoot.get("dimension_filter"));
        }
        if (configRoot.has("generation_predicate")) {
            this.generationPredicate = PredicateConfigUtils.createBlockStatePredicate(configRoot.get("generation_predicate"));
        }
        if (configRoot.has("surface_stone_material")) {
            IngotMaterial surfaceStoneMaterial = (IngotMaterial)OreConfigUtils.getMaterialByName(configRoot.get("surface_stone_material").getAsString());
            if (!surfaceStoneMaterial.hasFlag(DustMaterial.MatFlags.GENERATE_ORE)) {
                throw new IllegalArgumentException("Material " + surfaceStoneMaterial + " doesn't have surface rock variant");
            }
            this.veinPopulator = new SurfaceRockPopulator(surfaceStoneMaterial);
        }
        if (configRoot.has("vein_populator")) {
            JsonObject object = configRoot.get("vein_populator").getAsJsonObject();
            this.veinPopulator = WorldGenRegistry.INSTANCE.createVeinPopulator(object);
        }
        this.blockFiller = WorldGenRegistry.INSTANCE.createBlockFiller(configRoot.get("filler").getAsJsonObject());
        this.shapeGenerator = WorldGenRegistry.INSTANCE.createShapeGenerator(configRoot.get("generator").getAsJsonObject());
        if (this.veinPopulator != null) {
            this.veinPopulator.initializeForVein(this);
        }
    }

    @ZenGetter(value="depositName")
    public String getDepositName() {
        return this.depositName;
    }

    @ZenGetter(value="weight")
    public int getWeight() {
        return this.weight;
    }

    @ZenGetter(value="density")
    public float getDensity() {
        return this.density;
    }

    @ZenGetter(value="priority")
    public int getPriority() {
        return this.priority;
    }

    @ZenGetter(value="isVein")
    public boolean isVein() {
        return this.countAsVein;
    }

    @ZenMethod
    public boolean checkInHeightLimit(int yLevel) {
        return yLevel >= this.heightLimit[0] && yLevel <= this.heightLimit[1];
    }

    @ZenMethod
    public int[] getHeightLimit() {
        return this.heightLimit;
    }

    @ZenGetter(value="minimumHeight")
    public int getMinimumHeight() {
        return this.heightLimit[0];
    }

    @ZenGetter(value="maximumHeight")
    public int getMaximumHeight() {
        return this.heightLimit[1];
    }

    public Function<Biome, Integer> getBiomeWeightModifier() {
        return this.biomeWeightModifier;
    }

    public Predicate<WorldProvider> getDimensionFilter() {
        return this.dimensionFilter;
    }

    public WorldBlockPredicate getGenerationPredicate() {
        return this.generationPredicate;
    }

    public IVeinPopulator getVeinPopulator() {
        return this.veinPopulator;
    }

    @ZenMethod(value="getBiomeWeightModifier")
    @Optional.Method(modid="crafttweaker")
    public int ctGetBiomeWeightModifier(IBiome biome) {
        int biomeIndex = ArrayUtils.indexOf((Object[])CraftTweakerMC.biomes, (Object)biome);
        Biome mcBiome = (Biome)Biome.field_185377_q.func_148754_a(biomeIndex);
        return mcBiome == null ? 0 : this.getBiomeWeightModifier().apply(mcBiome);
    }

    @ZenMethod(value="checkDimension")
    @Optional.Method(modid="crafttweaker")
    public boolean ctCheckDimension(int dimensionId) {
        WorldProvider worldProvider = DimensionManager.getProvider((int)dimensionId);
        return worldProvider != null && this.getDimensionFilter().test(worldProvider);
    }

    @ZenMethod(value="canGenerateIn")
    @Optional.Method(modid="crafttweaker")
    public boolean ctCanGenerateIn(crafttweaker.api.block.IBlockState blockState, IBlockAccess blockAccess, IBlockPos blockPos) {
        IBlockState mcBlockState = CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)blockState);
        return this.getGenerationPredicate().test(mcBlockState, (net.minecraft.world.IBlockAccess)blockAccess.getInternal(), (BlockPos)blockPos.getInternal());
    }

    @ZenGetter(value="filter")
    public BlockFiller getBlockFiller() {
        return this.blockFiller;
    }

    @ZenGetter(value="shape")
    public ShapeGenerator getShapeGenerator() {
        return this.shapeGenerator;
    }
}

