/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.items.toolitem.ToolMetaItem;
import gregtech.api.util.ShapedOreEnergyTransferRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;

public class ShapedOreIngredientAwareRecipe
extends ShapedOreEnergyTransferRecipe {
    public ShapedOreIngredientAwareRecipe(ResourceLocation group, @Nonnull ItemStack result, Object ... recipe) {
        super(group, result, recipe);
    }

    public ShapedOreIngredientAwareRecipe(ResourceLocation group, @Nonnull ItemStack result, CraftingHelper.ShapedPrimer primer) {
        super(group, result, primer);
    }

    @Override
    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inventoryCrafting) {
        ItemStack resultStack = super.func_77572_b(inventoryCrafting);
        ShapedOreIngredientAwareRecipe.saveCraftingComponents(resultStack, (IInventory)inventoryCrafting);
        return resultStack;
    }

    public static void saveCraftingComponents(ItemStack toolStack, IInventory ingredients) {
        NBTTagList componentList = new NBTTagList();
        for (int slotIndex = 0; slotIndex < ingredients.func_70302_i_(); ++slotIndex) {
            ItemStack stackInSlot = ingredients.func_70301_a(slotIndex).func_77946_l();
            stackInSlot.func_190920_e(1);
            if (stackInSlot.func_190926_b() || stackInSlot.func_77973_b() instanceof ToolMetaItem || !stackInSlot.func_77973_b().getContainerItem(stackInSlot).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackInSlot.func_77955_b(stackTag);
            componentList.func_74742_a((NBTBase)stackTag);
        }
        toolStack.func_77983_a("CraftingComponents", (NBTBase)componentList);
    }

    public static List<ItemStack> getCraftingComponents(ItemStack toolStack) {
        NBTTagCompound tagCompound = toolStack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_150297_b("CraftingComponents", 9)) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        NBTTagList componentList = tagCompound.func_150295_c("CraftingComponents", 10);
        for (int index = 0; index < componentList.func_74745_c(); ++index) {
            NBTTagCompound stackTag = componentList.func_150305_b(index);
            stacks.add(new ItemStack(stackTag));
        }
        return stacks;
    }
}

