/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ShapedOreEnergyTransferRecipe
extends ShapedOreRecipe {
    public ShapedOreEnergyTransferRecipe(ResourceLocation group, @Nonnull ItemStack result, Object ... recipe) {
        super(group, result, recipe);
    }

    public ShapedOreEnergyTransferRecipe(ResourceLocation group, @Nonnull ItemStack result, CraftingHelper.ShapedPrimer primer) {
        super(group, result, primer);
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inventoryCrafting) {
        ItemStack resultStack = super.func_77572_b(inventoryCrafting);
        ShapedOreEnergyTransferRecipe.chargeStackFromComponents(resultStack, (IInventory)inventoryCrafting);
        return resultStack;
    }

    public static void chargeStackFromComponents(ItemStack toolStack, IInventory ingredients) {
        IElectricItem electricItem = (IElectricItem)toolStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem != null && electricItem.getMaxCharge() > 0L) {
            long maxCharge = electricItem.charge(Long.MAX_VALUE, Integer.MAX_VALUE, true, true);
            for (int slotIndex = 0; slotIndex < ingredients.func_70302_i_(); ++slotIndex) {
                ItemStack stackInSlot = ingredients.func_70301_a(slotIndex);
                IElectricItem batteryItem = (IElectricItem)stackInSlot.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
                if (batteryItem == null || !batteryItem.canProvideChargeExternally() || maxCharge <= 0L) continue;
                long discharged = batteryItem.discharge(maxCharge, Integer.MAX_VALUE, true, true, false);
                maxCharge -= electricItem.charge(discharged, Integer.MAX_VALUE, true, false);
                if (discharged > 0L) {
                    ingredients.func_70299_a(slotIndex, stackInSlot);
                }
                if (maxCharge == 0L) break;
            }
        }
    }
}

