/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.stack;

import gregtech.api.unification.stack.SimpleItemStack;
import java.util.HashMap;
import java.util.Map;

public class WildcardAwareHashMap<V>
extends HashMap<SimpleItemStack, V> {
    public WildcardAwareHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public WildcardAwareHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public WildcardAwareHashMap() {
    }

    public WildcardAwareHashMap(Map<? extends SimpleItemStack, ? extends V> m) {
        super(m);
    }

    @Override
    public V get(Object key) {
        SimpleItemStack itemStack = (SimpleItemStack)key;
        Object resultValue = super.get(key);
        if (resultValue == null && itemStack.itemDamage != Short.MAX_VALUE) {
            SimpleItemStack wildcardStack = new SimpleItemStack(itemStack.item, Short.MAX_VALUE, itemStack.stackSize);
            resultValue = super.get(wildcardStack);
        }
        return resultValue;
    }

    @Override
    public boolean containsKey(Object key) {
        SimpleItemStack itemStack = (SimpleItemStack)key;
        boolean resultValue = super.containsKey(key);
        if (!resultValue && itemStack.itemDamage != Short.MAX_VALUE) {
            SimpleItemStack wildcardStack = new SimpleItemStack(itemStack.item, Short.MAX_VALUE, itemStack.stackSize);
            resultValue = super.containsKey(wildcardStack);
        }
        return resultValue;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V value = this.get(key);
        return value == null ? defaultValue : value;
    }
}

