/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.type;

import com.google.common.collect.ImmutableList;
import crafttweaker.annotations.ZenRegister;
import gregtech.api.unification.Element;
import gregtech.api.unification.material.MaterialIconSet;
import gregtech.api.unification.material.type.FluidMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="mods.gregtech.material.DustMaterial")
@ZenRegister
public class DustMaterial
extends FluidMaterial {
    @ZenProperty
    public final List<FluidMaterial> oreByProducts = new ArrayList<FluidMaterial>();
    @ZenProperty
    public int oreMultiplier = 1;
    @ZenProperty
    public int byProductMultiplier = 1;
    @ZenProperty
    public int smeltingMultiplier = 1;
    @ZenProperty
    public final int harvestLevel;
    @ZenProperty
    public SolidMaterial directSmelting;
    @ZenProperty
    public FluidMaterial washedIn;
    @ZenProperty
    public DustMaterial separatedOnto;
    @ZenProperty
    public int burnTime = 0;

    public DustMaterial(int metaItemSubId, String name, int materialRGB, MaterialIconSet materialIconSet, int harvestLevel, ImmutableList<MaterialStack> materialComponents, long materialGenerationFlags, Element element) {
        super(metaItemSubId, name, materialRGB, materialIconSet, materialComponents, materialGenerationFlags, element);
        this.harvestLevel = harvestLevel;
    }

    public DustMaterial(int metaItemSubId, String name, int materialRGB, MaterialIconSet materialIconSet, int harvestLevel, ImmutableList<MaterialStack> materialComponents, long materialGenerationFlags) {
        super(metaItemSubId, name, materialRGB, materialIconSet, materialComponents, materialGenerationFlags, null);
        this.harvestLevel = harvestLevel;
    }

    @Override
    protected void initializeMaterial() {
        super.initializeMaterial();
        if (this.shouldGenerateFluid()) {
            this.setFluidTemperature(1200);
        }
    }

    @Override
    public boolean shouldGenerateFluid() {
        return this.hasFlag(MatFlags.SMELT_INTO_FLUID);
    }

    public void addOreByProducts(FluidMaterial ... byProducts) {
        this.oreByProducts.addAll(Arrays.asList(byProducts));
    }

    public void setDirectSmelting(IngotMaterial directSmelting) {
        this.directSmelting = directSmelting;
    }

    public void setDirectSmelting(SolidMaterial directSmelting) {
        this.directSmelting = directSmelting;
    }

    public void setOreMultiplier(int oreMultiplier) {
        this.oreMultiplier = oreMultiplier;
    }

    public void setSmeltingMultiplier(int smeltingMultiplier) {
        this.smeltingMultiplier = smeltingMultiplier;
    }

    public void setByProductMultiplier(int byProductMultiplier) {
        this.byProductMultiplier = byProductMultiplier;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public static final class MatFlags {
        public static final long GENERATE_ORE = GTUtility.createFlag(11);
        public static final long GENERATE_PLATE = GTUtility.createFlag(12);
        public static final long NO_WORKING = GTUtility.createFlag(13);
        public static final long NO_SMASHING = GTUtility.createFlag(14);
        public static final long NO_SMELTING = GTUtility.createFlag(15);
        public static final long INDUCTION_SMELTING_LOW_OUTPUT = GTUtility.createFlag(16);
        public static final long SMELT_INTO_FLUID = GTUtility.createFlag(17);
        public static final long EXCLUDE_BLOCK_CRAFTING_RECIPES = GTUtility.createFlag(18);
        public static final long EXCLUDE_PLATE_COMPRESSOR_RECIPE = GTUtility.createFlag(19);

        static {
            Material.MatFlags.registerMaterialFlagsHolder(MatFlags.class, DustMaterial.class);
        }
    }
}

