/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.render;

import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.block.machines.MachineItemBlock;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.Textures;
import gregtech.api.util.GTLog;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class MetaTileEntityRenderer
implements ICCBlockRenderer,
IItemRenderer {
    public static ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation(new ResourceLocation("gregtech", "machine"), "normal");
    public static MetaTileEntityRenderer INSTANCE = new MetaTileEntityRenderer();
    public static EnumBlockRenderType BLOCK_RENDER_TYPE;
    public static Map<ItemCameraTransforms.TransformType, TRSRTransformation> BLOCK_TRANSFORMS;

    public static void preInit() {
        BLOCK_RENDER_TYPE = BlockRenderingRegistry.createRenderType((String)"meta_tile_entity");
        BlockRenderingRegistry.registerRenderer((EnumBlockRenderType)BLOCK_RENDER_TYPE, (ICCBlockRenderer)INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        TextureUtils.addIconRegister(Textures::register);
    }

    public static void postInit() {
        try (IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("models/block/block.json"));){
            InputStreamReader reader = new InputStreamReader(resource.func_110527_b());
            ModelBlock modelBlock = ModelBlock.func_178307_a((Reader)reader);
            for (ItemCameraTransforms.TransformType transformType : ItemCameraTransforms.TransformType.values()) {
                ItemTransformVec3f vec3f = modelBlock.func_181682_g().func_181688_b(transformType);
                BLOCK_TRANSFORMS.put(transformType, new TRSRTransformation(vec3f));
            }
        }
        catch (IOException exception) {
            GTLog.logger.error("Failed to load default block transforms", (Throwable)exception);
        }
    }

    @SubscribeEvent
    public void onModelsBake(ModelBakeEvent event) {
        GTLog.logger.info("Injected MetaTileEntity render model");
        event.getModelRegistry().func_82595_a((Object)MODEL_LOCATION, (Object)this);
    }

    public void renderItem(ItemStack stack, ItemCameraTransforms.TransformType transformType) {
        MetaTileEntity metaTileEntity = MachineItemBlock.getMetaTileEntity(stack);
        if (metaTileEntity == null) {
            return;
        }
        GlStateManager.func_179147_l();
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.startDrawing(7, DefaultVertexFormats.field_176599_b);
        metaTileEntity.setRenderContextStack(stack);
        metaTileEntity.renderMetaTileEntity(renderState, new Matrix4(), new IVertexOperation[0]);
        if (metaTileEntity.requiresDynamicRendering()) {
            metaTileEntity.renderMetaTileEntityDynamic(renderState, new Matrix4(), new IVertexOperation[0], 0.0f);
        }
        metaTileEntity.setRenderContextStack(null);
        renderState.draw();
        GlStateManager.func_179084_k();
    }

    public boolean renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, BufferBuilder buffer) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity(world, pos);
        if (metaTileEntity == null) {
            return false;
        }
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        renderState.lightMatrix.locate(world, pos);
        IVertexOperation[] pipeline = new IVertexOperation[]{renderState.lightMatrix};
        Matrix4 translation = new Matrix4().translate((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        metaTileEntity.renderMetaTileEntity(renderState, translation.copy(), pipeline);
        metaTileEntity.renderCovers(renderState, translation, new IVertexOperation[0]);
        return true;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        if (BLOCK_TRANSFORMS.containsKey(cameraTransformType)) {
            return Pair.of((Object)this, (Object)BLOCK_TRANSFORMS.get(cameraTransformType).getMatrix());
        }
        return Pair.of((Object)this, null);
    }

    public IModelState getTransforms() {
        return TRSRTransformation.identity();
    }

    public boolean func_188618_c() {
        return true;
    }

    public void renderBrightness(IBlockState state, float brightness) {
    }

    public void handleRenderBlockDamage(IBlockAccess world, BlockPos pos, IBlockState state, TextureAtlasSprite sprite, BufferBuilder buffer) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity(world, pos);
        ArrayList<IndexedCuboid6> boundingBox = new ArrayList<IndexedCuboid6>();
        if (metaTileEntity != null) {
            metaTileEntity.addCollisionBoundingBox(boundingBox);
            metaTileEntity.addCoverCollisionBoundingBox(boundingBox, false);
        }
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        renderState.setPipeline(new IVertexOperation[]{new Vector3(new Vec3d((Vec3i)pos)).translation(), new IconTransformation(sprite)});
        for (Cuboid6 cuboid6 : boundingBox) {
            BlockRenderer.renderCuboid((CCRenderState)renderState, (Cuboid6)cuboid6, (int)0);
        }
    }

    public TextureAtlasSprite getParticleTexture(IBlockAccess world, BlockPos pos) {
        MetaTileEntity metaTileEntity = BlockMachine.getMetaTileEntity(world, pos);
        if (metaTileEntity == null) {
            return TextureUtils.getMissingSprite();
        }
        return metaTileEntity.getParticleTexture();
    }

    public TextureAtlasSprite func_177554_e() {
        return TextureUtils.getMissingSprite();
    }

    public void registerTextures(TextureMap map) {
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    static {
        BLOCK_TRANSFORMS = new HashMap<ItemCameraTransforms.TransformType, TRSRTransformation>();
    }
}

