/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.machines;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.util.GTUtility;
import gregtech.common.items.PotionFluids;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapBrewer
extends RecipeMap<SimpleRecipeBuilder> {
    private static final int POTION_PER_INGREDIENT = 432;

    public RecipeMapBrewer(String unlocalizedName, int minInputs, int maxInputs, int minOutputs, int maxOutputs, int minFluidInputs, int maxFluidInputs, int minFluidOutputs, int maxFluidOutputs, int amperage, SimpleRecipeBuilder defaultRecipe) {
        super(unlocalizedName, minInputs, maxInputs, minOutputs, maxOutputs, minFluidInputs, maxFluidInputs, minFluidOutputs, maxFluidOutputs, amperage, defaultRecipe);
    }

    @Override
    public boolean canInputFluidForce(Fluid fluid) {
        return PotionFluids.getPotionForFluid(fluid) != null;
    }

    @Override
    @Nullable
    public Recipe findRecipe(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs) {
        Recipe recipe = super.findRecipe(voltage, inputs, fluidInputs);
        if (recipe != null || GTUtility.amountOfNonNullElements(fluidInputs) < 1 || GTUtility.amountOfNonEmptyStacks(inputs) < 1) {
            return recipe;
        }
        ItemStack ingredientStack = inputs.get(0);
        FluidStack potionFluid = fluidInputs.get(0);
        PotionType potionType = PotionFluids.getPotionForFluid(potionFluid.getFluid());
        if (potionType == null || potionFluid.amount < 432) {
            return null;
        }
        ItemStack potionStack = new ItemStack((Item)Items.field_151068_bn);
        PotionUtils.func_185188_a((ItemStack)potionStack, (PotionType)potionType);
        ItemStack resultStack = BrewingRecipeRegistry.getOutput((ItemStack)potionStack, (ItemStack)ingredientStack);
        if (resultStack.func_190926_b() || resultStack.func_77973_b() != Items.field_151068_bn) {
            return null;
        }
        PotionType resultingType = PotionUtils.func_185191_c((ItemStack)resultStack);
        if (resultingType == null || resultingType == PotionTypes.field_185229_a) {
            return null;
        }
        Fluid outputFluid = PotionFluids.getFluidForPotion(resultingType);
        return ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)this.recipeBuilder()).inputs(ingredientStack)).fluidInputs(GTUtility.copyAmount(432, potionFluid))).fluidOutputs(new FluidStack(outputFluid, 432))).cannotBeBuffered()).build().getResult();
    }
}

