/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import com.google.common.base.Preconditions;
import gregtech.api.items.ToolDictNames;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipes.DummyRecipe;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.DummyContainer;
import gregtech.api.util.GTLog;
import gregtech.api.util.ShapedOreEnergyTransferRecipe;
import gregtech.api.util.ShapedOreIngredientAwareRecipe;
import gregtech.api.util.world.DummyWorld;
import gregtech.common.MetaFluids;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ModHandler {
    public static boolean isWater(FluidStack fluid) {
        return new FluidStack(FluidRegistry.WATER, 1).isFluidEqual(fluid) || new FluidStack(MetaFluids.DISTILLED_WATER, 1).isFluidEqual(fluid);
    }

    public static FluidStack getWater(int amount) {
        return new FluidStack(FluidRegistry.WATER, amount);
    }

    public static FluidStack getDistilledWater(int amount) {
        return new FluidStack(MetaFluids.DISTILLED_WATER, amount);
    }

    public static boolean isLava(FluidStack fluid) {
        return new FluidStack(FluidRegistry.LAVA, 0).isFluidEqual(fluid);
    }

    public static FluidStack getLava(int amount) {
        return new FluidStack(FluidRegistry.LAVA, amount);
    }

    public static boolean isSteam(FluidStack fluid) {
        return ModHandler.getSteam(1).isFluidEqual(fluid);
    }

    public static FluidStack getSteam(int amount) {
        return Materials.Steam.getFluid(amount);
    }

    public static boolean isMilk(Fluid fluid) {
        return ModHandler.getMilk(1).getFluid() == fluid;
    }

    public static FluidStack getMilk(int amount) {
        return FluidRegistry.getFluidStack((String)"milk", (int)amount);
    }

    public static boolean isMaterialWood(Material material) {
        return material == Materials.Wood;
    }

    public static ItemStack getModItem(String modID, String itemName, int amount) {
        return ModHandler.getModItem(modID, itemName, amount, 0);
    }

    public static ItemStack getModItem(String modID, String itemName, int amount, int meta) {
        return GameRegistry.makeItemStack((String)(modID + ":" + itemName), (int)meta, (int)amount, null);
    }

    public static ItemStack getBurningFuelRemainder(Random random, ItemStack fuelStack) {
        float remainderChance;
        ItemStack remainder;
        if (OreDictUnifier.getOreDictionaryNames(fuelStack).contains("fuelCoke")) {
            remainder = OreDictUnifier.get(OrePrefix.dust, Materials.Ash);
            remainderChance = 0.5f;
        } else {
            MaterialStack materialStack = OreDictUnifier.getMaterial(fuelStack);
            if (materialStack == null) {
                return ItemStack.field_190927_a;
            }
            if (materialStack.material == Materials.Charcoal) {
                remainder = OreDictUnifier.get(OrePrefix.dust, Materials.Ash);
                remainderChance = 0.3f;
            } else if (materialStack.material == Materials.Coal) {
                remainder = OreDictUnifier.get(OrePrefix.dust, Materials.DarkAsh);
                remainderChance = 0.35f;
            } else if (materialStack.material == Materials.Lignite) {
                remainder = OreDictUnifier.get(OrePrefix.dust, Materials.DarkAsh);
                remainderChance = 0.35f;
            } else if (materialStack.material == Materials.Coke) {
                remainder = OreDictUnifier.get(OrePrefix.dust, Materials.Ash);
                remainderChance = 0.5f;
            } else {
                return ItemStack.field_190927_a;
            }
        }
        return random.nextFloat() <= remainderChance ? remainder : ItemStack.field_190927_a;
    }

    public static void addSmeltingRecipe(UnificationEntry input, ItemStack output) {
        List<ItemStack> allStacks = OreDictUnifier.getAll(input);
        for (ItemStack inputStack : allStacks) {
            ModHandler.addSmeltingRecipe(inputStack, output);
        }
    }

    public static void addSmeltingRecipe(ItemStack input, ItemStack output) {
        boolean skip = false;
        if (input.func_190926_b()) {
            GTLog.logger.error("Input cannot be an empty ItemStack", (Throwable)new IllegalArgumentException());
            skip = true;
            RecipeMap.setFoundInvalidRecipe(true);
        }
        if (output.func_190926_b()) {
            GTLog.logger.error("Output cannot be an empty ItemStack", (Throwable)new IllegalArgumentException());
            skip = true;
            RecipeMap.setFoundInvalidRecipe(true);
        }
        if (skip) {
            return;
        }
        FurnaceRecipes recipes = FurnaceRecipes.func_77602_a();
        if (recipes.func_151395_a(input).func_190926_b()) {
            recipes.func_151394_a(input, output, 0.0f);
        }
    }

    public static void addMirroredShapedRecipe(String regName, ItemStack result, Object ... recipe) {
        result = OreDictUnifier.getUnificated(result);
        boolean skip = false;
        if (result.func_190926_b()) {
            GTLog.logger.error("Result cannot be an empty ItemStack. Recipe: {}", (Object)regName);
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            skip = true;
        }
        if (skip |= ModHandler.validateRecipe(regName, recipe)) {
            RecipeMap.setFoundInvalidRecipe(true);
            return;
        }
        IRecipe shapedOreRecipe = (IRecipe)new ShapedOreRecipe(new ResourceLocation("gregtech", "general"), result.func_77946_l(), ModHandler.finalizeShapedRecipeInput(recipe)).setMirrored(true).setRegistryName(regName);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)shapedOreRecipe);
    }

    public static void addShapedRecipe(String regName, ItemStack result, Object ... recipe) {
        boolean skip = false;
        if (result.func_190926_b()) {
            GTLog.logger.error("Result cannot be an empty ItemStack. Recipe: {}", (Object)regName);
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            skip = true;
        }
        if (skip |= ModHandler.validateRecipe(regName, recipe)) {
            RecipeMap.setFoundInvalidRecipe(true);
            return;
        }
        IRecipe shapedOreRecipe = (IRecipe)new ShapedOreRecipe(null, result.func_77946_l(), ModHandler.finalizeShapedRecipeInput(recipe)).setMirrored(false).setRegistryName(regName);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)shapedOreRecipe);
    }

    public static void addShapedEnergyTransferRecipe(String regName, ItemStack result, Object ... recipe) {
        boolean skip = false;
        if (result.func_190926_b()) {
            GTLog.logger.error("Result cannot be an empty ItemStack. Recipe: {}", (Object)regName);
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            skip = true;
        }
        if (skip |= ModHandler.validateRecipe(regName, recipe)) {
            RecipeMap.setFoundInvalidRecipe(true);
            return;
        }
        IRecipe shapedOreRecipe = (IRecipe)new ShapedOreEnergyTransferRecipe(null, result.func_77946_l(), ModHandler.finalizeShapedRecipeInput(recipe)).setMirrored(false).setRegistryName(regName);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)shapedOreRecipe);
    }

    public static void addShapedIngredientAwareRecipe(String regName, ItemStack result, Object ... recipe) {
        boolean skip = false;
        if (result.func_190926_b()) {
            GTLog.logger.error("Result cannot be an empty ItemStack. Recipe: {}", (Object)regName);
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            skip = true;
        }
        if (skip |= ModHandler.validateRecipe(regName, recipe)) {
            RecipeMap.setFoundInvalidRecipe(true);
            return;
        }
        IRecipe shapedOreRecipe = (IRecipe)new ShapedOreIngredientAwareRecipe(null, result.func_77946_l(), ModHandler.finalizeShapedRecipeInput(recipe)).setMirrored(false).setRegistryName(regName);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)shapedOreRecipe);
    }

    private static boolean validateRecipe(String regName, Object ... recipe) {
        boolean skip = false;
        if (recipe == null) {
            GTLog.logger.error("Recipe cannot be null", (Throwable)new IllegalArgumentException());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            skip = true;
        } else if (recipe.length == 0) {
            GTLog.logger.error("Recipe cannot be empty", (Throwable)new IllegalArgumentException());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            skip = true;
        } else if (Arrays.asList(recipe).contains(null) || Arrays.asList(recipe).contains(ItemStack.field_190927_a)) {
            GTLog.logger.error("Recipe cannot contain null elements or Empty ItemStacks. Recipe: {}", (Object)Arrays.stream(recipe).map(o -> o == null ? "NULL" : o).map(o -> o == ItemStack.field_190927_a ? "EMPTY STACK" : o).map(Object::toString).map(s -> "\"" + s + "\"").collect(Collectors.joining(", ")));
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            skip = true;
        } else if (ForgeRegistries.RECIPES.containsKey(new ResourceLocation("gregtech", regName))) {
            GTLog.logger.error("Tried to register recipe, {}, with duplicate key. Recipe: {}", (Object)regName, (Object)Arrays.stream(recipe).map(Object::toString).map(s -> "\"" + s + "\"").collect(Collectors.joining(", ")));
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
        }
        return skip;
    }

    public static Object[] finalizeShapedRecipeInput(Object ... recipe) {
        for (int i = 0; i < recipe.length; i = (int)((byte)(i + 1))) {
            if (recipe[i] instanceof MetaItem.MetaValueItem) {
                recipe[i] = ((MetaItem.MetaValueItem)recipe[i]).getStackForm();
                continue;
            }
            if (recipe[i] instanceof Enum) {
                recipe[i] = ((Enum)recipe[i]).name();
                continue;
            }
            if (recipe[i] instanceof UnificationEntry) {
                recipe[i] = recipe[i].toString();
                continue;
            }
            if (recipe[i] instanceof ItemStack || recipe[i] instanceof Item || recipe[i] instanceof Block || recipe[i] instanceof String || recipe[i] instanceof Character || recipe[i] instanceof Boolean) continue;
            throw new IllegalArgumentException(recipe.getClass().getSimpleName() + " type is not suitable for crafting input.");
        }
        int idx = 0;
        ArrayList<Object> recipeList = new ArrayList<Object>(Arrays.asList(recipe));
        while (recipe[idx] instanceof String) {
            StringBuilder s = new StringBuilder((String)recipe[idx++]);
            while (s.length() < 3) {
                s.append(" ");
            }
            if (s.length() > 3) {
                throw new IllegalArgumentException();
            }
            for (char c : s.toString().toCharArray()) {
                String toolName = ModHandler.getToolNameByCharacter(c);
                if (toolName == null) continue;
                recipeList.add(Character.valueOf(c));
                recipeList.add(toolName);
            }
        }
        return recipeList.toArray();
    }

    public static void addShapelessRecipe(String regName, ItemStack result, Object ... recipe) {
        boolean skip = false;
        if (result.func_190926_b()) {
            GTLog.logger.error("Result cannot be an empty ItemStack. Recipe: {}", (Object)regName);
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            skip = true;
        }
        if (skip |= ModHandler.validateRecipe(regName, recipe)) {
            RecipeMap.setFoundInvalidRecipe(true);
            return;
        }
        for (int i = 0; i < recipe.length; i = (int)((byte)(i + 1))) {
            if (recipe[i] instanceof MetaItem.MetaValueItem) {
                recipe[i] = ((MetaItem.MetaValueItem)recipe[i]).getStackForm();
                continue;
            }
            if (recipe[i] instanceof Enum) {
                recipe[i] = ((Enum)recipe[i]).name();
                continue;
            }
            if (recipe[i] instanceof UnificationEntry) {
                recipe[i] = recipe[i].toString();
                continue;
            }
            if (recipe[i] instanceof Character) {
                String toolName = ModHandler.getToolNameByCharacter(((Character)recipe[i]).charValue());
                if (toolName == null) {
                    throw new IllegalArgumentException("Tool name is not found for char " + recipe[i]);
                }
                recipe[i] = toolName;
                continue;
            }
            if (recipe[i] instanceof ItemStack || recipe[i] instanceof Item || recipe[i] instanceof Block || recipe[i] instanceof String) continue;
            throw new IllegalArgumentException(recipe.getClass().getSimpleName() + " type is not suitable for crafting input.");
        }
        IRecipe shapelessRecipe = (IRecipe)new ShapelessOreRecipe(null, result.func_77946_l(), recipe).setRegistryName(regName);
        try {
            Field field = ShapelessOreRecipe.class.getDeclaredField("isSimple");
            field.setAccessible(true);
            field.setBoolean(shapelessRecipe, false);
        }
        catch (ReflectiveOperationException exception) {
            GTLog.logger.error("Failed to mark shapeless recipe as complex", (Throwable)exception);
        }
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)shapelessRecipe);
    }

    @Nullable
    private static String getToolNameByCharacter(char character) {
        switch (character) {
            case 'b': {
                return ToolDictNames.craftingToolBlade.name();
            }
            case 'c': {
                return ToolDictNames.craftingToolCrowbar.name();
            }
            case 'd': {
                return ToolDictNames.craftingToolScrewdriver.name();
            }
            case 'f': {
                return ToolDictNames.craftingToolFile.name();
            }
            case 'h': {
                return ToolDictNames.craftingToolHardHammer.name();
            }
            case 'i': {
                return ToolDictNames.craftingToolSolderingIron.name();
            }
            case 'j': {
                return ToolDictNames.craftingToolSolderingMetal.name();
            }
            case 'k': {
                return ToolDictNames.craftingToolKnife.name();
            }
            case 'm': {
                return ToolDictNames.craftingToolMortar.name();
            }
            case 'p': {
                return ToolDictNames.craftingToolDrawplate.name();
            }
            case 'r': {
                return ToolDictNames.craftingToolSoftHammer.name();
            }
            case 's': {
                return ToolDictNames.craftingToolSaw.name();
            }
            case 'w': {
                return ToolDictNames.craftingToolWrench.name();
            }
            case 'x': {
                return ToolDictNames.craftingToolWireCutter.name();
            }
        }
        return null;
    }

    public static Collection<ItemStack> getAllSubItems(ItemStack item) {
        CreativeTabs[] visibleTags;
        if (item.func_77952_i() != Short.MAX_VALUE) {
            return Collections.singleton(item);
        }
        NonNullList stackList = NonNullList.func_191196_a();
        for (CreativeTabs creativeTab : visibleTags = item.func_77973_b().getCreativeTabs()) {
            NonNullList thisList = NonNullList.func_191196_a();
            item.func_77973_b().func_150895_a(creativeTab, thisList);
            block1: for (ItemStack newStack : thisList) {
                for (ItemStack alreadyExists : stackList) {
                    if (!ItemStack.func_77989_b((ItemStack)alreadyExists, (ItemStack)newStack)) continue;
                    continue block1;
                }
                stackList.add((Object)newStack);
            }
        }
        return stackList;
    }

    public static boolean removeFurnaceSmelting(UnificationEntry input) {
        boolean result = false;
        List<ItemStack> allStacks = OreDictUnifier.getAll(input);
        for (ItemStack inputStack : allStacks) {
            result |= ModHandler.removeFurnaceSmelting(inputStack);
        }
        return result;
    }

    public static boolean removeFurnaceSmelting(ItemStack input) {
        if (input.func_190926_b()) {
            GTLog.logger.error("Cannot remove furnace recipe with empty input.");
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            RecipeMap.setFoundInvalidRecipe(true);
            return false;
        }
        for (ItemStack stack : FurnaceRecipes.func_77602_a().func_77599_b().keySet()) {
            if (!ItemStack.func_77989_b((ItemStack)input, (ItemStack)stack)) continue;
            FurnaceRecipes.func_77602_a().func_77599_b().remove(stack);
            return true;
        }
        return false;
    }

    public static int removeRecipes(Item output) {
        return ModHandler.removeRecipes((IRecipe recipe) -> {
            ItemStack recipeOutput = recipe.func_77571_b();
            return !recipeOutput.func_190926_b() && recipeOutput.func_77973_b() == output;
        });
    }

    public static int removeRecipes(ItemStack output) {
        return ModHandler.removeRecipes((IRecipe recipe) -> ItemStack.func_77989_b((ItemStack)recipe.func_77571_b(), (ItemStack)output));
    }

    public static <R extends IRecipe> int removeRecipes(Class<R> recipeClass) {
        return ModHandler.removeRecipes(recipeClass::isInstance);
    }

    public static int removeRecipes(Predicate<IRecipe> predicate) {
        int recipesRemoved = 0;
        IForgeRegistry registry = ForgeRegistries.RECIPES;
        ArrayList<IRecipe> toRemove = new ArrayList<IRecipe>();
        for (IRecipe recipe2 : registry) {
            if (!predicate.test(recipe2)) continue;
            toRemove.add(recipe2);
            ++recipesRemoved;
        }
        toRemove.forEach(recipe -> registry.register(new DummyRecipe().setRegistryName(recipe.getRegistryName())));
        return recipesRemoved;
    }

    public static void removeRecipeByName(ResourceLocation location) {
        ForgeRegistries.RECIPES.register(new DummyRecipe().setRegistryName(location));
    }

    public static Pair<IRecipe, ItemStack> getRecipeOutput(World world, ItemStack ... recipe) {
        if (recipe == null || recipe.length == 0) {
            return ImmutablePair.of(null, (Object)ItemStack.field_190927_a);
        }
        if (world == null) {
            world = DummyWorld.INSTANCE;
        }
        InventoryCrafting craftingGrid = new InventoryCrafting((Container)new DummyContainer(), 3, 3);
        for (int i = 0; i < 9 && i < recipe.length; ++i) {
            ItemStack recipeStack = recipe[i];
            if (recipeStack == null || recipeStack.func_190926_b()) continue;
            craftingGrid.func_70299_a(i, recipeStack);
        }
        for (IRecipe tmpRecipe : CraftingManager.field_193380_a) {
            if (!tmpRecipe.func_77569_a(craftingGrid, world)) continue;
            ItemStack itemStack = tmpRecipe.func_77572_b(craftingGrid);
            return ImmutablePair.of((Object)tmpRecipe, (Object)itemStack);
        }
        return ImmutablePair.of(null, (Object)ItemStack.field_190927_a);
    }

    public static ItemStack getSmeltingOutput(ItemStack input) {
        if (input.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return OreDictUnifier.getUnificated(FurnaceRecipes.func_77602_a().func_151395_a(input));
    }

    public static void addRCFurnaceRecipe(UnificationEntry input, ItemStack output, int duration) {
        List<ItemStack> allStacks = OreDictUnifier.getAll(input);
        for (ItemStack inputStack : allStacks) {
            ModHandler.addRCFurnaceRecipe(inputStack, output, duration);
        }
    }

    public static void addRCFurnaceRecipe(ItemStack input, ItemStack output, int duration) {
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkNotNull((Object)output);
        Preconditions.checkArgument((duration > 0 ? 1 : 0) != 0, (Object)"Duration should be positive!");
    }
}

