/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.tile;

import codechicken.lib.raytracer.IndexedCuboid6;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.ICoverable;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.tile.IPipeTile;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class PipeCoverableImplementation
implements ICoverable {
    private final IPipeTile<?, ?> holder;
    private final CoverBehavior[] coverBehaviors = new CoverBehavior[6];

    public PipeCoverableImplementation(IPipeTile<?, ?> holder) {
        this.holder = holder;
    }

    public void transferDataTo(PipeCoverableImplementation destImpl) {
        for (EnumFacing coverSide : EnumFacing.field_82609_l) {
            CoverBehavior behavior = this.coverBehaviors[coverSide.func_176745_a()];
            if (behavior == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            behavior.writeToNBT(tagCompound);
            CoverBehavior newBehavior = behavior.getCoverDefinition().createCoverBehavior(destImpl, coverSide);
            newBehavior.readFromNBT(tagCompound);
            destImpl.coverBehaviors[coverSide.func_176745_a()] = newBehavior;
        }
    }

    @Override
    public final boolean placeCoverOnSide(EnumFacing side, ItemStack itemStack, CoverDefinition coverDefinition) {
        Preconditions.checkNotNull((Object)side, (Object)"side");
        Preconditions.checkNotNull((Object)((Object)coverDefinition), (Object)"coverDefinition");
        CoverBehavior coverBehavior = coverDefinition.createCoverBehavior(this, side);
        if (!this.canPlaceCoverOnSide(side) || !coverBehavior.canAttach()) {
            return false;
        }
        boolean requiresTicking = coverBehavior instanceof ITickable;
        if (requiresTicking && !this.holder.supportsTicking()) {
            IPipeTile<?, ?> newHolderTile = this.holder.setSupportsTicking();
            return newHolderTile.getCoverableImplementation().placeCoverOnSide(side, itemStack, coverDefinition);
        }
        if (this.coverBehaviors[side.func_176745_a()] != null) {
            this.removeCover(side);
        }
        this.coverBehaviors[side.func_176745_a()] = coverBehavior;
        coverBehavior.onAttached(itemStack);
        this.writeCustomData(1, buffer -> {
            buffer.writeByte(side.func_176745_a());
            buffer.func_150787_b(CoverDefinition.getNetworkIdForCover(coverDefinition));
            coverBehavior.writeInitialSyncData((PacketBuffer)buffer);
        });
        this.holder.notifyBlockUpdate();
        this.holder.markAsDirty();
        return true;
    }

    @Override
    public final boolean removeCover(EnumFacing side) {
        Preconditions.checkNotNull((Object)side, (Object)"side");
        CoverBehavior coverBehavior = this.getCoverAtSide(side);
        if (coverBehavior == null) {
            return false;
        }
        List<ItemStack> drops = coverBehavior.getDrops();
        coverBehavior.onRemoved();
        this.coverBehaviors[side.func_176745_a()] = null;
        for (ItemStack dropStack : drops) {
            Block.func_180635_a((World)this.getWorld(), (BlockPos)this.getPos(), (ItemStack)dropStack);
        }
        this.writeCustomData(2, buffer -> buffer.writeByte(side.func_176745_a()));
        this.holder.notifyBlockUpdate();
        this.holder.markAsDirty();
        return true;
    }

    public final void dropAllCovers() {
        for (EnumFacing coverSide : EnumFacing.field_82609_l) {
            CoverBehavior coverBehavior = this.coverBehaviors[coverSide.func_176745_a()];
            if (coverBehavior == null) continue;
            List<ItemStack> drops = coverBehavior.getDrops();
            for (ItemStack dropStack : drops) {
                Block.func_180635_a((World)this.getWorld(), (BlockPos)this.getPos(), (ItemStack)dropStack);
            }
        }
    }

    @Override
    public double getCoverPlateThickness() {
        return 0.0625;
    }

    @Override
    public int getPaintingColor() {
        return this.holder.getInsulationColor() == 0x777777 ? 0xFFFFFF : this.holder.getInsulationColor();
    }

    @Override
    public boolean shouldRenderBackSide() {
        return false;
    }

    @Override
    public CoverBehavior getCoverAtSide(EnumFacing side) {
        return this.coverBehaviors[side.func_176745_a()];
    }

    @Override
    public boolean canPlaceCoverOnSide(EnumFacing side) {
        ArrayList pipeBox = Lists.newArrayList((Object[])new IndexedCuboid6[]{new IndexedCuboid6(null, BlockPipe.getSideBox(null, ((IPipeType)this.holder.getPipeType()).getThickness()))});
        if (!ICoverable.checkCoverCollision(side, pipeBox, this.getCoverPlateThickness())) {
            return false;
        }
        return this.holder.canPlaceCoverOnSide(side);
    }

    public void update() {
        if (!this.getWorld().field_72995_K) {
            for (CoverBehavior coverBehavior : this.coverBehaviors) {
                if (!(coverBehavior instanceof ITickable)) continue;
                ((ITickable)coverBehavior).func_73660_a();
            }
        }
    }

    @Override
    public void writeCoverData(CoverBehavior behavior, int id, Consumer<PacketBuffer> writer) {
        this.writeCustomData(0, buffer -> {
            buffer.writeByte(behavior.attachedSide.func_176745_a());
            buffer.func_150787_b(id);
            writer.accept((PacketBuffer)buffer);
        });
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        for (EnumFacing coverSide : EnumFacing.field_82609_l) {
            CoverBehavior coverBehavior = this.getCoverAtSide(coverSide);
            if (coverBehavior != null) {
                int coverId = CoverDefinition.getNetworkIdForCover(coverBehavior.getCoverDefinition());
                buf.func_150787_b(coverId);
                coverBehavior.writeInitialSyncData(buf);
                continue;
            }
            buf.func_150787_b(-1);
        }
    }

    public void readInitialSyncData(PacketBuffer buf) {
        for (EnumFacing coverSide : EnumFacing.field_82609_l) {
            int coverId = buf.func_150792_a();
            if (coverId == -1) continue;
            CoverDefinition coverDefinition = CoverDefinition.getCoverByNetworkId(coverId);
            CoverBehavior coverBehavior = coverDefinition.createCoverBehavior(this, coverSide);
            coverBehavior.readInitialSyncData(buf);
            this.coverBehaviors[coverSide.func_176745_a()] = coverBehavior;
        }
    }

    public void writeCustomData(int dataId, Consumer<PacketBuffer> writer) {
        this.holder.writeCoverCustomData(dataId, writer);
    }

    public void readCustomData(int dataId, PacketBuffer buf) {
        if (dataId == 1) {
            CoverBehavior coverBehavior;
            EnumFacing placementSide = EnumFacing.field_82609_l[buf.readByte()];
            int coverId = buf.func_150792_a();
            CoverDefinition coverDefinition = CoverDefinition.getCoverByNetworkId(coverId);
            this.coverBehaviors[placementSide.func_176745_a()] = coverBehavior = coverDefinition.createCoverBehavior(this, placementSide);
            coverBehavior.readInitialSyncData(buf);
            this.holder.scheduleChunkForRenderUpdate();
        } else if (dataId == 2) {
            EnumFacing placementSide = EnumFacing.field_82609_l[buf.readByte()];
            this.coverBehaviors[placementSide.func_176745_a()] = null;
            this.holder.scheduleChunkForRenderUpdate();
        } else if (dataId == 0) {
            EnumFacing coverSide = EnumFacing.field_82609_l[buf.readByte()];
            CoverBehavior coverBehavior = this.getCoverAtSide(coverSide);
            int internalId = buf.func_150792_a();
            if (coverBehavior != null) {
                coverBehavior.readUpdateData(internalId, buf);
            }
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        NBTTagList coversList = new NBTTagList();
        for (EnumFacing coverSide : EnumFacing.field_82609_l) {
            CoverBehavior coverBehavior = this.coverBehaviors[coverSide.func_176745_a()];
            if (coverBehavior == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            ResourceLocation coverId = coverBehavior.getCoverDefinition().getCoverId();
            tagCompound.func_74778_a("CoverId", coverId.toString());
            tagCompound.func_74774_a("Side", (byte)coverSide.func_176745_a());
            coverBehavior.writeToNBT(tagCompound);
            coversList.func_74742_a((NBTBase)tagCompound);
        }
        data.func_74782_a("Covers", (NBTBase)coversList);
    }

    public void readFromNBT(NBTTagCompound data) {
        NBTTagList coversList = data.func_150295_c("Covers", 10);
        for (int index = 0; index < coversList.func_74745_c(); ++index) {
            NBTTagCompound tagCompound = coversList.func_150305_b(index);
            if (!tagCompound.func_150297_b("CoverId", 8)) continue;
            EnumFacing coverSide = EnumFacing.field_82609_l[tagCompound.func_74771_c("Side")];
            ResourceLocation coverId = new ResourceLocation(tagCompound.func_74779_i("CoverId"));
            CoverDefinition coverDefinition = CoverDefinition.getCoverById(coverId);
            CoverBehavior coverBehavior = coverDefinition.createCoverBehavior(this, coverSide);
            coverBehavior.readFromNBT(tagCompound);
            this.coverBehaviors[coverSide.func_176745_a()] = coverBehavior;
        }
    }

    @Override
    public World getWorld() {
        return this.holder.getPipeWorld();
    }

    @Override
    public BlockPos getPos() {
        return this.holder.getPipePos();
    }

    @Override
    public long getTimer() {
        return this.holder.getTickTimer();
    }

    @Override
    public void markDirty() {
        this.holder.markAsDirty();
    }

    @Override
    public boolean isValid() {
        return !this.holder.isValidTile();
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        return this.holder.getCapabilityInternal(capability, side);
    }
}

