/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet;

import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gregtech.api.pipenet.Node;
import gregtech.api.pipenet.WorldPipeNet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class PipeNet<NodeDataType>
implements INBTSerializable<NBTTagCompound> {
    protected final WorldPipeNet<NodeDataType, PipeNet<NodeDataType>> worldData;
    protected Map<BlockPos, Node<NodeDataType>> allNodes = new HashMap<BlockPos, Node<NodeDataType>>();
    private long lastUpdate;
    protected boolean isValid;

    public PipeNet(WorldPipeNet<NodeDataType, ? extends PipeNet> world) {
        this.worldData = world;
    }

    public Map<BlockPos, Node<NodeDataType>> getAllNodes() {
        return Collections.unmodifiableMap(this.allNodes);
    }

    public World getWorldData() {
        return this.worldData.getWorld();
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void onConnectionsUpdate() {
        this.lastUpdate = System.currentTimeMillis();
    }

    public boolean containsNode(BlockPos blockPos) {
        return this.allNodes.containsKey(blockPos);
    }

    protected void addNode(BlockPos nodePos, Node<NodeDataType> node) {
        this.allNodes.put(nodePos, node);
        this.worldData.func_76185_a();
        this.onConnectionsUpdate();
    }

    protected void removeNode(BlockPos nodePos) {
        if (this.allNodes.containsKey(nodePos)) {
            Node<NodeDataType> selfNode = this.allNodes.remove(nodePos);
            this.removeNodeInternal(nodePos, selfNode);
            this.worldData.func_76185_a();
        }
    }

    protected void updateBlockedConnections(BlockPos nodePos, EnumFacing facing, boolean isBlocked) {
        Node<NodeDataType> neighbourNode;
        boolean wasBlocked;
        if (!this.allNodes.containsKey(nodePos)) {
            return;
        }
        Node<NodeDataType> selfNode = this.allNodes.get(nodePos);
        boolean bl = wasBlocked = (selfNode.blockedConnections & 1 << facing.func_176745_a()) > 0;
        if (wasBlocked == isBlocked) {
            return;
        }
        this.setBlocked(selfNode, facing, isBlocked);
        BlockPos offsetPos = nodePos.func_177972_a(facing);
        PipeNet<NodeDataType> pipeNetAtOffset = this.worldData.getNetFromPos(offsetPos);
        if (pipeNetAtOffset == null) {
            return;
        }
        if (pipeNetAtOffset == this) {
            if (isBlocked && this.canNodesConnect(selfNode, facing, this.allNodes.get(offsetPos), this)) {
                this.setBlocked(selfNode, facing, true);
                HashMap<BlockPos, Node<NodeDataType>> thisENet = this.findAllConnectedBlocks(nodePos);
                if (!this.allNodes.equals(thisENet)) {
                    PipeNet<NodeDataType> newPipeNet = this.worldData.createNetInstance();
                    newPipeNet.transferNodeData(thisENet, this);
                    this.allNodes.keySet().removeAll(thisENet.keySet());
                    this.worldData.addPipeNet(newPipeNet);
                }
            }
        } else if (!isBlocked && this.canNodesConnect(selfNode, facing, neighbourNode = pipeNetAtOffset.allNodes.get(offsetPos), pipeNetAtOffset) && pipeNetAtOffset.canNodesConnect(neighbourNode, facing.func_176734_d(), selfNode, this)) {
            this.uniteNetworks(pipeNetAtOffset);
        }
        this.onConnectionsUpdate();
        this.worldData.func_76185_a();
    }

    protected void updateMark(BlockPos nodePos, int newMark) {
        if (!this.allNodes.containsKey(nodePos)) {
            return;
        }
        HashMap<BlockPos, Node<NodeDataType>> selfConnectedBlocks = null;
        Node<NodeDataType> selfNode = this.allNodes.get(nodePos);
        int oldMark = selfNode.mark;
        selfNode.mark = newMark;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            HashMap<BlockPos, Node<NodeDataType>> offsetConnectedBlocks;
            Node<NodeDataType> secondNode;
            BlockPos offsetPos = nodePos.func_177972_a(facing);
            PipeNet<NodeDataType> otherPipeNet = this.worldData.getNetFromPos(offsetPos);
            Node<NodeDataType> node = secondNode = otherPipeNet == null ? null : otherPipeNet.allNodes.get(offsetPos);
            if (secondNode == null || !this.areNodeBlockedConnectionsCompatible(selfNode, facing, secondNode) || !this.areNodesCustomContactable(selfNode.data, secondNode.data, otherPipeNet) || this.areMarksCompatible(oldMark, secondNode.mark) == this.areMarksCompatible(newMark, secondNode.mark)) continue;
            if (this.areMarksCompatible(newMark, secondNode.mark)) {
                if (otherPipeNet == this) continue;
                this.uniteNetworks(otherPipeNet);
                continue;
            }
            if (otherPipeNet != this) continue;
            if (selfConnectedBlocks == null) {
                selfConnectedBlocks = this.findAllConnectedBlocks(nodePos);
            }
            if (this.allNodes.equals(selfConnectedBlocks) || (offsetConnectedBlocks = this.findAllConnectedBlocks(offsetPos)).equals(selfConnectedBlocks)) continue;
            this.allNodes.keySet().removeAll(offsetConnectedBlocks.keySet());
            PipeNet<NodeDataType> offsetPipeNet = this.worldData.createNetInstance();
            offsetPipeNet.transferNodeData(offsetConnectedBlocks, this);
            this.worldData.addPipeNet(offsetPipeNet);
        }
        this.onConnectionsUpdate();
        this.worldData.func_76185_a();
    }

    private void setBlocked(Node<NodeDataType> selfNode, EnumFacing facing, boolean isBlocked) {
        selfNode.blockedConnections = isBlocked ? (selfNode.blockedConnections |= 1 << facing.func_176745_a()) : (selfNode.blockedConnections &= ~(1 << facing.func_176745_a()));
    }

    public boolean markNodeAsActive(BlockPos nodePos, boolean isActive) {
        if (this.allNodes.containsKey(nodePos) && this.allNodes.get((Object)nodePos).isActive != isActive) {
            this.allNodes.get((Object)nodePos).isActive = isActive;
            this.worldData.func_76185_a();
            this.onConnectionsUpdate();
            return true;
        }
        return false;
    }

    protected final void uniteNetworks(PipeNet<NodeDataType> energyNet) {
        this.worldData.removePipeNet(energyNet);
        HashMap<BlockPos, Node<NodeDataType>> allNodes = new HashMap<BlockPos, Node<NodeDataType>>(energyNet.allNodes);
        energyNet.allNodes.clear();
        this.transferNodeData(allNodes, energyNet);
    }

    private boolean areNodeBlockedConnectionsCompatible(Node<NodeDataType> first, EnumFacing firstFacing, Node<NodeDataType> second) {
        return (first.blockedConnections & 1 << firstFacing.func_176745_a()) == 0 && (second.blockedConnections & 1 << firstFacing.func_176734_d().func_176745_a()) == 0;
    }

    private boolean areMarksCompatible(int mark1, int mark2) {
        return mark1 == mark2 || mark1 == 0 || mark2 == 0;
    }

    protected final boolean canNodesConnect(Node<NodeDataType> first, EnumFacing firstFacing, Node<NodeDataType> second, PipeNet<NodeDataType> secondPipeNet) {
        return this.areNodeBlockedConnectionsCompatible(first, firstFacing, second) && this.areMarksCompatible(first.mark, second.mark) && this.areNodesCustomContactable(first.data, second.data, secondPipeNet);
    }

    protected HashMap<BlockPos, Node<NodeDataType>> findAllConnectedBlocks(BlockPos startPos) {
        HashMap<BlockPos, Node<NodeDataType>> observedSet = new HashMap<BlockPos, Node<NodeDataType>>();
        observedSet.put(startPos, this.allNodes.get(startPos));
        Node<NodeDataType> firstNode = this.allNodes.get(startPos);
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(startPos);
        Stack<EnumFacing> moveStack = new Stack<EnumFacing>();
        while (true) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                currentPos.func_189536_c(facing);
                Node<NodeDataType> secondNode = this.allNodes.get(currentPos);
                if (secondNode != null && this.canNodesConnect(firstNode, facing, secondNode, this) && !observedSet.containsKey(currentPos)) {
                    observedSet.put(currentPos.func_185334_h(), this.allNodes.get(currentPos));
                    firstNode = secondNode;
                    moveStack.push(facing.func_176734_d());
                    continue;
                }
                currentPos.func_189536_c(facing.func_176734_d());
            }
            if (moveStack.isEmpty()) break;
            currentPos.func_189536_c((EnumFacing)moveStack.pop());
            firstNode = this.allNodes.get(currentPos);
        }
        return observedSet;
    }

    protected void removeNodeInternal(BlockPos nodePos, Node<NodeDataType> selfNode) {
        BlockPos offsetPos;
        int amountOfConnectedSides = 0;
        for (EnumFacing facing : EnumFacing.values()) {
            offsetPos = nodePos.func_177972_a(facing);
            if (!this.allNodes.containsKey(offsetPos)) continue;
            ++amountOfConnectedSides;
        }
        if (amountOfConnectedSides >= 2) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                offsetPos = nodePos.func_177972_a(facing);
                Node<NodeDataType> secondNode = this.allNodes.get(offsetPos);
                if (secondNode == null || !this.canNodesConnect(selfNode, facing, secondNode, this)) continue;
                HashMap<BlockPos, Node<NodeDataType>> thisENet = this.findAllConnectedBlocks(offsetPos);
                if (this.allNodes.equals(thisENet)) break;
                PipeNet<NodeDataType> energyNet = this.worldData.createNetInstance();
                this.allNodes.keySet().removeAll(thisENet.keySet());
                energyNet.transferNodeData(thisENet, this);
                this.worldData.addPipeNet(energyNet);
            }
        }
        if (this.allNodes.isEmpty()) {
            this.worldData.removePipeNet(this);
        }
        this.onConnectionsUpdate();
        this.worldData.func_76185_a();
    }

    protected boolean areNodesCustomContactable(NodeDataType first, NodeDataType second, PipeNet<NodeDataType> secondNodePipeNet) {
        return true;
    }

    protected boolean canAttachNode(NodeDataType nodeData) {
        return true;
    }

    protected void transferNodeData(Map<BlockPos, Node<NodeDataType>> transferredNodes, PipeNet<NodeDataType> parentNet) {
        this.allNodes.putAll(transferredNodes);
        this.onConnectionsUpdate();
        this.worldData.func_76185_a();
    }

    protected abstract void writeNodeData(NodeDataType var1, NBTTagCompound var2);

    protected abstract NodeDataType readNodeData(NBTTagCompound var1);

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("Nodes", (NBTBase)this.serializeAllNodeList(this.allNodes));
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.allNodes = this.deserializeAllNodeList(nbt.func_74775_l("Nodes"));
    }

    protected Map<BlockPos, Node<NodeDataType>> deserializeAllNodeList(NBTTagCompound compound) {
        int i;
        NBTTagList allNodesList = compound.func_150295_c("NodeIndexes", 10);
        NBTTagList wirePropertiesList = compound.func_150295_c("WireProperties", 10);
        TIntObjectHashMap readProperties = new TIntObjectHashMap();
        HashMap<BlockPos, Node<NodeDataType>> allNodes = new HashMap<BlockPos, Node<NodeDataType>>();
        for (i = 0; i < wirePropertiesList.func_74745_c(); ++i) {
            NBTTagCompound propertiesTag = wirePropertiesList.func_150305_b(i);
            int wirePropertiesIndex = propertiesTag.func_74762_e("index");
            NodeDataType nodeData = this.readNodeData(propertiesTag);
            readProperties.put(wirePropertiesIndex, nodeData);
        }
        for (i = 0; i < allNodesList.func_74745_c(); ++i) {
            NBTTagCompound nodeTag = allNodesList.func_150305_b(i);
            int x = nodeTag.func_74762_e("x");
            int y = nodeTag.func_74762_e("y");
            int z = nodeTag.func_74762_e("z");
            int wirePropertiesIndex = nodeTag.func_74762_e("index");
            BlockPos blockPos = new BlockPos(x, y, z);
            Object nodeData = readProperties.get(wirePropertiesIndex);
            int blockedConnections = nodeTag.func_74762_e("blocked");
            int mark = nodeTag.func_74762_e("mark");
            boolean isNodeActive = nodeTag.func_74767_n("active");
            allNodes.put(blockPos, new Node<Object>(nodeData, blockedConnections, mark, isNodeActive));
        }
        return allNodes;
    }

    protected NBTTagCompound serializeAllNodeList(Map<BlockPos, Node<NodeDataType>> allNodes) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList allNodesList = new NBTTagList();
        NBTTagList wirePropertiesList = new NBTTagList();
        TObjectIntHashMap alreadyWritten = new TObjectIntHashMap(10, 0.5f, -1);
        int currentIndex = 0;
        for (Map.Entry<BlockPos, Node<NodeDataType>> entry : allNodes.entrySet()) {
            BlockPos nodePos = entry.getKey();
            Node<NodeDataType> node = entry.getValue();
            NBTTagCompound nodeTag = new NBTTagCompound();
            nodeTag.func_74768_a("x", nodePos.func_177958_n());
            nodeTag.func_74768_a("y", nodePos.func_177956_o());
            nodeTag.func_74768_a("z", nodePos.func_177952_p());
            int wirePropertiesIndex = alreadyWritten.get(node.data);
            if (wirePropertiesIndex == -1) {
                wirePropertiesIndex = currentIndex++;
                alreadyWritten.put(node.data, wirePropertiesIndex);
            }
            nodeTag.func_74768_a("index", wirePropertiesIndex);
            if (node.mark != 0) {
                nodeTag.func_74768_a("mark", node.mark);
            }
            if (node.blockedConnections > 0) {
                nodeTag.func_74768_a("blocked", node.blockedConnections);
            }
            if (node.isActive) {
                nodeTag.func_74757_a("active", true);
            }
            allNodesList.func_74742_a((NBTBase)nodeTag);
        }
        for (Map.Entry<Object, Node<Object>> nodeData : alreadyWritten.keySet()) {
            int wirePropertiesIndex = alreadyWritten.get(nodeData);
            NBTTagCompound propertiesTag = new NBTTagCompound();
            propertiesTag.func_74768_a("index", wirePropertiesIndex);
            this.writeNodeData(nodeData, propertiesTag);
            wirePropertiesList.func_74742_a((NBTBase)propertiesTag);
        }
        compound.func_74782_a("NodeIndexes", (NBTBase)allNodesList);
        compound.func_74782_a("WireProperties", (NBTBase)wirePropertiesList);
        return compound;
    }
}

