/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.SimpleSidedCubeRenderer;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public abstract class TieredMetaTileEntity
extends MetaTileEntity
implements EnergyContainerHandler.IEnergyChangeListener,
ITieredMetaTileEntity {
    private final int tier;
    protected IEnergyContainer energyContainer;

    public TieredMetaTileEntity(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId);
        this.tier = tier;
        this.reinitializeEnergyContainer();
    }

    protected void reinitializeEnergyContainer() {
        long tierVoltage = GTValues.V[this.tier];
        this.energyContainer = this.isEnergyEmitter() ? EnergyContainerHandler.emitterContainer(this, tierVoltage * 32L, tierVoltage, this.getMaxInputOutputAmperage()) : EnergyContainerHandler.receiverContainer(this, tierVoltage * 32L, tierVoltage, this.getMaxInputOutputAmperage());
        this.updateComparatorValue(true);
    }

    @Override
    public int getComparatorValue() {
        long energyStored = this.energyContainer.getEnergyStored();
        long energyCapacity = this.energyContainer.getEnergyCapacity();
        float f = energyCapacity == 0L ? 0.0f : (float)energyStored / ((float)energyCapacity * 1.0f);
        return MathHelper.func_76141_d((float)(f * 14.0f)) + (energyStored > 0L ? 1 : 0);
    }

    @Override
    public void onEnergyChanged(IEnergyContainer container, boolean isInitialChange) {
        if (!isInitialChange) {
            this.updateComparatorValue(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private SimpleSidedCubeRenderer getBaseRenderer() {
        return Textures.VOLTAGE_CASINGS[this.tier];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture() {
        return this.getBaseRenderer().getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.TOP);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        IVertexOperation[] colouredPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        this.getBaseRenderer().render(renderState, translation, colouredPipeline);
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    protected long getMaxInputOutputAmperage() {
        return 1L;
    }

    protected boolean isEnergyEmitter() {
        return false;
    }
}

