/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.toolitem;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.enchants.EnchantmentData;
import gregtech.api.items.IDamagableItem;
import gregtech.api.items.ToolDictNames;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemContainerItemProvider;
import gregtech.api.items.metaitem.stats.IMetaItemStats;
import gregtech.api.items.toolitem.IToolStats;
import gregtech.api.unification.material.MaterialIconSet;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.unification.stack.SimpleItemStack;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ShapedOreIngredientAwareRecipe;
import gregtech.common.ConfigHolder;
import gregtech.common.items.MetaItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.Validate;

public class ToolMetaItem<T extends MetaToolValueItem>
extends MetaItem<T>
implements IDamagableItem {
    public ToolMetaItem() {
        super((short)0);
    }

    @Override
    protected T constructMetaValueItem(short metaValue, String unlocalizedName) {
        return (T)new MetaToolValueItem(metaValue, unlocalizedName);
    }

    @Override
    protected String formatModelPath(T metaValueItem) {
        String name = ((MetaToolValueItem)metaValueItem).unlocalizedName;
        return "tools/" + (name.indexOf(46) == -1 ? name : name.substring(name.indexOf(".") + 1));
    }

    @Override
    protected short formatRawItemDamage(short metaValue) {
        return (short)(metaValue % 16000);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected int getColorForItemStack(ItemStack stack, int tintIndex) {
        MetaToolValueItem item = (MetaToolValueItem)this.getItem(stack);
        if (item == null) {
            return 0xFFFFFF;
        }
        if (item.getColorProvider() != null) {
            return item.getColorProvider().getItemStackColor(stack, tintIndex);
        }
        IToolStats toolStats = item.getToolStats();
        return toolStats.getColor(stack, tintIndex);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        MetaToolValueItem item = (MetaToolValueItem)this.getItem(stack);
        if (item != null && item.getDurabilityManager() != null) {
            return item.getDurabilityManager().showsDurabilityBar(stack);
        }
        return stack.hasCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null) || this.getInternalDamage(stack) != 0;
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        MetaToolValueItem item = (MetaToolValueItem)this.getItem(stack);
        if (item != null && item.getDurabilityManager() != null) {
            return item.getDurabilityManager().getDurabilityForDisplay(stack);
        }
        if (stack.hasCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)) {
            IElectricItem electricItem = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            return 1.0 - (double)electricItem.getCharge() / ((double)electricItem.getMaxCharge() * 1.0);
        }
        return (double)this.getInternalDamage(stack) / ((double)this.getMaxInternalDamage(stack) * 1.0);
    }

    @Override
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        double internalDamage = (double)this.getInternalDamage(stack) / ((double)this.getMaxInternalDamage(stack) * 1.0);
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - internalDamage)) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaToolValueItem != null) {
            IToolStats toolStats = metaToolValueItem.getToolStats();
            toolStats.onToolCrafted(stack, playerIn);
        }
    }

    public static List<ItemStack> getToolComponents(ItemStack toolStack) {
        return ShapedOreIngredientAwareRecipe.getCraftingComponents(toolStack);
    }

    @Override
    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getContainerItem(ItemStack stack) {
        stack = stack.func_77946_l();
        stack.func_190920_e(1);
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaToolValueItem != null) {
            IToolStats toolStats;
            int toolDamagePerCraft;
            boolean canApplyDamage;
            IItemContainerItemProvider containerItemProvider = metaToolValueItem.getContainerItemProvider();
            if (containerItemProvider != null) {
                return containerItemProvider.getContainerItem(stack);
            }
            if (metaToolValueItem.toolStats != null && !(canApplyDamage = this.doDamageToItem(stack, toolDamagePerCraft = (toolStats = metaToolValueItem.toolStats).getToolDamagePerContainerCraft(stack), false))) {
                return stack;
            }
        }
        return stack;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity) {
        IToolStats toolStats;
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaToolValueItem != null && (toolStats = metaToolValueItem.getToolStats()).isMinableBlock(state, stack)) {
            this.doDamageToItem(stack, toolStats.getToolDamagePerBlockBreak(stack), false);
            ResourceLocation mineSound = toolStats.getUseSound(stack);
            if (mineSound != null) {
                SoundEvent soundEvent = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)mineSound);
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundEvent, SoundCategory.PLAYERS, 0.27f, 1.0f, false);
            }
        }
        return true;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        IToolStats toolStats;
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaToolValueItem != null && this.isUsable(stack, (toolStats = metaToolValueItem.getToolStats()).getToolDamagePerBlockBreak(stack)) && toolStats.isMinableBlock(state, stack)) {
            return this.getToolDigSpeed(stack);
        }
        return 1.0f;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaToolValueItem != null) {
            IToolStats toolStats = metaToolValueItem.getToolStats();
            return this.isUsable(stack, toolStats.getToolDamagePerBlockBreak(stack)) && toolStats.isMinableBlock(state, stack);
        }
        return false;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, EntityPlayer player, IBlockState blockState) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaToolValueItem == null) {
            return -1;
        }
        IToolStats toolStats = metaToolValueItem.getToolStats();
        if (this.isUsable(stack, toolStats.getToolDamagePerBlockBreak(stack)) && toolStats.isMinableBlock(blockState, stack)) {
            return this.getHarvestLevel(stack);
        }
        return -1;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        MetaToolValueItem metaValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaValueItem != null && slot == EntityEquipmentSlot.MAINHAND) {
            IToolStats toolStats = metaValueItem.getToolStats();
            if (toolStats == null) {
                return HashMultimap.create();
            }
            float attackDamage = this.getToolAttackDamage(stack);
            float attackSpeed = toolStats.getAttackSpeed(stack);
            HashMultimap modifiers = HashMultimap.create();
            modifiers.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)attackDamage, 0));
            modifiers.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)attackSpeed, 0));
            return modifiers;
        }
        return HashMultimap.create();
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        int damagePerAttack;
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaToolValueItem != null && !this.isUsable(stack, damagePerAttack = metaToolValueItem.getToolStats().getToolDamagePerEntityAttack(stack))) {
            return true;
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        MetaToolValueItem metaValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaValueItem != null) {
            IToolStats toolStats = metaValueItem.getToolStats();
            if (!this.doDamageToItem(stack, toolStats.getToolDamagePerEntityAttack(stack), false)) {
                return true;
            }
            ResourceLocation hitSound = toolStats.getUseSound(stack);
            if (hitSound != null) {
                SoundEvent soundEvent = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)hitSound);
                target.func_130014_f_().func_184134_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, soundEvent, SoundCategory.PLAYERS, 0.27f, 1.0f, false);
            }
            float additionalDamage = toolStats.getNormalDamageBonus(target, stack, attacker);
            float additionalMagicDamage = toolStats.getMagicDamageBonus(target, stack, attacker);
            if (additionalDamage > 0.0f) {
                target.func_70097_a((DamageSource)new EntityDamageSource(attacker instanceof EntityPlayer ? "player" : "mob", (Entity)attacker), additionalDamage);
            }
            if (additionalMagicDamage > 0.0f) {
                target.func_70097_a((DamageSource)new EntityDamageSource("indirectMagic", (Entity)attacker), additionalMagicDamage);
            }
        }
        return true;
    }

    @Override
    public boolean doDamageToItem(ItemStack stack, int vanillaDamage, boolean simulate) {
        IElectricItem capability = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (capability == null) {
            int resultDamage = ToolMetaItem.calculateToolDamage(stack, new Random(), vanillaDamage);
            int newDamageValue = this.getInternalDamage(stack) + resultDamage * 10;
            if (!simulate && !this.setInternalDamage(stack, newDamageValue)) {
                stack.func_190918_g(1);
            }
            return true;
        }
        int energyAmount = ConfigHolder.energyUsageMultiplier * vanillaDamage;
        if (capability.discharge(energyAmount, capability.getTier(), true, false, true) < (long)energyAmount) {
            return false;
        }
        capability.discharge(energyAmount, capability.getTier(), true, false, simulate);
        int newDamageValue = this.getInternalDamage(stack) + vanillaDamage;
        if (!simulate && !this.setInternalDamage(stack, newDamageValue)) {
            GTUtility.setItem(stack, MetaItems.TOOL_PARTS_BOX.getStackForm());
            stack.func_190919_e("GT.ToolStats");
        }
        return true;
    }

    public int regainItemDurability(ItemStack itemStack, int maxDurabilityRegain) {
        int toolDamage = this.getInternalDamage(itemStack);
        int durabilityRegained = Math.min(toolDamage, maxDurabilityRegain);
        this.setInternalDamage(itemStack, toolDamage - durabilityRegained);
        return durabilityRegained;
    }

    private static int calculateToolDamage(ItemStack itemStack, Random random, int amount) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)itemStack);
        int damageNegated = 0;
        for (int k = 0; level > 0 && k < amount; ++k) {
            if (!EnchantmentDurability.func_92097_a((ItemStack)itemStack, (int)level, (Random)random)) continue;
            ++damageNegated;
        }
        return Math.max(0, amount - damageNegated);
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        ICapabilityProvider capabilityProvider = super.initCapabilities(stack, nbt);
        if (capabilityProvider != null && capabilityProvider.hasCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)) {
            IElectricItem electricItem = (IElectricItem)capabilityProvider.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            electricItem.addChargeListener((itemStack, newCharge) -> {
                int newDamage = (newCharge == 0L ? 16000 : 0) + itemStack.func_77952_i() % 16000;
                if (newDamage != itemStack.func_77952_i()) {
                    itemStack.func_77964_b(newDamage);
                }
            });
        }
        return capabilityProvider;
    }

    public boolean isUsable(ItemStack stack, int damage) {
        IElectricItem capability = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        return capability == null || capability.canUse(damage);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        if (stack.func_77952_i() >= this.metaItemOffset) {
            MetaToolValueItem item = (MetaToolValueItem)this.getItem(stack);
            SolidMaterial primaryMaterial = ToolMetaItem.getToolMaterial(stack);
            String materialName = primaryMaterial == null ? "" : String.valueOf(primaryMaterial.getLocalizedName());
            return I18n.func_135052_a((String)("metaitem." + item.unlocalizedName + ".name"), (Object[])new Object[]{materialName});
        }
        return super.func_77653_i(stack);
    }

    @Override
    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<String> lines, ITooltipFlag tooltipFlag) {
        MetaToolValueItem item = (MetaToolValueItem)this.getItem(itemStack);
        if (item == null) {
            return;
        }
        IToolStats toolStats = item.getToolStats();
        SolidMaterial primaryMaterial = ToolMetaItem.getToolMaterial(itemStack);
        int maxInternalDamage = this.getMaxInternalDamage(itemStack);
        if (maxInternalDamage > 0) {
            lines.add(I18n.func_135052_a((String)"metaitem.tool.tooltip.durability", (Object[])new Object[]{maxInternalDamage - this.getInternalDamage(itemStack), maxInternalDamage}));
        }
        lines.add(I18n.func_135052_a((String)"metaitem.tool.tooltip.primary_material", (Object[])new Object[]{primaryMaterial.getLocalizedName(), this.getHarvestLevel(itemStack)}));
        lines.add(I18n.func_135052_a((String)"metaitem.tool.tooltip.attack_damage", (Object[])new Object[]{Float.valueOf(toolStats.getBaseDamage(itemStack) + (float)primaryMaterial.harvestLevel)}));
        lines.add(I18n.func_135052_a((String)"metaitem.tool.tooltip.mining_speed", (Object[])new Object[]{Float.valueOf(this.getToolDigSpeed(itemStack))}));
        super.func_77624_a(itemStack, worldIn, lines, tooltipFlag);
        toolStats.addInformation(itemStack, lines, tooltipFlag.func_194127_a());
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int getItemEnchantability(ItemStack stack) {
        SolidMaterial primaryMaterial = ToolMetaItem.getToolMaterial(stack);
        return ToolMetaItem.getMaterialEnchantability(primaryMaterial);
    }

    private static int getMaterialEnchantability(SolidMaterial material) {
        if (material.materialIconSet == MaterialIconSet.SHINY || material.materialIconSet == MaterialIconSet.RUBY) {
            return 33;
        }
        if (material.materialIconSet == MaterialIconSet.DULL || material.materialIconSet == MaterialIconSet.METALLIC) {
            return 21;
        }
        if (material.materialIconSet == MaterialIconSet.GEM_VERTICAL || material.materialIconSet == MaterialIconSet.GEM_HORIZONTAL || material.materialIconSet == MaterialIconSet.DIAMOND || material.materialIconSet == MaterialIconSet.OPAL || material.materialIconSet == MaterialIconSet.NETHERSTAR) {
            return 15;
        }
        if (material.materialIconSet == MaterialIconSet.WOOD || material.materialIconSet == MaterialIconSet.ROUGH || material.materialIconSet == MaterialIconSet.FINE) {
            return 11;
        }
        return 10;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaToolValueItem != null && metaToolValueItem.toolStats != null) {
            return metaToolValueItem.toolStats.canApplyEnchantment(stack, enchantment);
        }
        return false;
    }

    @Override
    public int getMaxInternalDamage(ItemStack itemStack) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(itemStack);
        if (metaToolValueItem != null) {
            NBTTagCompound toolTag = ToolMetaItem.getToolStatsTag(itemStack);
            SolidMaterial toolMaterial = ToolMetaItem.getToolMaterial(itemStack);
            IToolStats toolStats = metaToolValueItem.getToolStats();
            int materialDurability = 0;
            if (toolTag != null && toolTag.func_74764_b("MaxDurability")) {
                materialDurability = toolTag.func_74762_e("MaxDurability");
            } else if (toolMaterial != null) {
                materialDurability = toolMaterial.toolDurability;
            }
            float multiplier = toolStats.getMaxDurabilityMultiplier(itemStack);
            return (int)((float)(materialDurability * 10) * multiplier);
        }
        return 0;
    }

    public float getToolDigSpeed(ItemStack itemStack) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(itemStack);
        if (metaToolValueItem != null) {
            NBTTagCompound toolTag = ToolMetaItem.getToolStatsTag(itemStack);
            SolidMaterial toolMaterial = ToolMetaItem.getToolMaterial(itemStack);
            IToolStats toolStats = metaToolValueItem.getToolStats();
            float toolSpeed = 0.0f;
            if (toolTag != null && toolTag.func_74764_b("DigSpeed")) {
                toolSpeed = toolTag.func_74760_g("DigSpeed");
            } else if (toolMaterial != null) {
                toolSpeed = toolMaterial.toolSpeed;
            }
            float multiplier = toolStats.getDigSpeedMultiplier(itemStack);
            return toolSpeed * multiplier;
        }
        return 0.0f;
    }

    public int getHarvestLevel(ItemStack itemStack) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(itemStack);
        if (metaToolValueItem != null) {
            NBTTagCompound toolTag = ToolMetaItem.getToolStatsTag(itemStack);
            SolidMaterial toolMaterial = ToolMetaItem.getToolMaterial(itemStack);
            IToolStats toolStats = metaToolValueItem.getToolStats();
            int harvestLevel = 0;
            if (toolTag != null && toolTag.func_74764_b("HarvestLevel")) {
                harvestLevel = toolTag.func_74762_e("HarvestLevel");
            } else if (toolMaterial != null) {
                harvestLevel = toolMaterial.harvestLevel;
            }
            int baseHarvestLevel = toolStats.getBaseQuality(itemStack);
            return baseHarvestLevel + harvestLevel;
        }
        return 0;
    }

    public float getToolAttackDamage(ItemStack itemStack) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(itemStack);
        if (metaToolValueItem != null) {
            NBTTagCompound toolTag = ToolMetaItem.getToolStatsTag(itemStack);
            SolidMaterial toolMaterial = ToolMetaItem.getToolMaterial(itemStack);
            IToolStats toolStats = metaToolValueItem.getToolStats();
            float attackDamage = 0.0f;
            if (toolTag != null && toolTag.func_74764_b("AttackDamage")) {
                attackDamage = toolTag.func_74760_g("AttackDamage");
            } else if (toolTag != null && toolTag.func_74764_b("HarvestLevel")) {
                attackDamage = toolTag.func_74762_e("HarvestLevel");
            } else if (toolMaterial != null) {
                attackDamage = toolMaterial.toolAttackDamage;
            }
            float baseAttackDamage = toolStats.getBaseDamage(itemStack);
            return baseAttackDamage + attackDamage;
        }
        return 0.0f;
    }

    @Override
    public int getInternalDamage(ItemStack itemStack) {
        NBTTagCompound statsTag = ToolMetaItem.getToolStatsTag(itemStack);
        if (statsTag == null || !statsTag.func_150297_b("Damage", 3)) {
            return 0;
        }
        return statsTag.func_74762_e("Damage");
    }

    private boolean setInternalDamage(ItemStack itemStack, int damage) {
        NBTTagCompound statsTag = ToolMetaItem.getOrCreateToolStatsTag(itemStack);
        statsTag.func_74768_a("Damage", damage);
        return this.getInternalDamage(itemStack) < this.getMaxInternalDamage(itemStack);
    }

    public static NBTTagCompound getToolStatsTag(ItemStack itemStack) {
        return itemStack.func_179543_a("GT.ToolStats");
    }

    public static NBTTagCompound getOrCreateToolStatsTag(ItemStack itemStack) {
        return itemStack.func_190925_c("GT.ToolStats");
    }

    public static void setToolStatsTag(ItemStack itemStack, NBTTagCompound tagCompound) {
        itemStack.func_77983_a("GT.ToolStats", (NBTBase)tagCompound);
    }

    public static SolidMaterial getToolMaterial(ItemStack itemStack) {
        String toolMaterialName;
        NBTTagCompound statsTag = ToolMetaItem.getToolStatsTag(itemStack);
        if (statsTag == null) {
            return Materials.Aluminium;
        }
        if (statsTag.func_74764_b("Material")) {
            toolMaterialName = statsTag.func_74779_i("Material");
        } else if (statsTag.func_74764_b("PrimaryMaterial")) {
            toolMaterialName = statsTag.func_74779_i("PrimaryMaterial");
        } else {
            return Materials.Aluminium;
        }
        Material material = (Material)Material.MATERIAL_REGISTRY.func_82594_a(toolMaterialName);
        if (material instanceof SolidMaterial) {
            return (SolidMaterial)material;
        }
        return Materials.Aluminium;
    }

    public class MetaToolValueItem
    extends MetaItem.MetaValueItem {
        protected IToolStats toolStats;
        protected double amountOfMaterialToRepair;

        private MetaToolValueItem(int metaValue, String unlocalizedName) {
            super(ToolMetaItem.this, metaValue, unlocalizedName);
            this.setMaxStackSize(1);
        }

        @Override
        public MetaToolValueItem addStats(IMetaItemStats ... stats) {
            for (IMetaItemStats metaItemStats : stats) {
                if (!(metaItemStats instanceof IToolStats)) continue;
                this.setToolStats((IToolStats)((Object)metaItemStats));
            }
            super.addStats(stats);
            return this;
        }

        public MetaToolValueItem setFullRepairCost(double amountOfMaterialToRepair) {
            this.amountOfMaterialToRepair = amountOfMaterialToRepair;
            return this;
        }

        public MetaToolValueItem setToolStats(IToolStats toolStats) {
            if (toolStats == null) {
                throw new IllegalArgumentException("Cannot set Tool Stats to null.");
            }
            this.toolStats = toolStats;
            toolStats.onStatsAddedToTool(this);
            return this;
        }

        public MetaToolValueItem addOreDict(ToolDictNames ... oreDictNames) {
            Validate.notNull((Object)oreDictNames, (String)"Cannot add null ToolDictName.", (Object[])new Object[0]);
            Validate.noNullElements((Object[])oreDictNames, (String)"Cannot add null ToolDictName.", (Object[])new Object[0]);
            for (ToolDictNames oreDict : oreDictNames) {
                OreDictionary.registerOre((String)oreDict.name(), (ItemStack)this.getStackForm());
            }
            return this;
        }

        public MetaToolValueItem addToList(Collection<SimpleItemStack> toolList) {
            Validate.notNull(toolList, (String)"Cannot add to null list.", (Object[])new Object[0]);
            toolList.add(new SimpleItemStack(this.getStackForm(1)));
            return this;
        }

        public IToolStats getToolStats() {
            if (this.toolStats == null) {
                throw new IllegalStateException("Someone forgot to assign toolStats to MetaToolValueItem.");
            }
            return this.toolStats;
        }

        public double getAmountOfMaterialToRepair(ItemStack toolStack) {
            return this.amountOfMaterialToRepair;
        }

        @Override
        public ItemStack getStackForm(int amount) {
            ItemStack rawStack = super.getStackForm(amount);
            this.setToolMaterial(rawStack, Materials.Darmstadtium);
            return rawStack;
        }

        public ItemStack getStackForm(SolidMaterial primaryMaterial) {
            ItemStack rawStack = super.getStackForm(1);
            this.setToolMaterial(rawStack, primaryMaterial);
            return rawStack;
        }

        public ItemStack getChargedStack(SolidMaterial primaryMaterial, long chargeAmount) {
            ItemStack rawStack = super.getChargedStack(chargeAmount);
            this.setToolMaterial(rawStack, primaryMaterial);
            return rawStack;
        }

        public ItemStack getMaxChargeOverrideStack(SolidMaterial primaryMaterial, long maxCharge) {
            ItemStack rawStack = super.getMaxChargeOverrideStack(maxCharge);
            this.setToolMaterial(rawStack, primaryMaterial);
            return rawStack;
        }

        public final ItemStack getStackForm(SolidMaterial primaryMaterial, int amount) {
            ItemStack stack = new ItemStack((Item)ToolMetaItem.this, amount, ToolMetaItem.this.metaItemOffset + this.metaValue);
            this.setToolMaterial(stack, primaryMaterial);
            return stack;
        }

        public void setToolMaterial(ItemStack stack, SolidMaterial toolMaterial) {
            NBTTagCompound toolNBT = new NBTTagCompound();
            ArrayList<SolidMaterial> materials = new ArrayList<SolidMaterial>();
            toolNBT.func_74778_a("PrimaryMaterial", toolMaterial.toString());
            materials.add(toolMaterial);
            NBTTagCompound nbtTag = stack.func_77978_p();
            if (nbtTag == null) {
                nbtTag = new NBTTagCompound();
            }
            nbtTag.func_74782_a("GT.ToolStats", (NBTBase)toolNBT);
            stack.func_77982_d(nbtTag);
            Map<Enchantment, Integer> enchantments = this.bakeEnchantmentsMap(stack, materials);
            EnchantmentHelper.func_82782_a(enchantments, (ItemStack)stack);
        }

        public ItemStack setToolData(ItemStack stack, SolidMaterial toolMaterial, int maxDurability, int harvestLevel, float digSpeed, float attackDamage) {
            NBTTagCompound nbtTag;
            NBTTagCompound toolNBT = new NBTTagCompound();
            ArrayList<SolidMaterial> materials = new ArrayList<SolidMaterial>();
            toolNBT.func_74778_a("PrimaryMaterial", toolMaterial.toString());
            materials.add(toolMaterial);
            if (maxDurability > -1) {
                toolNBT.func_74768_a("MaxDurability", maxDurability);
            }
            if (harvestLevel > -1) {
                toolNBT.func_74768_a("HarvestLevel", harvestLevel);
            }
            if (digSpeed > -1.0f) {
                toolNBT.func_74776_a("DigSpeed", digSpeed);
            }
            if (attackDamage > -1.0f) {
                toolNBT.func_74776_a("AttackDamage", attackDamage);
            }
            if ((nbtTag = stack.func_77978_p()) == null) {
                nbtTag = new NBTTagCompound();
            }
            nbtTag.func_74782_a("GT.ToolStats", (NBTBase)toolNBT);
            stack.func_77982_d(nbtTag);
            Map<Enchantment, Integer> enchantments = this.bakeEnchantmentsMap(stack, materials);
            EnchantmentHelper.func_82782_a(enchantments, (ItemStack)stack);
            return stack;
        }

        private Map<Enchantment, Integer> bakeEnchantmentsMap(ItemStack itemStack, Collection<SolidMaterial> materials) {
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            for (SolidMaterial material : materials) {
                for (EnchantmentData enchantmentData : material.toolEnchantments) {
                    if (enchantments.containsKey(enchantmentData.enchantment)) {
                        int level = Math.min((Integer)enchantments.get(enchantmentData.enchantment) + enchantmentData.level, enchantmentData.enchantment.func_77325_b());
                        enchantments.put(enchantmentData.enchantment, level);
                        continue;
                    }
                    enchantments.put(enchantmentData.enchantment, enchantmentData.level);
                }
            }
            for (EnchantmentData enchantmentData : this.toolStats.getEnchantments(itemStack)) {
                if (enchantments.containsKey(enchantmentData.enchantment)) {
                    int level = Math.min((Integer)enchantments.get(enchantmentData.enchantment) + enchantmentData.level, enchantmentData.enchantment.func_77325_b());
                    enchantments.put(enchantmentData.enchantment, level);
                    continue;
                }
                enchantments.put(enchantmentData.enchantment, enchantmentData.level);
            }
            enchantments.keySet().removeIf(enchantment -> !enchantment.func_92089_a(itemStack));
            return enchantments;
        }
    }
}

