/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.metaitem;

import com.google.common.collect.ImmutableList;
import gnu.trove.map.TShortObjectMap;
import gnu.trove.map.hash.TShortObjectHashMap;
import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.capability.impl.CombinedCapabilityProvider;
import gregtech.api.capability.impl.ElectricItem;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.resources.RenderUtil;
import gregtech.api.items.OreDictNames;
import gregtech.api.items.gui.ItemUIFactory;
import gregtech.api.items.gui.PlayerInventoryHolder;
import gregtech.api.items.metaitem.FoodUseManager;
import gregtech.api.items.metaitem.stats.IFoodBehavior;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.metaitem.stats.IItemCapabilityProvider;
import gregtech.api.items.metaitem.stats.IItemColorProvider;
import gregtech.api.items.metaitem.stats.IItemContainerItemProvider;
import gregtech.api.items.metaitem.stats.IItemDurabilityManager;
import gregtech.api.items.metaitem.stats.IItemMaxStackSizeProvider;
import gregtech.api.items.metaitem.stats.IItemModelIndexProvider;
import gregtech.api.items.metaitem.stats.IItemNameProvider;
import gregtech.api.items.metaitem.stats.IItemUseManager;
import gregtech.api.items.metaitem.stats.IMetaItemStats;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.ItemMaterialInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;

public abstract class MetaItem<T extends MetaValueItem>
extends Item
implements ItemUIFactory {
    private static final List<MetaItem<?>> META_ITEMS = new ArrayList();
    protected TShortObjectMap<T> metaItems = new TShortObjectHashMap();
    private Map<String, T> names = new HashMap<String, T>();
    protected TShortObjectMap<ModelResourceLocation> metaItemsModels = new TShortObjectHashMap();
    protected TShortObjectHashMap<ModelResourceLocation[]> specialItemsModels = new TShortObjectHashMap();
    private static final ModelResourceLocation MISSING_LOCATION = new ModelResourceLocation("builtin/missing", "inventory");
    protected final short metaItemOffset;

    public static List<MetaItem<?>> getMetaItems() {
        return Collections.unmodifiableList(META_ITEMS);
    }

    public MetaItem(short metaItemOffset) {
        this.func_77655_b("meta_item");
        this.func_77627_a(true);
        this.metaItemOffset = metaItemOffset;
        META_ITEMS.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerColor() {
        Minecraft.func_71410_x().getItemColors().func_186730_a(this::getColorForItemStack, new Item[]{this});
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (short itemMetaKey : this.metaItems.keys()) {
            MetaValueItem metaValueItem = (MetaValueItem)this.metaItems.get(itemMetaKey);
            int numberOfModels = metaValueItem.getModelAmount();
            if (numberOfModels > 1) {
                ModelResourceLocation[] resourceLocations = new ModelResourceLocation[numberOfModels];
                for (int i = 0; i < resourceLocations.length; ++i) {
                    ResourceLocation resourceLocation = new ResourceLocation("gregtech", this.formatModelPath(metaValueItem) + "/" + (i + 1));
                    ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{resourceLocation});
                    resourceLocations[i] = new ModelResourceLocation(resourceLocation, "inventory");
                }
                this.specialItemsModels.put((short)(this.metaItemOffset + itemMetaKey), (Object)resourceLocations);
                continue;
            }
            ResourceLocation resourceLocation = new ResourceLocation("gregtech", this.formatModelPath(metaValueItem));
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{resourceLocation});
            this.metaItemsModels.put((short)(this.metaItemOffset + itemMetaKey), (Object)new ModelResourceLocation(resourceLocation, "inventory"));
        }
        ModelLoader.setCustomMeshDefinition((Item)this, itemStack -> {
            short itemDamage = this.formatRawItemDamage((short)itemStack.func_77952_i());
            if (this.specialItemsModels.containsKey(itemDamage)) {
                int modelIndex = this.getModelIndex(itemStack);
                return ((ModelResourceLocation[])this.specialItemsModels.get(itemDamage))[modelIndex];
            }
            if (this.metaItemsModels.containsKey(itemDamage)) {
                return (ModelResourceLocation)this.metaItemsModels.get(itemDamage);
            }
            return MISSING_LOCATION;
        });
    }

    protected String formatModelPath(T metaValueItem) {
        return "metaitems/" + ((MetaValueItem)metaValueItem).unlocalizedName;
    }

    protected int getModelIndex(ItemStack itemStack) {
        T metaValueItem = this.getItem(itemStack);
        if (metaValueItem != null && ((MetaValueItem)metaValueItem).getModelIndexProvider() != null) {
            return ((MetaValueItem)metaValueItem).getModelIndexProvider().getModelIndex(itemStack);
        }
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem != null) {
            return (int)Math.min((double)electricItem.getCharge() / ((double)electricItem.getMaxCharge() * 1.0) * 7.0, 7.0);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    protected int getColorForItemStack(ItemStack stack, int tintIndex) {
        T metaValueItem = this.getItem(stack);
        if (metaValueItem != null && ((MetaValueItem)metaValueItem).getColorProvider() != null) {
            return ((MetaValueItem)metaValueItem).getColorProvider().getItemStackColor(stack, tintIndex);
        }
        IFluidHandlerItem fluidContainerItem = (IFluidHandlerItem)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (tintIndex == 0 && fluidContainerItem != null) {
            FluidStack fluidStack = fluidContainerItem.drain(Integer.MAX_VALUE, false);
            return fluidStack == null ? 0x666666 : RenderUtil.getFluidColor(fluidStack);
        }
        return 0xFFFFFF;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        T metaValueItem = this.getItem(stack);
        if (metaValueItem != null && ((MetaValueItem)metaValueItem).getDurabilityManager() != null) {
            return ((MetaValueItem)metaValueItem).getDurabilityManager().showsDurabilityBar(stack);
        }
        IElectricItem electricItem = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        return electricItem != null && (stack.func_77976_d() == 1 || electricItem.getCharge() > 0L);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        T metaValueItem = this.getItem(stack);
        if (metaValueItem != null && ((MetaValueItem)metaValueItem).getDurabilityManager() != null) {
            return ((MetaValueItem)metaValueItem).getDurabilityManager().getDurabilityForDisplay(stack);
        }
        IElectricItem electricItem = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem != null) {
            return 1.0 - (double)electricItem.getCharge() / (1.0 * (double)electricItem.getMaxCharge());
        }
        return 0.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        T metaValueItem = this.getItem(stack);
        if (metaValueItem != null && ((MetaValueItem)metaValueItem).getDurabilityManager() != null) {
            return ((MetaValueItem)metaValueItem).getDurabilityManager().getRGBDurabilityForDisplay(stack);
        }
        return MathHelper.func_181758_c((float)0.33f, (float)1.0f, (float)1.0f);
    }

    protected abstract T constructMetaValueItem(short var1, String var2);

    public final T addItem(int metaValue, String unlocalizedName) {
        Validate.inclusiveBetween((long)0L, (long)32766L, (long)(metaValue + this.metaItemOffset), (String)"MetaItem ID should be in range from 0 to Short.MAX_VALUE-1");
        T metaValueItem = this.constructMetaValueItem((short)metaValue, unlocalizedName);
        if (this.metaItems.containsKey((short)metaValue)) {
            MetaValueItem registeredItem = (MetaValueItem)this.metaItems.get((short)metaValue);
            throw new IllegalArgumentException(String.format("MetaId %d is already occupied by item %s (requested by item %s)", metaValue, registeredItem.unlocalizedName, unlocalizedName));
        }
        this.metaItems.put((short)metaValue, metaValueItem);
        this.names.put(unlocalizedName, metaValueItem);
        return metaValueItem;
    }

    public final Collection<T> getAllItems() {
        return Collections.unmodifiableCollection(this.metaItems.valueCollection());
    }

    public final T getItem(short metaValue) {
        return (T)((MetaValueItem)this.metaItems.get(this.formatRawItemDamage(metaValue)));
    }

    public final T getItem(String valueName) {
        return (T)((MetaValueItem)this.names.get(valueName));
    }

    public final T getItem(ItemStack itemStack) {
        return this.getItem((short)(itemStack.func_77952_i() - this.metaItemOffset));
    }

    protected short formatRawItemDamage(short metaValue) {
        return metaValue;
    }

    public void registerSubItems() {
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        T metaValueItem = this.getItem(stack);
        if (metaValueItem == null) {
            return null;
        }
        ArrayList<ICapabilityProvider> providers = new ArrayList<ICapabilityProvider>();
        for (IMetaItemStats metaItemStats : ((MetaValueItem)metaValueItem).getAllStats()) {
            if (!(metaItemStats instanceof IItemCapabilityProvider)) continue;
            IItemCapabilityProvider provider = (IItemCapabilityProvider)metaItemStats;
            providers.add(provider.createProvider(stack));
        }
        return new CombinedCapabilityProvider(providers);
    }

    public int getItemBurnTime(ItemStack itemStack) {
        T metaValueItem = this.getItem(itemStack);
        if (metaValueItem == null) {
            return super.getItemBurnTime(itemStack);
        }
        return ((MetaValueItem)metaValueItem).getBurnValue();
    }

    private IItemUseManager getUseManager(ItemStack itemStack) {
        T metaValueItem = this.getItem(itemStack);
        if (metaValueItem == null) {
            return null;
        }
        return ((MetaValueItem)metaValueItem).getUseManager();
    }

    public List<IItemBehaviour> getBehaviours(ItemStack itemStack) {
        T metaValueItem = this.getItem(itemStack);
        if (metaValueItem == null) {
            return ImmutableList.of();
        }
        return ((MetaValueItem)metaValueItem).getBehaviours();
    }

    public int getItemStackLimit(ItemStack stack) {
        T metaValueItem = this.getItem(stack);
        if (metaValueItem == null) {
            return 64;
        }
        return ((MetaValueItem)metaValueItem).getMaxStackSize(stack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        IItemUseManager useManager = this.getUseManager(stack);
        if (useManager != null) {
            return useManager.getUseAction(stack);
        }
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        IItemUseManager useManager = this.getUseManager(stack);
        if (useManager != null) {
            return useManager.getMaxItemUseDuration(stack);
        }
        return 0;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        IItemUseManager useManager;
        if (player instanceof EntityPlayer && (useManager = this.getUseManager(stack)) != null) {
            useManager.onItemUsingTick(stack, (EntityPlayer)player, count);
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase player, int timeLeft) {
        IItemUseManager useManager;
        if (player instanceof EntityPlayer && (useManager = this.getUseManager(stack)) != null) {
            useManager.onPlayerStoppedItemUsing(stack, (EntityPlayer)player, timeLeft);
        }
    }

    @Nullable
    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase player) {
        IItemUseManager useManager;
        if (player instanceof EntityPlayer && (useManager = this.getUseManager(stack)) != null) {
            return useManager.onItemUseFinish(stack, (EntityPlayer)player);
        }
        return stack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        boolean returnValue = false;
        for (IItemBehaviour behaviour : this.getBehaviours(stack)) {
            if (!behaviour.onLeftClickEntity(stack, player, entity)) continue;
            returnValue = true;
        }
        return returnValue;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        for (IItemBehaviour behaviour : this.getBehaviours(itemStack)) {
            ActionResult<ItemStack> behaviourResult = behaviour.onItemRightClick(world, player, hand);
            itemStack = (ItemStack)behaviourResult.func_188398_b();
            if (behaviourResult.func_188397_a() != EnumActionResult.PASS) {
                return ActionResult.newResult((EnumActionResult)behaviourResult.func_188397_a(), (Object)itemStack);
            }
            if (!itemStack.func_190926_b()) continue;
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)ItemStack.field_190927_a);
        }
        IItemUseManager useManager = this.getUseManager(itemStack);
        if (useManager != null && useManager.canStartUsing(itemStack, player)) {
            useManager.onItemUseStart(itemStack, player);
            player.func_184598_c(hand);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        for (IItemBehaviour behaviour : this.getBehaviours(itemStack)) {
            EnumActionResult behaviourResult = behaviour.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
            if (behaviourResult != EnumActionResult.PASS) {
                return behaviourResult;
            }
            if (!itemStack.func_190926_b()) continue;
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack originalStack = stack.func_77946_l();
        for (IItemBehaviour behaviour : this.getBehaviours(stack)) {
            ActionResult<ItemStack> behaviourResult = behaviour.onItemUse(player, world, pos, hand, facing, hitX, hitY, hitZ);
            stack = (ItemStack)behaviourResult.func_188398_b();
            if (behaviourResult.func_188397_a() != EnumActionResult.PASS) {
                if (!ItemStack.func_77989_b((ItemStack)originalStack, (ItemStack)stack)) {
                    player.func_184611_a(hand, stack);
                }
                return behaviourResult.func_188397_a();
            }
            if (!stack.func_190926_b()) continue;
            player.func_184611_a(hand, ItemStack.field_190927_a);
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        if (stack.func_77952_i() >= this.metaItemOffset) {
            T item = this.getItem(stack);
            if (item == null) {
                return "unnamed";
            }
            String unlocalizedName = String.format("metaitem.%s.name", ((MetaValueItem)item).unlocalizedName);
            if (((MetaValueItem)item).getNameProvider() != null) {
                return ((MetaValueItem)item).getNameProvider().getItemStackDisplayName(stack, unlocalizedName);
            }
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (fluidHandlerItem != null) {
                FluidStack fluidInside = fluidHandlerItem.drain(Integer.MAX_VALUE, false);
                String name = fluidInside == null ? "metaitem.fluid_cell.empty" : fluidInside.getUnlocalizedName();
                return I18n.func_135052_a((String)unlocalizedName, (Object[])new Object[]{I18n.func_135052_a((String)name, (Object[])new Object[0])});
            }
            return I18n.func_135052_a((String)unlocalizedName, (Object[])new Object[0]);
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<String> lines, ITooltipFlag tooltipFlag) {
        IFluidHandlerItem fluidHandler;
        IElectricItem electricItem;
        T item = this.getItem(itemStack);
        if (item == null) {
            return;
        }
        String unlocalizedTooltip = "metaitem." + ((MetaValueItem)item).unlocalizedName + ".tooltip";
        if (I18n.func_188566_a((String)unlocalizedTooltip)) {
            lines.addAll(Arrays.asList(I18n.func_135052_a((String)unlocalizedTooltip, (Object[])new Object[0]).split("/n")));
        }
        if ((electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)) != null) {
            lines.add(I18n.func_135052_a((String)"metaitem.generic.electric_item.tooltip", (Object[])new Object[]{electricItem.getCharge(), electricItem.getMaxCharge(), electricItem.getTier()}));
        }
        if ((fluidHandler = (IFluidHandlerItem)ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
            IFluidTankProperties fluidTankProperties = fluidHandler.getTankProperties()[0];
            FluidStack fluid = fluidTankProperties.getContents();
            if (fluid != null) {
                lines.add(I18n.func_135052_a((String)"metaitem.generic.fluid_container.tooltip", (Object[])new Object[]{fluid.amount, fluidTankProperties.getCapacity(), fluid.getLocalizedName()}));
            } else {
                lines.add(I18n.func_135052_a((String)"metaitem.generic.fluid_container.tooltip_empty", (Object[])new Object[0]));
            }
        }
        for (IItemBehaviour behaviour : this.getBehaviours(itemStack)) {
            behaviour.addInformation(itemStack, lines);
        }
    }

    public boolean hasContainerItem(ItemStack itemStack) {
        T item = this.getItem(itemStack);
        if (item == null) {
            return false;
        }
        return ((MetaValueItem)item).getContainerItemProvider() != null;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        T item = this.getItem(itemStack);
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        itemStack = itemStack.func_77946_l();
        itemStack.func_190920_e(1);
        IItemContainerItemProvider provider = ((MetaValueItem)item).getContainerItemProvider();
        return provider == null ? ItemStack.field_190927_a : provider.getContainerItem(itemStack);
    }

    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{GregTechAPI.TAB_GREGTECH, GregTechAPI.TAB_GREGTECH_MATERIALS};
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (tab != GregTechAPI.TAB_GREGTECH && tab != CreativeTabs.field_78027_g) {
            return;
        }
        for (MetaValueItem enabledItem : this.metaItems.valueCollection()) {
            if (!enabledItem.isVisible()) continue;
            ItemStack itemStack = enabledItem.getStackForm();
            subItems.add((Object)itemStack.func_77946_l());
            IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            if (electricItem != null) {
                electricItem.charge(Long.MAX_VALUE, Integer.MAX_VALUE, true, false);
                subItems.add((Object)itemStack);
            }
            if (tab != CreativeTabs.field_78027_g || !itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) continue;
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                ItemStack containerStack = itemStack.func_77946_l();
                IFluidHandlerItem fluidContainer = (IFluidHandlerItem)containerStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                fluidContainer.fill(new FluidStack(fluid, Integer.MAX_VALUE), true);
                if (fluidContainer.drain(Integer.MAX_VALUE, false) == null) continue;
                subItems.add((Object)fluidContainer.getContainer());
            }
        }
    }

    @Override
    public ModularUI createUI(PlayerInventoryHolder holder, EntityPlayer entityPlayer) {
        ItemStack itemStack = holder.getCurrentItem();
        T metaValueItem = this.getItem(itemStack);
        ItemUIFactory uiFactory = metaValueItem == null ? null : ((MetaValueItem)metaValueItem).getUIManager();
        return uiFactory == null ? null : uiFactory.createUI(holder, entityPlayer);
    }

    public class MetaValueItem {
        public final int metaValue;
        public final String unlocalizedName;
        private List<IMetaItemStats> allStats = new ArrayList<IMetaItemStats>();
        private List<IItemBehaviour> behaviours = new ArrayList<IItemBehaviour>();
        private IItemUseManager useManager;
        private ItemUIFactory uiManager;
        private IItemDurabilityManager durabilityManager;
        private IItemMaxStackSizeProvider stackSizeProvider;
        private IItemColorProvider colorProvider;
        private IItemModelIndexProvider modelIndexProvider;
        private IItemContainerItemProvider containerItemProvider;
        private IItemNameProvider nameProvider;
        private int burnValue = 0;
        private boolean visible = true;
        private int maxStackSize = 64;
        private int modelAmount = 1;

        public MetaItem<T> getMetaItem() {
            return MetaItem.this;
        }

        protected MetaValueItem(int metaValue, String unlocalizedName) {
            this.metaValue = metaValue;
            this.unlocalizedName = unlocalizedName;
        }

        public MetaValueItem setMaterialInfo(ItemMaterialInfo materialInfo) {
            if (materialInfo == null) {
                throw new IllegalArgumentException("Cannot add null ItemMaterialInfo.");
            }
            OreDictUnifier.registerOre(this.getStackForm(), materialInfo);
            return this;
        }

        public MetaValueItem setUnificationData(OrePrefix prefix, @Nullable Material material) {
            if (prefix == null) {
                throw new IllegalArgumentException("Cannot add null OrePrefix.");
            }
            OreDictUnifier.registerOre(this.getStackForm(), prefix, material);
            return this;
        }

        public MetaValueItem addOreDict(String oreDictName) {
            if (oreDictName == null) {
                throw new IllegalArgumentException("Cannot add null OreDictName.");
            }
            OreDictionary.registerOre((String)oreDictName, (ItemStack)this.getStackForm());
            return this;
        }

        public MetaValueItem addOreDict(OreDictNames oreDictName) {
            if (oreDictName == null) {
                throw new IllegalArgumentException("Cannot add null OreDictName.");
            }
            OreDictionary.registerOre((String)oreDictName.name(), (ItemStack)this.getStackForm());
            return this;
        }

        public MetaValueItem setInvisible() {
            this.visible = false;
            return this;
        }

        public MetaValueItem setMaxStackSize(int maxStackSize) {
            if (maxStackSize <= 0) {
                throw new IllegalArgumentException("Cannot set Max Stack Size to negative or zero value.");
            }
            this.maxStackSize = maxStackSize;
            return this;
        }

        public MetaValueItem setBurnValue(int burnValue) {
            if (burnValue <= 0) {
                throw new IllegalArgumentException("Cannot set Burn Value to negative or zero number.");
            }
            this.burnValue = burnValue;
            return this;
        }

        public MetaValueItem setModelAmount(int modelAmount) {
            if (modelAmount <= 0) {
                throw new IllegalArgumentException("Cannot set amount of models to negative or zero number.");
            }
            this.modelAmount = modelAmount;
            return this;
        }

        public MetaValueItem addStats(IMetaItemStats ... stats) {
            for (IMetaItemStats metaItemStats : stats) {
                if (metaItemStats instanceof IItemDurabilityManager) {
                    this.durabilityManager = (IItemDurabilityManager)metaItemStats;
                }
                if (metaItemStats instanceof IItemUseManager) {
                    this.useManager = (IItemUseManager)metaItemStats;
                }
                if (metaItemStats instanceof IFoodBehavior) {
                    this.useManager = new FoodUseManager((IFoodBehavior)metaItemStats);
                }
                if (metaItemStats instanceof ItemUIFactory) {
                    this.uiManager = (ItemUIFactory)((Object)metaItemStats);
                }
                if (metaItemStats instanceof IItemMaxStackSizeProvider) {
                    this.stackSizeProvider = (IItemMaxStackSizeProvider)metaItemStats;
                }
                if (metaItemStats instanceof IItemColorProvider) {
                    this.colorProvider = (IItemColorProvider)metaItemStats;
                }
                if (metaItemStats instanceof IItemModelIndexProvider) {
                    this.modelIndexProvider = (IItemModelIndexProvider)metaItemStats;
                }
                if (metaItemStats instanceof IItemNameProvider) {
                    this.nameProvider = (IItemNameProvider)metaItemStats;
                }
                if (metaItemStats instanceof IItemContainerItemProvider) {
                    this.containerItemProvider = (IItemContainerItemProvider)metaItemStats;
                }
                if (metaItemStats instanceof IItemBehaviour) {
                    this.behaviours.add((IItemBehaviour)metaItemStats);
                }
                this.allStats.add(metaItemStats);
            }
            return this;
        }

        public int getMetaValue() {
            return this.metaValue;
        }

        public List<IMetaItemStats> getAllStats() {
            return Collections.unmodifiableList(this.allStats);
        }

        public List<IItemBehaviour> getBehaviours() {
            return Collections.unmodifiableList(this.behaviours);
        }

        @Nullable
        public IItemDurabilityManager getDurabilityManager() {
            return this.durabilityManager;
        }

        @Nullable
        public IItemUseManager getUseManager() {
            return this.useManager;
        }

        @Nullable
        public ItemUIFactory getUIManager() {
            return this.uiManager;
        }

        @Nullable
        public IItemColorProvider getColorProvider() {
            return this.colorProvider;
        }

        @Nullable
        public IItemNameProvider getNameProvider() {
            return this.nameProvider;
        }

        @Nullable
        public IItemModelIndexProvider getModelIndexProvider() {
            return this.modelIndexProvider;
        }

        @Nullable
        public IItemContainerItemProvider getContainerItemProvider() {
            return this.containerItemProvider;
        }

        public int getBurnValue() {
            return this.burnValue;
        }

        public int getMaxStackSize(ItemStack stack) {
            return this.stackSizeProvider == null ? this.maxStackSize : this.stackSizeProvider.getMaxStackSize(stack, this.maxStackSize);
        }

        public boolean isVisible() {
            return this.visible;
        }

        public int getModelAmount() {
            return this.modelAmount;
        }

        public ItemStack getStackForm(int amount) {
            return new ItemStack((Item)MetaItem.this, amount, MetaItem.this.metaItemOffset + this.metaValue);
        }

        public boolean isItemEqual(ItemStack itemStack) {
            return itemStack.func_77973_b() == MetaItem.this && itemStack.func_77952_i() == MetaItem.this.metaItemOffset + this.metaValue;
        }

        public ItemStack getStackForm() {
            return this.getStackForm(1);
        }

        public ItemStack getChargedStack(long chargeAmount) {
            ItemStack itemStack = this.getStackForm(1);
            IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            if (electricItem == null) {
                throw new IllegalStateException("Not an electric item.");
            }
            electricItem.charge(chargeAmount, Integer.MAX_VALUE, true, false);
            return itemStack;
        }

        public ItemStack getMaxChargeOverrideStack(long maxCharge) {
            ItemStack itemStack = this.getStackForm(1);
            IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            if (electricItem == null) {
                throw new IllegalStateException("Not an electric item.");
            }
            if (!(electricItem instanceof ElectricItem)) {
                throw new IllegalStateException("Only standard ElectricItem implementation supported, but this item uses " + electricItem.getClass());
            }
            ((ElectricItem)electricItem).setMaxChargeOverride(maxCharge);
            return itemStack;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("metaValue", this.metaValue).append("unlocalizedName", (Object)this.unlocalizedName).toString();
        }
    }
}

