/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.INativeWidget;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class SlotWidget
extends Widget
implements INativeWidget {
    protected Slot slotReference;
    protected boolean isEnabled = true;
    public final IItemHandlerModifiable itemHandler;
    public final int slotIndex;
    public final int xPosition;
    public final int yPosition;
    protected boolean canTakeItems;
    protected boolean canPutItems;
    protected boolean isPlayerInventory;
    protected TextureArea[] backgroundTexture;
    protected Runnable changeListener;

    public SlotWidget(IItemHandlerModifiable itemHandler, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems) {
        this.itemHandler = itemHandler;
        this.slotIndex = slotIndex;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.canTakeItems = canTakeItems;
        this.canPutItems = canPutItems;
    }

    public SlotWidget setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public void detectAndSendChanges() {
    }

    public SlotWidget(IItemHandlerModifiable itemHandler, int slotIndex, int xPosition, int yPosition) {
        this(itemHandler, slotIndex, xPosition, yPosition, true, true);
    }

    public SlotWidget setBackgroundTexture(TextureArea ... backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public SlotWidget markAsPlayerInventory() {
        this.isPlayerInventory = true;
        return this;
    }

    public boolean canPutStack(ItemStack stack) {
        return this.isEnabled && this.canPutItems;
    }

    public boolean canTakeStack(EntityPlayer player) {
        return this.isEnabled && this.canTakeItems;
    }

    @Override
    public boolean isPlayerInventorySlot() {
        return this.isPlayerInventory;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean canMergeSlot(ItemStack stack) {
        return this.isEnabled;
    }

    public void onSlotChanged() {
        this.gui.holder.markAsDirty();
    }

    @Override
    public ItemStack slotClick(int dragType, ClickType clickTypeIn, EntityPlayer player) {
        return INativeWidget.VANILLA_LOGIC;
    }

    @Override
    public final Slot allocateSlotHandle() {
        return this.slotReference;
    }

    @Override
    public void initWidget() {
        this.slotReference = new SlotItemHandler((IItemHandler)this.itemHandler, this.slotIndex, this.xPosition, this.yPosition){

            public boolean func_75214_a(@Nonnull ItemStack stack) {
                return SlotWidget.this.canPutStack(stack) && super.func_75214_a(stack);
            }

            public boolean func_82869_a(EntityPlayer playerIn) {
                return SlotWidget.this.canTakeStack(playerIn) && super.func_82869_a(playerIn);
            }

            public void func_75215_d(@Nonnull ItemStack stack) {
                super.func_75215_d(stack);
                if (SlotWidget.this.changeListener != null) {
                    SlotWidget.this.changeListener.run();
                }
            }

            public void func_75218_e() {
                SlotWidget.this.onSlotChanged();
            }

            public boolean func_111238_b() {
                return SlotWidget.this.isEnabled();
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY) {
        if (this.isEnabled && this.backgroundTexture != null) {
            for (TextureArea backgroundTexture : this.backgroundTexture) {
                backgroundTexture.draw(this.xPosition - 1, this.yPosition - 1, 18, 18);
            }
        }
    }
}

