/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import com.google.common.collect.Lists;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.RenderUtil;
import gregtech.api.gui.resources.TextureArea;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class PhantomFluidWidget
extends Widget {
    protected int xPosition;
    protected int yPosition;
    protected int width;
    protected int height;
    protected TextureArea backgroundTexture = GuiTextures.FLUID_SLOT;
    private Supplier<FluidStack> fluidStackSupplier;
    private Consumer<FluidStack> fluidStackUpdater;
    protected FluidStack lastFluidStack;

    public PhantomFluidWidget(int xPosition, int yPosition, int width, int height, Supplier<FluidStack> fluidStackSupplier, Consumer<FluidStack> fluidStackUpdater) {
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.fluidStackSupplier = fluidStackSupplier;
        this.fluidStackUpdater = fluidStackUpdater;
    }

    public PhantomFluidWidget setBackgroundTexture(TextureArea backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    @Override
    public void detectAndSendChanges() {
        FluidStack currentStack = this.fluidStackSupplier.get();
        if (currentStack == null && this.lastFluidStack != null) {
            this.lastFluidStack = null;
            this.writeUpdateInfo(1, buffer -> buffer.writeBoolean(false));
        } else if (currentStack != null && !currentStack.isFluidStackIdentical(this.lastFluidStack)) {
            this.lastFluidStack = currentStack;
            this.writeUpdateInfo(1, buffer -> {
                buffer.writeBoolean(true);
                buffer.func_150786_a(currentStack.writeToNBT(new NBTTagCompound()));
            });
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 1) {
            if (buffer.readBoolean()) {
                try {
                    NBTTagCompound tagCompound = buffer.func_150793_b();
                    this.lastFluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.lastFluidStack = null;
            }
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == 1) {
            ItemStack itemStack = this.gui.entityPlayer.field_71071_by.func_70445_o().func_77946_l();
            if (!itemStack.func_190926_b()) {
                itemStack.func_190920_e(1);
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (fluidHandler != null) {
                    FluidStack resultFluid = fluidHandler.drain(Integer.MAX_VALUE, false);
                    this.fluidStackUpdater.accept(resultFluid);
                }
            } else {
                this.fluidStackUpdater.accept(null);
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (PhantomFluidWidget.isMouseOver(this.xPosition, this.yPosition, this.width, this.height, mouseX, mouseY)) {
            this.writeClientAction(1, buffer -> {});
            return true;
        }
        return false;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY) {
        if (this.backgroundTexture != null) {
            this.backgroundTexture.draw(this.xPosition, this.yPosition, this.width, this.height);
        }
        if (this.lastFluidStack != null) {
            GlStateManager.func_179084_k();
            RenderUtil.drawFluidForGui(this.lastFluidStack, this.lastFluidStack.amount, this.xPosition + 1, this.yPosition + 1, this.width - 1, this.height - 1);
            GlStateManager.func_179147_l();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (PhantomFluidWidget.isMouseOver(this.xPosition, this.yPosition, this.width, this.height, mouseX, mouseY) && this.lastFluidStack != null) {
            String fluidName = this.lastFluidStack.getLocalizedName();
            this.drawHoveringText(ItemStack.field_190927_a, Lists.newArrayList((Object[])new String[]{fluidName}), -1, mouseX, mouseY);
        }
    }
}

