/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.impl;

import gregtech.api.gui.INativeWidget;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.WidgetUIAccess;
import gregtech.api.net.NetworkHandler;
import gregtech.api.net.PacketUIClientAction;
import gregtech.api.net.PacketUIWidgetUpdate;
import gregtech.api.util.GTUtility;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class ModularUIContainer
extends Container
implements WidgetUIAccess {
    private final HashMap<Slot, INativeWidget> slotMap = new HashMap();
    private final ModularUI modularUI;
    public boolean accumulateWidgetUpdateData = false;
    public List<PacketUIWidgetUpdate> accumulatedUpdates = new ArrayList<PacketUIWidgetUpdate>();

    public ModularUIContainer(ModularUI modularUI) {
        this.modularUI = modularUI;
        modularUI.guiWidgets.values().forEach(widget -> widget.setUiAccess(this));
        modularUI.guiWidgets.values().stream().flatMap(widget -> widget.getNativeWidgets().stream()).forEach(nativeWidget -> {
            Slot slot = nativeWidget.allocateSlotHandle();
            this.slotMap.put(slot, (INativeWidget)nativeWidget);
            this.func_75146_a(slot);
        });
    }

    public ModularUI getModularUI() {
        return this.modularUI;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.modularUI.triggerCloseListeners();
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.modularUI.guiWidgets.values().forEach(Widget::detectAndSendChanges);
        this.modularUI.triggerOpenListeners();
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.modularUI.guiWidgets.values().forEach(Widget::detectAndSendChanges);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId >= 0 && slotId < this.field_75151_b.size()) {
            Slot slot = this.func_75139_a(slotId);
            ItemStack result = this.slotMap.get(slot).slotClick(dragType, clickTypeIn, player);
            if (result == INativeWidget.VANILLA_LOGIC) {
                return super.func_184996_a(slotId, dragType, clickTypeIn, player);
            }
            return result;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        boolean mergedStack;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack remainingStack = slot.func_75211_c();
        if (this.slotMap.get(slot).isPlayerInventorySlot()) {
            List<Slot> containerSlots = this.slotMap.entrySet().stream().filter(s -> !((INativeWidget)s.getValue()).isPlayerInventorySlot()).map(Map.Entry::getKey).sorted(Comparator.comparing(s -> s.field_75222_d)).collect(Collectors.toList());
            mergedStack = GTUtility.mergeItemStack(remainingStack, containerSlots);
        } else {
            List<Slot> inventorySlots = this.slotMap.entrySet().stream().filter(s -> ((INativeWidget)s.getValue()).isPlayerInventorySlot()).map(Map.Entry::getKey).sorted(Collections.reverseOrder(Comparator.comparing(s -> s.field_75222_d))).collect(Collectors.toList());
            mergedStack = GTUtility.mergeItemStack(remainingStack, inventorySlots);
        }
        if (!mergedStack) {
            return ItemStack.field_190927_a;
        }
        if (remainingStack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return remainingStack;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return this.slotMap.get(slotIn).canMergeSlot(stack);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    @Override
    public void writeClientAction(Widget widget, int updateId, Consumer<PacketBuffer> payloadWriter) {
        int widgetId = (Integer)this.modularUI.guiWidgets.inverse().get((Object)widget);
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        packetBuffer.func_150787_b(updateId);
        payloadWriter.accept(packetBuffer);
        if (this.modularUI.entityPlayer instanceof EntityPlayerSP) {
            PacketUIClientAction widgetUpdate = new PacketUIClientAction(this.field_75152_c, widgetId, packetBuffer);
            NetworkHandler.channel.sendToServer(NetworkHandler.packet2proxy(widgetUpdate));
        }
    }

    @Override
    public void writeUpdateInfo(Widget widget, int updateId, Consumer<PacketBuffer> payloadWriter) {
        int widgetId = (Integer)this.modularUI.guiWidgets.inverse().get((Object)widget);
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        packetBuffer.func_150787_b(updateId);
        payloadWriter.accept(packetBuffer);
        if (this.modularUI.entityPlayer instanceof EntityPlayerMP) {
            PacketUIWidgetUpdate widgetUpdate = new PacketUIWidgetUpdate(this.field_75152_c, widgetId, packetBuffer);
            if (!this.accumulateWidgetUpdateData) {
                NetworkHandler.channel.sendTo(NetworkHandler.packet2proxy(widgetUpdate), (EntityPlayerMP)this.modularUI.entityPlayer);
            } else {
                this.accumulatedUpdates.add(widgetUpdate);
            }
        }
    }
}

