/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.RecipeMapWorkableHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.RecipeMap;
import java.util.function.Supplier;

public class EnergyRecipeMapWorkableHandler
extends RecipeMapWorkableHandler {
    private final Supplier<IEnergyContainer> energyContainer;

    public EnergyRecipeMapWorkableHandler(MetaTileEntity tileEntity, RecipeMap<?> recipeMap, Supplier<IEnergyContainer> energyContainer) {
        super(tileEntity, recipeMap);
        this.energyContainer = energyContainer;
    }

    @Override
    protected long getEnergyStored() {
        return this.energyContainer.get().getEnergyStored();
    }

    @Override
    protected long getEnergyCapacity() {
        return this.energyContainer.get().getEnergyCapacity();
    }

    @Override
    protected boolean drawEnergy(int recipeEUt) {
        long resultEnergy = this.getEnergyStored() - (long)recipeEUt;
        if (resultEnergy >= 0L && resultEnergy <= this.getEnergyCapacity()) {
            this.energyContainer.get().changeEnergy(-recipeEUt);
            return true;
        }
        return false;
    }

    @Override
    protected long getMaxVoltage() {
        return Math.max(this.energyContainer.get().getInputVoltage(), this.energyContainer.get().getOutputVoltage());
    }
}

