/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gnu.trove.list.array.TIntArrayList;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandlerModifiable;

public class EnergyContainerBatteryBuffer
extends MTETrait
implements IEnergyContainer {
    private final int tier;

    public EnergyContainerBatteryBuffer(MetaTileEntity metaTileEntity, int tier) {
        super(metaTileEntity);
        this.tier = tier;
    }

    @Override
    public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
        long initialAmperage = amperage;
        if (side == null || this.inputsEnergy(side)) {
            if (voltage > this.getInputVoltage()) {
                IEnergyContainer.doOvervoltageExplosion(this.metaTileEntity, voltage);
                return Math.min(amperage, this.getInputAmperage());
            }
            IItemHandlerModifiable inventory = this.getInventory();
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack batteryStack = inventory.getStackInSlot(i);
                IElectricItem electricItem = this.getBatteryContainer(batteryStack);
                if (electricItem == null || !EnergyContainerBatteryBuffer.chargeOrDischargeItem(electricItem, voltage, this.getTier(), true)) continue;
                EnergyContainerBatteryBuffer.chargeOrDischargeItem(electricItem, voltage, this.getTier(), false);
                inventory.setStackInSlot(i, batteryStack);
                if (--amperage == 0L) break;
            }
        }
        return initialAmperage - amperage;
    }

    private static boolean chargeOrDischargeItem(IElectricItem electricItem, long voltage, int tier, boolean simulate) {
        if (voltage > 0L) {
            return electricItem.charge(voltage, tier, true, simulate) == voltage;
        }
        return electricItem.discharge(-voltage, tier, true, true, simulate) == -voltage;
    }

    @Override
    public void update() {
        if (!this.metaTileEntity.getWorld().field_72995_K) {
            EnumFacing outFacing = this.metaTileEntity.getFrontFacing();
            TileEntity tileEntity = this.metaTileEntity.getWorld().func_175625_s(this.metaTileEntity.getPos().func_177972_a(outFacing));
            if (tileEntity == null) {
                return;
            }
            IEnergyContainer energyContainer = (IEnergyContainer)tileEntity.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, outFacing.func_176734_d());
            if (energyContainer == null) {
                return;
            }
            IItemHandlerModifiable inventory = this.getInventory();
            long voltage = this.getOutputVoltage();
            long maxAmperage = 0L;
            TIntArrayList slotsList = new TIntArrayList();
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack batteryStack = inventory.getStackInSlot(i);
                IElectricItem electricItem = this.getBatteryContainer(batteryStack);
                if (electricItem == null || electricItem.discharge(voltage, this.getTier(), true, true, true) != voltage) continue;
                slotsList.add(i);
                ++maxAmperage;
            }
            if (maxAmperage == 0L) {
                return;
            }
            long amperageUsed = energyContainer.acceptEnergyFromNetwork(outFacing.func_176734_d(), voltage, maxAmperage);
            if (amperageUsed == 0L) {
                return;
            }
            for (int i : slotsList.toArray()) {
                ItemStack batteryStack = inventory.getStackInSlot(i);
                IElectricItem electricItem = this.getBatteryContainer(batteryStack);
                if (electricItem == null) continue;
                electricItem.discharge(voltage, this.getTier(), true, true, false);
                inventory.setStackInSlot(i, batteryStack);
                if (--amperageUsed == 0L) break;
            }
        }
    }

    @Override
    public long getEnergyCapacity() {
        long energyCapacity = 0L;
        IItemHandlerModifiable inventory = this.getInventory();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack batteryStack = inventory.getStackInSlot(i);
            IElectricItem electricItem = this.getBatteryContainer(batteryStack);
            if (electricItem == null) continue;
            energyCapacity += electricItem.getMaxCharge();
        }
        return energyCapacity;
    }

    @Override
    public long getEnergyStored() {
        long energyStored = 0L;
        IItemHandlerModifiable inventory = this.getInventory();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack batteryStack = inventory.getStackInSlot(i);
            IElectricItem electricItem = this.getBatteryContainer(batteryStack);
            if (electricItem == null) continue;
            energyStored += electricItem.getCharge();
        }
        return energyStored;
    }

    @Override
    public long getInputAmperage() {
        long inputAmperage = 0L;
        IItemHandlerModifiable inventory = this.getInventory();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack batteryStack = inventory.getStackInSlot(i);
            IElectricItem electricItem = this.getBatteryContainer(batteryStack);
            if (electricItem == null) continue;
            ++inputAmperage;
        }
        return inputAmperage;
    }

    public IElectricItem getBatteryContainer(ItemStack itemStack) {
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem == null || electricItem.getTier() != this.getTier() || !electricItem.canProvideChargeExternally()) {
            return null;
        }
        return electricItem;
    }

    @Override
    public long changeEnergy(long energyToAdd) {
        long inputVoltage = this.getInputVoltage();
        return this.acceptEnergyFromNetwork(null, energyToAdd > 0L ? inputVoltage : -inputVoltage, Math.abs(energyToAdd) / inputVoltage) * inputVoltage;
    }

    @Override
    public long getInputVoltage() {
        return GTValues.V[this.getTier()];
    }

    @Override
    public long getOutputVoltage() {
        return this.getInputVoltage();
    }

    @Override
    public long getOutputAmperage() {
        return this.getInputAmperage();
    }

    @Override
    public boolean inputsEnergy(EnumFacing side) {
        return this.getMetaTileEntity().getFrontFacing() != side;
    }

    @Override
    public boolean outputsEnergy(EnumFacing side) {
        return !this.inputsEnergy(side);
    }

    @Override
    public String getName() {
        return "BatteryEnergyContainer";
    }

    @Override
    public int getNetworkID() {
        return 1;
    }

    @Override
    @Nullable
    public Capability<?> getImplementingCapability() {
        return GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER;
    }

    protected IItemHandlerModifiable getInventory() {
        return this.metaTileEntity.getImportItems();
    }

    protected int getTier() {
        return this.tier;
    }
}

