/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api;

import gregtech.api.block.machines.BlockMachine;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.ore.StoneType;
import gregtech.api.unification.stack.SimpleItemStack;
import gregtech.api.util.BaseCreativeTab;
import gregtech.api.util.GTControlledRegistry;
import gregtech.api.util.IBlockOre;
import gregtech.common.items.MetaItems;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class GregTechAPI {
    public static BlockMachine MACHINE;
    public static final BaseCreativeTab TAB_GREGTECH;
    public static final BaseCreativeTab TAB_GREGTECH_MATERIALS;
    public static final BaseCreativeTab TAB_GREGTECH_ORES;
    public static final GTControlledRegistry<ResourceLocation, MetaTileEntity> META_TILE_ENTITY_REGISTRY;
    public static final HashSet<SimpleItemStack> crowbarList;
    public static final HashSet<SimpleItemStack> screwdriverList;
    public static final HashSet<SimpleItemStack> wrenchList;
    public static final HashSet<SimpleItemStack> softHammerList;
    public static final HashSet<SimpleItemStack> hardHammerList;
    public static final HashSet<SimpleItemStack> gasHazmatList;
    public static final HashSet<SimpleItemStack> bioHazmatList;
    public static final HashSet<SimpleItemStack> frostHazmatList;
    public static final HashSet<SimpleItemStack> heatHazmatList;
    public static final HashSet<SimpleItemStack> radioHazmatList;
    public static final HashSet<SimpleItemStack> electroHazmatList;
    public static final Collection<Integer> dimensionalList;
    public static final Map<DustMaterial, Map<StoneType, IBlockOre>> oreBlockTable;

    public static <T extends MetaTileEntity> T registerMetaTileEntity(int id, T sampleMetaTileEntity) {
        META_TILE_ENTITY_REGISTRY.register(id, sampleMetaTileEntity.metaTileEntityId, sampleMetaTileEntity);
        return sampleMetaTileEntity;
    }

    static {
        TAB_GREGTECH = new BaseCreativeTab("gregtech.main", () -> MetaItems.BATTERY_HULL_HV.getStackForm(), true);
        TAB_GREGTECH_MATERIALS = new BaseCreativeTab("gregtech.materials", () -> OreDictUnifier.get(OrePrefix.ingot, Materials.Aluminium), true);
        TAB_GREGTECH_ORES = new BaseCreativeTab("gregtech.ores", () -> MetaItems.JACKHAMMER.getStackForm(), true);
        META_TILE_ENTITY_REGISTRY = new GTControlledRegistry(Short.MAX_VALUE);
        crowbarList = new HashSet();
        screwdriverList = new HashSet();
        wrenchList = new HashSet();
        softHammerList = new HashSet();
        hardHammerList = new HashSet();
        gasHazmatList = new HashSet();
        bioHazmatList = new HashSet();
        frostHazmatList = new HashSet();
        heatHazmatList = new HashSet();
        radioHazmatList = new HashSet();
        electroHazmatList = new HashSet();
        dimensionalList = new HashSet<Integer>();
        oreBlockTable = new HashMap<DustMaterial, Map<StoneType, IBlockOre>>();
    }
}

