/*
 * Decompiled with CFR 0.152.
 */
package com.astro.watercontrolextreme;

import com.astro.watercontrolextreme.WCEConfig;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="watercontrolextreme", name="Water Control Extreme", version="1.0.0", acceptedMinecraftVersions="[1.12.2]")
public class WaterControlExtreme {
    public static final String MODID = "watercontrolextreme";
    public static final String NAME = "Water Control Extreme";
    public static final String VERSION = "1.0.0";

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nonnull
    private String getFluidName(@Nonnull Block block) {
        if (block instanceof BlockFluidBase) {
            return ((BlockFluidBase)block).getFluid().getName();
        }
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            return FluidRegistry.WATER.getName();
        }
        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return FluidRegistry.LAVA.getName();
        }
        return "null";
    }

    @SubscribeEvent
    public void handleFiniteFluids(BlockEvent.CreateFluidSourceEvent event) {
        IBlockState state = event.getState();
        String name = this.getFluidName(state.func_177230_c());
        if (name.equalsIgnoreCase("null")) {
            return;
        }
        BlockPos pos = event.getPos();
        int height = pos.func_177956_o();
        if (height >= WCEConfig.minHeight && height <= WCEConfig.maxHeight) {
            int i2;
            World world = event.getWorld();
            Biome biome = world.getBiomeForCoordsBody(pos);
            String biomeName = biome.getRegistryName().toString();
            for (int i1 = 0; i1 < WCEConfig.infiniteBiomes.length; ++i1) {
                String configName = WCEConfig.infiniteBiomes[i1];
                if (!biomeName.equals(configName)) continue;
                return;
            }
            int dimId = world.field_73011_w.getDimension();
            for (i2 = 0; i2 < WCEConfig.infiniteDimensions.length; ++i2) {
                int configDim = WCEConfig.infiniteDimensions[i2];
                if (configDim != dimId) continue;
                return;
            }
            for (i2 = 0; i2 < WCEConfig.finiteFluids.length; ++i2) {
                String fluid = WCEConfig.finiteFluids[i2];
                if (!fluid.equals(name)) continue;
                event.setResult(Event.Result.DENY);
                return;
            }
        } else {
            for (int i1 = 0; i1 < WCEConfig.finiteFluids.length; ++i1) {
                String fluid = WCEConfig.finiteFluids[i1];
                if (!fluid.equals(name)) continue;
                event.setResult(Event.Result.DENY);
                return;
            }
        }
    }
}

