/*
 * Decompiled with CFR 0.152.
 */
package de.lellson.roughmobs2.misc;

import de.lellson.roughmobs2.config.RoughConfig;
import de.lellson.roughmobs2.misc.AttributeHelper;
import de.lellson.roughmobs2.misc.Constants;
import de.lellson.roughmobs2.misc.EquipHelper;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityZombie;

public class BossHelper {
    public static final Random RND = new Random();
    public static final String BOSS = Constants.unique("isBoss");

    public static boolean isBoss(Entity entity) {
        return entity.getEntityData() != null && entity.getEntityData().func_74767_n(BOSS);
    }

    public static abstract class BossApplier {
        private EquipHelper.EquipmentApplier equipApplier;
        private final String name;
        private final int defaultBossChance;
        private final float defaultEnchMultiplier;
        private final float defaultDropChance;
        private final String[] defaultBossNames;
        private int bossChance;
        private String[] bossNames;

        public BossApplier(String name, int defaultBossChance, float defaultEnchMultiplier, float defaultDropChance, String[] defaultBossNames) {
            this.name = name;
            this.defaultBossChance = defaultBossChance;
            this.defaultEnchMultiplier = defaultEnchMultiplier;
            this.defaultDropChance = defaultDropChance;
            this.defaultBossNames = defaultBossNames;
            this.equipApplier = new EquipHelper.EquipmentApplier(name + " boss", 1, 1, 1, defaultEnchMultiplier, defaultDropChance);
        }

        public void initConfig() {
            this.equipApplier.initConfig(Constants.DEFAULT_BOSS_MAINHAND, Constants.DEFAULT_BOSS_OFFHAND, Constants.DEFAULT_BOSS_HELMETS, Constants.DEFAULT_BOSS_CHESTPLATES, Constants.DEFAULT_BOSS_LEGGINGS, Constants.DEFAULT_BOSS_BOOTS, Constants.DEFAULT_WEAPON_ENCHANTS, Constants.DEFAULT_ARMOR_ENCHANTS, true);
            this.bossChance = RoughConfig.getInteger(this.name, "BossChance", this.defaultBossChance, 0, Short.MAX_VALUE, "Chance (1 in X) for a newly spawned " + this.name + " to become a boss " + this.name);
            this.bossNames = RoughConfig.getStringArray(this.name, "BossNames", this.defaultBossNames, this.name + " boss names. Please be more creative than I am... :P");
        }

        public void postInit() {
            this.equipApplier.createPools();
        }

        public void trySetBoss(EntityLiving entity) {
            if (this.bossChance <= 0 || RND.nextInt(this.bossChance) != 0 || entity instanceof EntityZombie && ((EntityZombie)entity).func_70631_g_()) {
                return;
            }
            AttributeHelper.applyAttributeModifier((EntityLivingBase)entity, SharedMonsterAttributes.field_111267_a, this.name + "BossHealth", 0, entity.func_110138_aP() * 2.0f);
            AttributeHelper.applyAttributeModifier((EntityLivingBase)entity, SharedMonsterAttributes.field_111266_c, this.name + "BossKnock", 1, 1.0);
            this.equipApplier.equipEntity(entity);
            entity.func_96094_a(this.bossNames[RND.nextInt(this.bossNames.length)]);
            entity.getEntityData().func_74757_a(BOSS, true);
            this.addBossFeatures(entity);
        }

        public abstract void addBossFeatures(EntityLiving var1);
    }
}

