/*
 * Decompiled with CFR 0.152.
 */
package com.teamdman.animus.rituals;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

@RitualRegister(value="ritualSteadfastHeart")
public class RitualSteadfastHeart
extends Ritual {
    public static final String EFFECT_RANGE = "effect";
    public final int maxWill = 100;
    public double willBuffer = 0.0;

    public RitualSteadfastHeart() {
        super("ritualSteadfastHeart", 0, 20000, "ritual.animus.ritualSteadfastHeart");
        this.addBlockRange(EFFECT_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-16, -16, -16), 32));
        this.setMaximumVolumeAndDistanceOfRange(EFFECT_RANGE, 0, 15, 15);
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.willBuffer = tag.func_74769_h("willBuffer");
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74780_a("willBuffer", this.willBuffer);
    }

    public void performRitual(IMasterRitualStone masterRitualStone) {
        SoulNetwork network = NetworkHelper.getSoulNetwork((UUID)masterRitualStone.getOwner());
        if (network == null) {
            return;
        }
        World world = masterRitualStone.getWorldObj();
        EnumDemonWillType type = EnumDemonWillType.STEADFAST;
        BlockPos pos = masterRitualStone.getBlockPos();
        double currentAmount = WorldDemonWillHandler.getCurrentWill((World)world, (BlockPos)pos, (EnumDemonWillType)type);
        AreaDescriptor damageRange = this.getBlockRange(EFFECT_RANGE);
        AxisAlignedBB range = damageRange.getAABB(pos);
        List list = world.func_72872_a(EntityLivingBase.class, range);
        int entityCount = 0;
        Potion absPotion = MobEffects.field_76444_x;
        for (EntityLivingBase livingEntity : list) {
            if (!(livingEntity instanceof EntityPlayer) || livingEntity instanceof FakePlayer) continue;
            ++entityCount;
            PotionEffect abs = livingEntity.func_70660_b(absPotion);
            int dur = 0;
            if (abs != null) {
                dur = abs.func_76459_b();
                livingEntity.func_184589_d(abs.func_188419_a());
            }
            int newdur = Math.min((dur + 800) * 2, 30000);
            int pow = Math.min(5 * (1 + (newdur + 60)) / 36000, 4);
            livingEntity.func_70690_d(new PotionEffect(absPotion, newdur, pow, true, false));
        }
        network.syphon(new SoulTicket((ITextComponent)new TextComponentTranslation("text.component.animus.ticket.steadfast", new Object[0]), this.getRefreshCost() * entityCount));
        double drainAmount = 2.0 * Math.min(100.0 - currentAmount + 1.0, (double)Math.min(entityCount / 2, 10));
        double filled = WorldDemonWillHandler.fillWillToMaximum((World)world, (BlockPos)pos, (EnumDemonWillType)type, (double)drainAmount, (double)100.0, (boolean)false);
        if (filled > 0.0) {
            WorldDemonWillHandler.fillWillToMaximum((World)world, (BlockPos)pos, (EnumDemonWillType)type, (double)filled, (double)100.0, (boolean)true);
        }
    }

    public int getRefreshCost() {
        return 100;
    }

    public int getRefreshTime() {
        return 600;
    }

    public void gatherComponents(Consumer<RitualComponent> components) {
        components.accept(new RitualComponent(new BlockPos(1, 0, 1), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(-1, 0, 1), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(1, 0, -1), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(-1, 0, -1), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(0, -1, 0), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(2, -1, 2), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(2, -1, -2), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(-2, -1, 2), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(-2, -1, -2), EnumRuneType.WATER));
    }

    public Ritual getNewCopy() {
        return new RitualSteadfastHeart();
    }
}

