/*
 * Decompiled with CFR 0.152.
 */
package com.teamdman.animus.rituals;

import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

@RitualRegister(value="ritualSol")
public class RitualSol
extends Ritual {
    public static final String CHEST_RANGE = "chest";
    public static final String EFFECT_RANGE = "effect";

    public RitualSol() {
        super("ritualSol", 0, 1000, "ritual.animus.ritualSol");
        this.addBlockRange(EFFECT_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-32, -32, -32), 65));
        this.addBlockRange(CHEST_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(EFFECT_RANGE, 0, 128, 128);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        SoulNetwork network = NetworkHelper.getSoulNetwork((UUID)masterRitualStone.getOwner());
        BlockPos masterPos = masterRitualStone.getBlockPos();
        AreaDescriptor chestRange = this.getBlockRange(CHEST_RANGE);
        TileEntityChest tileInventory = (TileEntityChest)world.func_175625_s((BlockPos)chestRange.getContainedPositions(masterPos).get(0));
        if (tileInventory == null) {
            return;
        }
        IItemHandler handler = tileInventory.getSingleChestHandler();
        if (!masterRitualStone.getWorldObj().field_72995_K) {
            Optional<Integer> slot = Stream.iterate(0, n -> {
                n = n + 1;
                return n;
            }).limit(handler.getSlots() - 1).filter(e -> !handler.getStackInSlot(e.intValue()).func_190926_b()).filter(e -> this.isOkayToUse(handler.getStackInSlot(e.intValue()))).findAny();
            if (!slot.isPresent()) {
                return;
            }
            Optional<BlockPos> toPlace = this.getBlockRange(EFFECT_RANGE).getContainedPositions(masterRitualStone.getBlockPos()).stream().filter(arg_0 -> ((World)world).func_175623_d(arg_0)).filter(e -> world.func_175671_l(e) < 8).filter(e -> world.isSideSolid(e.func_177979_c(1), EnumFacing.UP)).findFirst();
            if (!toPlace.isPresent()) {
                return;
            }
            IBlockState state = this.getStateToUse(handler.getStackInSlot(slot.get().intValue()));
            world.func_175656_a(toPlace.get(), state);
            if (state.func_177230_c() != RegistrarBloodMagicBlocks.BLOOD_LIGHT) {
                handler.extractItem(slot.get().intValue(), 1, false);
            }
            network.syphon(new SoulTicket((ITextComponent)new TextComponentTranslation("text.component.animus.ticket.sol", new Object[0]), this.getRefreshCost()));
        }
    }

    private boolean isOkayToUse(ItemStack in) {
        return !in.func_190926_b() && (in.func_77973_b() == RegistrarBloodMagicItems.SIGIL_BLOOD_LIGHT || Block.func_149634_a((Item)in.func_77973_b()) != Blocks.field_150350_a);
    }

    private IBlockState getStateToUse(ItemStack in) {
        if (in.func_77973_b() == RegistrarBloodMagicItems.SIGIL_BLOOD_LIGHT) {
            return RegistrarBloodMagicBlocks.BLOOD_LIGHT.func_176223_P();
        }
        return Block.func_149634_a((Item)in.func_77973_b()).func_176203_a(in.func_77952_i());
    }

    public int getRefreshCost() {
        return 1;
    }

    public int getRefreshTime() {
        return 5;
    }

    public void gatherComponents(Consumer<RitualComponent> components) {
        for (int layer = 0; layer < 3; ++layer) {
            components.accept(new RitualComponent(new BlockPos(2, layer, 2), EnumRuneType.AIR));
            components.accept(new RitualComponent(new BlockPos(-2, layer, 2), EnumRuneType.AIR));
            components.accept(new RitualComponent(new BlockPos(2, layer, -2), EnumRuneType.AIR));
            components.accept(new RitualComponent(new BlockPos(-2, layer, -2), EnumRuneType.AIR));
        }
    }

    public Ritual getNewCopy() {
        return new RitualSol();
    }
}

