/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.tinkersextras;

import com.mjr.tinkersextras.Config;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import slimeknights.tconstruct.library.events.MaterialEvent;
import slimeknights.tconstruct.library.events.TinkerCraftingEvent;
import slimeknights.tconstruct.library.events.TinkerRegisterEvent;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.TinkerToolCore;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.smeltery.events.TinkerCastingEvent;

public class EventHandlerMain {
    @SubscribeEvent
    public void onModifierRegister(TinkerRegisterEvent.ModifierRegisterEvent event) {
        if (Config.outputToConsole) {
            LogManager.getLogger().info("tinkersextras: Modifier: " + ((IModifier)event.getRecipe()).getIdentifier());
        }
    }

    @SubscribeEvent
    public void onMaterialRegister(MaterialEvent.MaterialRegisterEvent event) {
        if (Config.outputToConsole) {
            LogManager.getLogger().info("tinkersextras: Material: " + event.material.identifier);
        }
        for (String temp : Config.materialListRemoval) {
            if (!event.material.identifier.equalsIgnoreCase(temp)) continue;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onMaterialIntegration(MaterialEvent.IntegrationEvent event) {
        if (event.material == null) {
            return;
        }
        for (String temp : Config.materialListRemoval) {
            if (!event.material.identifier.equalsIgnoreCase(temp)) continue;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onToolPartReplace(TinkerCraftingEvent.ToolPartReplaceEvent event) {
        if (Config.disableReplacing) {
            event.setCanceled("Replacing of Parts has been disabled!");
            return;
        }
        for (ItemStack temp : event.getToolParts()) {
            if (temp.func_190926_b()) continue;
            Material material = TinkerUtil.getMaterialFromStack((ItemStack)temp);
            for (String temp2 : Config.disableReplacingList) {
                if (!material.identifier.equalsIgnoreCase(temp2)) continue;
                event.setCanceled("You can not use " + temp.func_82833_r() + " as a replacement part!");
                return;
            }
        }
    }

    @SubscribeEvent
    public void ToolModify(TinkerCraftingEvent.ToolModifyEvent event) {
        if (Config.disableModifying) {
            event.setCanceled("The use of Modifiers has been disabled!");
            return;
        }
        for (IModifier temp : event.getModifiers()) {
            for (String temp2 : Config.disableModifyingList) {
                if (!temp.getIdentifier().equalsIgnoreCase(temp2)) continue;
                event.setCanceled("You can not use " + temp.getLocalizedName() + " as a Modifier!");
                return;
            }
        }
    }

    @SubscribeEvent
    public void onToolPartCrafting(TinkerCraftingEvent.ToolPartCraftingEvent event) {
        Material material = TinkerUtil.getMaterialFromStack((ItemStack)event.getItemStack());
        if (Config.disablePartCreationPB) {
            event.setCanceled("Creation of parts has been disabled!");
            return;
        }
        for (String temp : Config.disablePartCreationList) {
            if (!material.getIdentifier().equalsIgnoreCase(temp)) continue;
            event.setCanceled("You can not use " + material.getLocalizedName() + " for parts creation as its been disabled!");
            return;
        }
        for (String temp : Config.disablePartTypeCreationListPB) {
            if (!event.getItemStack().func_77977_a().toLowerCase().contains(temp.toLowerCase())) continue;
            event.setCanceled("You can not build a " + event.getItemStack().func_82833_r() + " due to its been disabled!");
            return;
        }
        for (String temp : Config.disablePartTypeonMaterialListPB) {
            String partName = temp.substring(0, temp.indexOf(58));
            String materialName = temp.substring(temp.indexOf(58) + 1);
            if (!event.getItemStack().func_77977_a().toLowerCase().contains(partName.toLowerCase()) || !((IMaterialItem)event.getItemStack().func_77973_b()).getMaterial(event.getItemStack()).getIdentifier().toLowerCase().equals(materialName.toLowerCase())) continue;
            event.setCanceled("You can not build a " + event.getItemStack().func_82833_r() + " due to its been disabled!");
            return;
        }
    }

    @SubscribeEvent
    public void onSmelteryPartCreation(TinkerCastingEvent.OnCasting event) {
        if (event.recipe instanceof CastingRecipe) {
            CastingRecipe recipe = (CastingRecipe)event.recipe;
            if (recipe == null) {
                return;
            }
            ItemStack output = recipe.getResult();
            if (output == null) {
                return;
            }
            for (String temp : Config.disablePartTypeCreationListSM) {
                if (!output.func_77977_a().toLowerCase().contains(temp.toLowerCase())) continue;
                event.setCanceled(true);
                return;
            }
            if (output.func_77973_b() instanceof IToolPart) {
                if (Config.disablePartCreationSM) {
                    event.setCanceled(true);
                    return;
                }
                IMaterialItem item = (IMaterialItem)output.func_77973_b();
                for (String temp : Config.disablePartCreationList) {
                    if (!item.getMaterial(output).getIdentifier().equalsIgnoreCase(temp)) continue;
                    event.setCanceled(true);
                    return;
                }
                for (String temp : Config.disablePartTypeonMaterialListSM) {
                    String partName = temp.substring(0, temp.indexOf(58));
                    String materialName = temp.substring(temp.indexOf(58) + 1);
                    if (!output.func_77977_a().toLowerCase().contains(partName.toLowerCase()) || !item.getMaterial(output).getIdentifier().toLowerCase().equals(materialName.toLowerCase())) continue;
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public void onToolCrafting(TinkerCraftingEvent.ToolCraftingEvent event) {
        if (Config.disableToolCreation) {
            event.setCanceled("Creation of tools has been disabled!");
            return;
        }
        for (String temp : Config.disableToolCreationList) {
            if (!(event.getItemStack().func_77973_b() instanceof TinkerToolCore) || !((TinkerToolCore)event.getItemStack().func_77973_b()).getIdentifier().toLowerCase().equals(temp.toLowerCase())) continue;
            event.setCanceled("You can not create a " + event.getItemStack().func_82833_r() + " due to its been disabled!");
            return;
        }
        for (String temp : Config.disableToolonMaterialList) {
            String toolName = temp.substring(0, temp.indexOf(58));
            String materialName = temp.substring(temp.indexOf(58) + 1);
            if (!(event.getItemStack().func_77973_b() instanceof TinkerToolCore) || !((TinkerToolCore)event.getItemStack().func_77973_b()).getIdentifier().toLowerCase().equals(toolName) || !((IMaterialItem)((ItemStack)event.getToolParts().get(1)).func_77973_b()).getMaterial((ItemStack)event.getToolParts().get(1)).getIdentifier().toLowerCase().equals(materialName.toLowerCase())) continue;
            event.setCanceled("You can not create a " + event.getItemStack().func_82833_r() + " due to its been disabled!");
            return;
        }
    }

    @SubscribeEvent
    public void onTraitRegister(MaterialEvent.TraitRegisterEvent event) {
        if (Config.disableTraits) {
            event.setCanceled(true);
            return;
        }
        for (String temp : Config.disableTraitsList) {
            if (!temp.equalsIgnoreCase(event.trait.getIdentifier())) continue;
            event.setCanceled(true);
            return;
        }
    }
}

