/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.selection.mode;

import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.mods.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.selection.mode.AreaSelectionMode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class SelectionMode {
    private static LinkedHashMap<String, SelectionMode> modes = new LinkedHashMap();
    public static SelectionMode area = new AreaSelectionMode();
    public final String name;

    public static SelectionMode getMode(String id) {
        return modes.get(id);
    }

    public static SelectionMode getOrDefault(String id) {
        return modes.getOrDefault(id, area);
    }

    public static List<String> names() {
        return new ArrayList<String>(modes.keySet());
    }

    public SelectionMode(String name) {
        this.name = "mode.selection." + name;
        modes.put(this.name, this);
    }

    public abstract SelectionResult generateResult(World var1, ItemStack var2);

    public abstract void onLeftClick(EntityPlayer var1, ItemStack var2, BlockPos var3);

    public abstract void onRightClick(EntityPlayer var1, ItemStack var2, BlockPos var3);

    public abstract void clearSelection(ItemStack var1);

    public abstract LittlePreviews getPreviews(World var1, ItemStack var2, boolean var3, boolean var4, boolean var5, boolean var6);

    public void saveSelection(ItemStack stack) {
    }

    public static class SelectionResult {
        public final World world;
        public BlockPos.MutableBlockPos min = null;
        public BlockPos.MutableBlockPos max = null;
        public int blocks;
        public int ltBlocks = 0;
        public int ltTiles = 0;
        public LittleGridContext minLtContext = null;
        public int cbBlocks = 0;
        public int cbTiles = 0;
        public LittleGridContext minCBContext = null;

        public SelectionResult(World world) {
            this.world = world;
        }

        private void addBlockDirectly(BlockPos pos) {
            IBlockState state;
            LittlePreviews specialPreviews;
            TileEntity te = this.world.func_175625_s(pos);
            if (te instanceof TileEntityLittleTiles) {
                ++this.ltBlocks;
                this.ltTiles += ((TileEntityLittleTiles)te).getTiles().size();
                this.minLtContext = this.minLtContext == null ? ((TileEntityLittleTiles)te).getContext() : LittleGridContext.max(this.minLtContext, ((TileEntityLittleTiles)te).getContext());
            }
            if ((specialPreviews = ChiselsAndBitsManager.getPreviews(te)) != null) {
                ++this.cbBlocks;
                this.cbTiles += specialPreviews.size();
                this.minCBContext = this.minCBContext == null ? specialPreviews.context : LittleGridContext.max(this.minCBContext, specialPreviews.context);
            }
            if (LittleAction.isBlockValid((state = this.world.func_180495_p(pos)).func_177230_c())) {
                ++this.blocks;
            }
        }

        public void addBlock(BlockPos pos) {
            if (this.min == null) {
                this.min = new BlockPos.MutableBlockPos(pos);
                this.max = new BlockPos.MutableBlockPos(pos);
            } else {
                this.min.func_181079_c(Math.min(this.min.func_177958_n(), pos.func_177958_n()), Math.min(this.min.func_177956_o(), pos.func_177956_o()), Math.min(this.min.func_177952_p(), pos.func_177952_p()));
                this.max.func_181079_c(Math.max(this.max.func_177958_n(), pos.func_177958_n()), Math.max(this.max.func_177956_o(), pos.func_177956_o()), Math.max(this.max.func_177952_p(), pos.func_177952_p()));
            }
            this.addBlockDirectly(pos);
        }

        public void addBlocks(BlockPos pos, BlockPos pos2) {
            int minX = Math.min(pos.func_177958_n(), pos2.func_177958_n());
            int minY = Math.min(pos.func_177956_o(), pos2.func_177956_o());
            int minZ = Math.min(pos.func_177952_p(), pos2.func_177952_p());
            int maxX = Math.max(pos.func_177958_n(), pos2.func_177958_n());
            int maxY = Math.max(pos.func_177956_o(), pos2.func_177956_o());
            int maxZ = Math.max(pos.func_177952_p(), pos2.func_177952_p());
            if (this.min == null) {
                this.min = new BlockPos.MutableBlockPos(minX, minY, minZ);
                this.max = new BlockPos.MutableBlockPos(maxX, maxY, maxZ);
            } else {
                this.min.func_181079_c(Math.min(this.min.func_177958_n(), minX), Math.min(this.min.func_177956_o(), minY), Math.min(this.min.func_177952_p(), minZ));
                this.max.func_181079_c(Math.max(this.max.func_177958_n(), minX), Math.max(this.max.func_177956_o(), minY), Math.max(this.max.func_177952_p(), minZ));
            }
            BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos();
            for (int posX = minX; posX <= maxX; ++posX) {
                for (int posY = minY; posY <= maxY; ++posY) {
                    for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                        this.addBlockDirectly((BlockPos)mutPos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
        }

        public Vec3i getSize() {
            return new Vec3i(this.max.func_177958_n() - this.min.func_177958_n(), this.max.func_177956_o() - this.min.func_177956_o(), this.max.func_177952_p() - this.min.func_177952_p());
        }
    }
}

