/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.ingredients;

import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.utils.ingredients.ColorUnit;
import com.creativemd.littletiles.common.utils.ingredients.StackIngredient;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class Ingredients {
    public ColorUnit color;
    public BlockIngredient.BlockIngredients block;
    private List<StackIngredient> stacks = new ArrayList<StackIngredient>();

    public Ingredients() {
        this(new ColorUnit(), new BlockIngredient.BlockIngredients());
    }

    public Ingredients(ColorUnit color, BlockIngredient.BlockIngredients block) {
        this.color = color;
        this.block = block;
    }

    public Ingredients add(Ingredients ingredients) {
        if (this.color == null) {
            this.color = ingredients.color;
        } else if (ingredients.color != null) {
            this.color.addColorUnit(ingredients.color);
        }
        if (this.block == null) {
            this.block = ingredients.block;
        } else if (ingredients.block != null) {
            this.block.addIngredients(ingredients.block);
        }
        if (this.stacks == null) {
            this.stacks = ingredients.stacks;
        } else if (ingredients.stacks != null) {
            for (StackIngredient stack : this.stacks) {
                this.addStack(stack);
            }
        }
        return this;
    }

    public void addPreview(LittleGridContext context, List<LittleTilePreview> previews) {
        for (LittleTilePreview preview : previews) {
            this.addPreview(context, preview);
        }
    }

    public void addPreview(LittleGridContext context, LittleTilePreview preview) {
        if (preview.canBeConvertedToBlockEntry()) {
            this.block.addIngredient(preview.getBlockIngredient(context));
            this.color.addColorUnit(ColorUnit.getColors(context, preview));
        }
    }

    public void addPreview(LittleTilePreview preview, double volume) {
        if (preview.canBeConvertedToBlockEntry()) {
            BlockIngredient ingredient = preview.getBlockIngredient(LittleGridContext.get());
            ingredient.value = volume;
            this.block.addIngredient(ingredient);
            this.color.addColorUnit(ColorUnit.getColors(preview, volume));
        }
    }

    public List<StackIngredient> getStacks() {
        return this.stacks;
    }

    public void addStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        StackIngredient ingredient = new StackIngredient(stack);
        int index = this.stacks.indexOf(ingredient);
        if (index == -1) {
            this.stacks.add(ingredient);
        } else {
            this.stacks.get((int)index).count += stack.func_190916_E();
        }
    }

    public void addStack(StackIngredient ingredient) {
        int index = this.stacks.indexOf(ingredient);
        if (index == -1) {
            this.stacks.add(ingredient);
        } else {
            this.stacks.get((int)index).count += ingredient.count;
        }
    }

    public void addStack(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            this.addStack(inventory.func_70301_a(i));
        }
    }

    public boolean hasStacks() {
        return this.stacks != null && !this.stacks.isEmpty();
    }
}

