/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.ingredients;

import com.creativemd.creativecore.common.utils.sorting.BlockSelector;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviewsStructure;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredientRule;
import com.creativemd.littletiles.common.utils.ingredients.ColorUnit;
import com.creativemd.littletiles.common.utils.ingredients.Ingredients;
import com.creativemd.littletiles.common.utils.placing.PlacementHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class IngredientUtils {
    private static PairList<BlockSelector, BlockIngredientRule> rules = new PairList();

    public static void registerRule(BlockSelector selector, BlockIngredientRule rule) {
        rules.add((Object)selector, (Object)rule);
    }

    public static BlockIngredient getBlockIngredient(Block block, int meta, double value) {
        for (Pair pair : rules) {
            if (!((BlockSelector)pair.key).is(block, meta)) continue;
            return ((BlockIngredientRule)pair.value).getBlockIngredient(block, meta, value);
        }
        return new BlockIngredient(block, meta, value);
    }

    public static BlockIngredient getBlockIngredient(NBTTagCompound nbt) {
        Block block = Block.func_149684_b((String)nbt.func_74779_i("block"));
        if (block == null || block instanceof BlockAir) {
            return null;
        }
        if (nbt.func_74769_h("volume") > 0.0) {
            return new BlockIngredient(block, nbt.func_74762_e("meta"), nbt.func_74769_h("volume"));
        }
        return null;
    }

    public static BlockIngredient getBlockIngredientOfBlockStack(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block != null && !(block instanceof BlockAir) && LittleAction.isBlockValid(block)) {
            return IngredientUtils.getBlockIngredient(block, stack.func_77952_i(), 1.0);
        }
        return null;
    }

    private static void getIngredients(Ingredients ingredients, LittlePreviews previews) {
        for (LittleTilePreview preview : previews) {
            if (!preview.canBeConvertedToBlockEntry()) continue;
            ingredients.block.addIngredient(preview.getBlockIngredient(previews.context));
            ingredients.color.addColorUnit(ColorUnit.getColors(previews.context, preview));
        }
        if (previews.hasStructure()) {
            previews.getStructure().addIngredients(ingredients);
        }
        if (previews.hasChildren()) {
            for (LittlePreviewsStructure child : previews.getChildren()) {
                IngredientUtils.getIngredients(ingredients, child);
            }
        }
    }

    public static Ingredients getIngredients(LittlePreviews previews) {
        Ingredients ingredients = new Ingredients();
        IngredientUtils.getIngredients(ingredients, previews);
        return ingredients;
    }

    private static void getIngredientsStructure(Ingredients ingredients, LittlePreviews previews) {
        if (previews.hasStructure()) {
            previews.getStructure().addIngredients(ingredients);
        }
        if (previews.hasChildren()) {
            for (LittlePreviewsStructure child : previews.getChildren()) {
                IngredientUtils.getIngredientsStructure(ingredients, child);
            }
        }
    }

    public static Ingredients getStructureIngredients(LittlePreviews previews) {
        Ingredients ingredients = new Ingredients();
        IngredientUtils.getIngredientsStructure(ingredients, previews);
        return ingredients;
    }

    public static Ingredients getIngredientsOfStack(ItemStack stack) {
        if (!stack.func_190926_b()) {
            LittlePreviews previews;
            ILittleTile tile = PlacementHelper.getLittleInterface(stack);
            if (tile != null && tile.hasLittlePreview(stack) && tile.containsIngredients(stack) && (previews = tile.getLittlePreview(stack)) != null) {
                return IngredientUtils.getIngredients(previews);
            }
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block != null && !(block instanceof BlockAir) && LittleAction.isBlockValid(block)) {
                Ingredients ingredients = new Ingredients();
                ingredients.block.addIngredient(IngredientUtils.getBlockIngredient(block, stack.func_77952_i(), 1.0));
                return ingredients;
            }
        }
        return null;
    }
}

