/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.animation;

import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.littletiles.common.utils.animation.Animation;
import com.creativemd.littletiles.common.utils.animation.AnimationState;
import com.creativemd.littletiles.common.utils.animation.AnimationTimeline;
import java.util.HashMap;

public class AnimationController {
    protected HashMap<String, AnimationState> states = new HashMap();
    protected HashMap<String, AnimationTimeline> stateTransition = new HashMap();
    protected AnimationState currentState;
    protected AnimationState aimedState;
    protected AnimationTimeline animation;

    public AnimationController addStateAndSelect(AnimationState state) {
        this.states.put(state.name, state);
        this.currentState = state;
        return this;
    }

    public AnimationController addState(AnimationState state) {
        this.states.put(state.name, state);
        return this;
    }

    public AnimationController generateAllTransistions(long duration) {
        for (String key : this.states.keySet()) {
            for (String key2 : this.states.keySet()) {
                if (key.equals(key2)) continue;
                this.generateTransition(key, key2, duration);
            }
        }
        return this;
    }

    public AnimationTimeline getAnimation() {
        return this.animation;
    }

    public AnimationState getCurrentState() {
        return this.currentState;
    }

    public AnimationState getAimedState() {
        return this.aimedState;
    }

    public AnimationController generateTransition(String from, String to, long duration) {
        AnimationState fromState = this.states.get(from);
        if (fromState == null) {
            throw new RuntimeException("State '" + from + "' does not exist");
        }
        AnimationState toState = this.states.get(to);
        if (toState == null) {
            throw new RuntimeException("State '" + to + "' does not exist");
        }
        PairList animations = new PairList();
        if (fromState.offset != null) {
            if (toState.offset != null) {
                animations.add((Object)0L, (Object)fromState.offset.createAnimationTo(toState.offset, duration));
            } else {
                animations.add((Object)0L, (Object)fromState.offset.createAnimationToZero(duration));
            }
        } else if (toState.offset != null) {
            animations.add((Object)0L, (Object)toState.offset.createAnimationFromZero(duration));
        }
        if (fromState.rotation != null) {
            if (toState.rotation != null) {
                animations.add((Object)0L, (Object)fromState.rotation.createAnimationTo(toState.rotation, duration));
            } else {
                animations.add((Object)0L, (Object)fromState.rotation.createAnimationToZero(duration));
            }
        } else if (toState.rotation != null) {
            animations.add((Object)0L, (Object)toState.rotation.createAnimationFromZero(duration));
        }
        this.stateTransition.put(from + ":" + to, new AnimationTimeline(duration, (PairList<Long, Animation>)animations));
        return this;
    }

    public AnimationController removeTransition(String from, String to) {
        this.stateTransition.remove(from + ":" + to);
        return this;
    }

    public AnimationController addTransition(String from, String to, AnimationTimeline animation) {
        return this.addTransition(from + ":" + to, animation);
    }

    public AnimationController addTransition(String key, AnimationTimeline animation) {
        this.stateTransition.put(key, animation);
        return this;
    }

    public boolean isChanging() {
        return this.aimedState != null;
    }

    public AnimationState getState(String key) {
        return this.states.get(key);
    }

    public boolean hasState(String key) {
        return this.states.containsKey(key);
    }

    public void startTransition(String key) {
        AnimationState state = this.states.get(key);
        if (state == null) {
            throw new RuntimeException("State '" + key + "' does not exist");
        }
        this.aimedState = state;
        this.animation = this.stateTransition.get(this.currentState.name + ":" + this.aimedState.name);
        if (this.animation == null) {
            throw new RuntimeException("Couldn't animate from '" + this.currentState.name + "' to '" + this.aimedState.name + "'");
        }
    }

    public void endTransition() {
        this.currentState = this.aimedState;
        this.animation = null;
        this.aimedState = null;
    }

    public AnimationState tick() {
        if (this.isChanging()) {
            if (this.animation.tick(this)) {
                return this.animation.currentState;
            }
            this.endTransition();
        }
        return this.currentState;
    }
}

